$(document).ready(function(){
    console.log("2开始");
    I18n.load([
        "sis_home_page_unit",
        "sis_home_page_package_sum",
        "sis_home_page_package_alarm_sum",
        "sis_home_page_gate_sum",
        "sis_home_page_state_off_line",
        "sis_home_page_state_on_line",
        "sis_home_page_dev_on_line",
        "sis_home_page_gate_on_line",
        "sis_home_page_vid_on_line",
        "sis_home_page_state_on_line",
        "sis_home_page_shang_hai",
        "sis_home_page_security_online_status",
        "sis_home_page_device_count",
        "sis_home_page_offline_rate",
        "sis_home_page_online_rate",
        "sis_board_knife",
        "sis_borad_liquid",
        "sis_borad_lighter",
        "sis_borad_guns",
        "sis_borad_Inflammable",
        "sis_borad_lithiumBattery",
        "sis_borad_metal",
        "sis_borad_policeEquipment",
        "sis_borad_other"
    ], true);
    // 数据填充
    let device_total=document.getElementById('device_total')
    device_total.innerText='111'								//设置安检数量
    let door_total=document.getElementById('door_total')
    door_total.innerText='222'								//设置安检门数量

    let pie_echart1 = echarts.init(document.getElementById('pie1'))
    let pie_echart2 = echarts.init(document.getElementById('pie2'))
    let pie_echart3 = echarts.init(document.getElementById('pie3'))
    let pie_echart4 = echarts.init(document.getElementById('pie4'))

    let d1 = [
        { value: 15, name: 'hao' },
        { value: 100 - 15, name: 'huai' }
    ]
    let color1 = 'rgba(0, 255, 255, 1)'
    var text1 = '80%';    												 //数值占百分比
    let titleTop1 = '45%'

    let d2 = [
        { value: 15, name: 'hao' },
        { value: 100 - 15, name: 'huai' }
    ]
    let color2 = 'rgba(12, 129, 254, 1)'
    let radiu2 = ['80%', '99%']
    var text2 = '90%';
    let titleTop2 = '40%'

    let color3 = 'rgba(0, 255, 255, 1)'
    let radiu3 = ['80%', '99%']
    let text3 = '60%'
    let titleTop3 = '45%'

    let color4 = 'rgba(12, 129, 254, 1)'
    let text4 = '60%'
    let titleTop4 = '40%'

    function initDevStateSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var devClient = Web.getSocket({
            id : "devClient",
            url : "sisRTMonitor/getDeviceState",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                // devStateData = data.data.data; // 安检机在线状态
                device_total.innerText = data.sum.sumCount + " " + I18n.getValue("sis_home_page_unit"); // 安检机数量
                text3 = data.onLineRate;
                text4 = data.offLineRate;
                var devonLineCount = data.onLineCount;
                var devoffLineCount = data.offLineCount;
                let d3 = [
                    { value: devonLineCount, name: I18n.getValue("sis_home_page_online_rate") + text3 }
                ]
                let d4 = [
                    { value: devoffLineCount, name: I18n.getValue("sis_home_page_offline_rate") + text4 }
                ]
                pie_echart3.setOption(makeOptionOne(d3, color3, text3, titleTop3));
                pie_echart4.setOption(makeOptionOne(d4, color4, text4, titleTop4));
            }
        });
        return devClient;
    }
    var devClient = initDevStateSocket();

    function initGateStateSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var gateClient = Web.getSocket({
            id : "gateClient",
            url : "sisRTMonitor/getGateState",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                door_total.innerText = gateData = data.sum + " " + I18n.getValue("sis_home_page_unit");
                text1 = data.onLineRate;
                text2 = data.offLineRate;

                var geteonLineCount = data.onLineCount;
                var geteoffLineCount = data.offLineCount;

                let d1 = [
                    { value: geteonLineCount, name: I18n.getValue("sis_home_page_online_rate") + text1 }
                ]
                let d2 = [
                    { value: geteoffLineCount, name: I18n.getValue("sis_home_page_offline_rate") + text2 }
                ]
                pie_echart1.setOption(makeOptionOne(d1, color1, text1,titleTop1));
                pie_echart2.setOption(makeOptionOne(d2, color2, text2, titleTop2));
            }
        });
        return gateClient;
    }
    var gateClient = initGateStateSocket();

    function initGateDateDoardSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var gateDateClient = Web.getSocket({
            id : "gateDateClient",
            url : "sisRTMonitor/getGateDateDoard",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                personArray = data.personArray;
                alarmArray = data.alarmArray;
                areaArray = data.areaArray;
                echart_2.setOption(makeOptionTwo(echarts1Array, personArray, alarmArray, areaArray));
            }
        });
        return gateDateClient;
    }
    var gateDateClient = initGateDateDoardSocket();


    function initDoardPackageDateSocket() {
        var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
        var doardPackageClient = Web.getSocket({
            id : "doardPackageClient",
            url : "sisRTMonitor/getDoardPackageDate",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                packageCountArray = data.dateObj.packageCountArray;
                packageAlarmCountArray = data.dateObj.packageAlarmCountArray;
                packageAreaArray = data.dateObj.packageAreaArray;
                echart_4.setOption(makeOptionFour());

                typeArray = data.WarningObj.typeArray;
                countArray = data.WarningObj.countArray;
                echart_5.setOption(makeOptionFive());
            }
        });
        return doardPackageClient;
    }
    var doardPackageClient = initDoardPackageDateSocket();

    getVidDevStateData();

    window.setInterval(function(){
        getVidDevStateData();
        getDevAllData();
        getDevGateOffLineStateData();
    }, 60000);

    getDevStateData();
    function getDevStateData() {
        $.ajax({
            url:"/sisDevice.do?getDevStateData",
            type:"post",
            success:function(data) {
                // devStateData = data.data.data; // 安检机在线状态
                device_total.innerText = data.data.sum.sumCount + " " + I18n.getValue("sis_home_page_unit"); // 安检机数量
                text3 = data.data.onLineRate;
                text4 = data.data.offLineRate;

                door_total.innerText = gateData = data.data.gate.sum + " " + I18n.getValue("sis_home_page_unit");
                text1 = data.data.gate.onLineRate;
                text2 = data.data.gate.offLineRate;

                var devonLineCount = data.data.onLineCount;
                var devoffLineCount = data.data.offLineCount;
                var geteonLineCount = data.data.gate.onLineCount;
                var geteoffLineCount = data.data.gate.offLineCount;
                let d3 = [
                    { value: devonLineCount, name: I18n.getValue("sis_home_page_online_rate") + text3}
                ]
                let d4 = [
                    { value: devoffLineCount, name: I18n.getValue("sis_home_page_offline_rate") + text4}
                ]
                let d1 = [
                    { value: geteonLineCount, name: I18n.getValue("sis_home_page_online_rate") + text1 }
                ]
                let d2 = [
                    { value: geteoffLineCount, name: I18n.getValue("sis_home_page_offline_rate") + text2 }
                ]
                pie_echart3.setOption(makeOptionOne(d3, color3, text3, titleTop3));
                pie_echart4.setOption(makeOptionOne(d4, color4, text4, titleTop4));
                pie_echart1.setOption(makeOptionOne(d1, color1, text1,titleTop1));
                pie_echart2.setOption(makeOptionOne(d2, color2, text2, titleTop2));
            }
        });
    }

    //  安检门离线状态实时推送不好使，改为每分钟获取一次安检门状态
    function getDevGateOffLineStateData() {
        $.ajax({
            url:"/sisDevice.do?getDevStateData",
            type:"post",
            success:function(data) {
                door_total.innerText = gateData = data.data.gate.sum + " " + I18n.getValue("sis_home_page_unit");
                text1 = data.data.gate.onLineRate;
                text2 = data.data.gate.offLineRate;

                var geteonLineCount = data.data.gate.onLineCount;
                var geteoffLineCount = data.data.gate.offLineCount;
                let d1 = [
                    { value: geteonLineCount, name: I18n.getValue("sis_home_page_online_rate") + text1 }
                ]
                let d2 = [
                    { value: geteoffLineCount, name: I18n.getValue("sis_home_page_offline_rate") + text2 }
                ]
                pie_echart1.setOption(makeOptionOne(d1, color1, text1,titleTop1));
                pie_echart2.setOption(makeOptionOne(d2, color2, text2, titleTop2));
            }
        });
    }

    function makeOptionOne(data, color, text, titleTop) {
        let option = {
            title: {
                show: true,
                text: text,
                left: 'center',
                top: 'center',
                textStyle: {
                    fontSize: '15',
                    color: 'white',
                    fontWeight: 'bold'
                }
            },
            tooltip: {
                trigger: 'item',
                formatter: "",
                show: true,
                transitionDuration: 0,
            },
            legend: {
                show: false
            },
            color: [color],
            series:
                {
                    name: '',
                    type: 'pie',
                    center: ['50%', '50%'],
                    radius: ['80%', '99%'],
                    avoidLabelOverlap: true,
                    hoverAnimation: false,
                    itemStyle: {
                        shadowColor: 'rgba(12, 129, 254, 1)',
                        shadowBlur: 0,

                    },
                    label: {
                        normal: {
                            show: false,
                            position: 'center'
                        },
                        emphasis: {
                            show: false
                        }
                    },
                    labelLine: {
                        normal: {
                            show: false
                        }
                    },
                    data: data
                }
        };
        return option
    }


    let echart_2 = echarts.init(document.getElementById('echart_2'))
    let dataX = ['正门', '后门', '左前门', '右前门', '左后门', '右后门']
    let dataV = [2.6, 5.9, 9.0, 26.4, 28.7, 70.7]
    let dataV2 = [9.0, 26.4, 28.7, 2.6, 5.9, 70.7]
    let name1 = '通过人数'
    let name2 = '报警次数'
    let legendData = [name1, name2]


    var personArray = [];
    var alarmArray = [];
    var areaArray = [];
    let echarts1Array = [I18n.getValue("sis_home_page_gate_sum"), I18n.getValue("sis_home_page_package_alarm_sum")]
    getDoardGateDate();
    function getDoardGateDate() {
        $.ajax({
            url:"/sisGazeTransaction.do?getAlarmGateDate",
            type:"post",
            success:function(data) {
                personArray = data.data.personArray;
                alarmArray = data.data.alarmArray;
                areaArray = data.data.areaArray;
                if (areaArray.length == 0) {
                    // areaArray = ['上海','北京'];
                    personArray = [0, 0];
                    alarmArray = [0, 0];
                }
                echart_2.setOption(makeOptionTwo(echarts1Array, personArray, alarmArray, areaArray));
            }
        });
    }

    function makeOptionTwo(echarts1Array, personArray, alarmArray, areaArray) {
        let option = {
            color: ['rgba(231, 131, 249, 1)', 'rgba(0, 250, 255, 1)'],
            tooltip: {
                trigger: 'none',
                axisPointer: {
                    type: 'cross'
                },
                show: true,
                transitionDuration: 0,//echart防止tooltip的抖动
            },
            legend: {
                show: true,
                data: echarts1Array,
                textStyle: {
                    color: '#fff'
                },
            },
            grid: {
                left: 30,
                top: 20,
                bottom: 20
            },
            xAxis: [
                {
                    type: 'category',
                    axisTick: {
                        alignWithLabel: true
                    },
                    axisLine: {
                        onZero: true,
                        lineStyle: {
                            color: 'rgba(33, 224, 253, 1)'
                        }
                    },
                    boundaryGap: false,
                    splitLine: {
                        lineStyle: {
                            color: 'rgba(33, 224, 253, 1)'
                        },
                        show: true,
                    },
                    data: areaArray
                },
            ],
            yAxis: [
                {
                    type: 'value',
                    axisLine: {
                        lineStyle: {
                            color: 'rgba(33, 224, 253, 1)'
                        }
                    },
                    splitLine: {
                        show: false
                    },
                },


            ],
            series: [
                {
                    name: echarts1Array[1],
                    type: 'line',
                    smooth: true,
                    data: alarmArray ,
                    itemStyle: {
                        color: '#6A5ACD',
                        normal: {
                            lineStyle: {        // 系列级个性化折线样式
                                width: 2,
                                type: 'solid',
                                color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                    offset: 0,
                                    color: 'rgba(231, 131, 249, 1)'
                                }, {
                                    offset: 1,
                                    color: 'rgba(231, 131, 249, 1)'
                                }]),//线条渐变色
                            }
                        }
                    },
                    areaStyle: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                            offset: 0,
                            color: 'rgba(0, 210, 255, 1)' // rgba(0, 210, 255, 1)
                        }, {
                            offset: 1,
                            color: 'rgba(121, 55, 255, 0)'
                        }])
                    },
                }, {
                    name: echarts1Array[0],
                    type: 'line',
                    smooth: true,
                    data: personArray,
                    itemStyle: {
                        color: '#6A5ACD',
                        normal: {
                            lineStyle: {        // 系列级个性化折线样式
                                width: 2,
                                type: 'solid',
                                color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                    offset: 0,
                                    color: 'rgba(0, 250, 255, 1)'
                                }, {
                                    offset: 1,
                                    color: 'rgba(0, 250, 255, 1)'
                                }]),//线条渐变色
                            }
                        }
                    },
                    areaStyle: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                            offset: 0,
                            color: 'rgba(0, 210, 255, 1)'
                        }, {
                            offset: 1,
                            color: 'rgba(121, 55, 255, 0)'
                        }])
                    },
                }
            ]
        }
        return option
    }

    let echart_3 = echarts.init(document.getElementById('echart_3'))
    getVidDevStateData();
    var divStateData = [];
    var divSumCount = 0;
    function getVidDevStateData() {
        $.ajax({
            url:"/sisDevice.do?getVidDevStateData",
            type:"post",
            success:function(data) {
                divStateData = data.data.data;
                divSumCount = data.data.sum + " " + I18n.getValue("sis_home_page_unit");
                echart_3.setOption(makeOptionThree())
            }
        });
    }

    function makeOptionThree() {
        let option = {
            color: ['rgba(3, 144, 239, 1)', 'rgba(68, 254, 192, 1)'],
            title: {
                text: I18n.getValue("sis_home_page_device_count")+ '：' + divSumCount,
                top: '20',
                right: '50',
                textStyle: {
                    color: 'rgba(0, 255, 255, 1)',
                    fontWeight: 'normal',
                    fontSize: 12
                }
            },
            tooltip: {
                trigger: 'item',
                formatter: '{a} <br/>{b} : {c} ({d}%)',      //处理鼠标悬浮的显示
                show: true,
                transitionDuration: 0,//echart防止tooltip的抖动
            },
            legend: {
                show: false,
            },
            toolbox: {
                show: false,
            },
            series: [
                {
                    name: I18n.getValue("sis_home_page_security_online_status"),
                    type: 'pie',
                    radius: ['10%', '60%'],
                    center: ['50%', '50%'],
                    roseType: 'radius',
                    label: {
                        show: true
                    },
                    data: divStateData
                }
            ]
        }
        return option
    }

    let echart_4 = echarts.init(document.getElementById('echart_4'))


    var packageCountArray = [];
    var packageAlarmCountArray = [];
    var packageAreaArray = [];
    var echarts5Array = [];
    echarts5Array.push(I18n.getValue("sis_home_page_package_sum"));
    echarts5Array.push(I18n.getValue("sis_home_page_package_alarm_sum"));
    getDoardPackageDate();
    function getDoardPackageDate() {
        $.ajax({
            url:"/sisPackageTransaction.do/getDevicePackageDate",
            type:"post",
            success:function(data) {
                packageCountArray = data.data.packageCountArray;
                packageAlarmCountArray = data.data.packageAlarmCountArray;
                packageAreaArray = data.data.packageAreaArray;
                if (packageAreaArray.length == 0) {
                    // packageAreaArray = ['上海','北京'];
                    packageCountArray = [0, 0];
                    packageAlarmCountArray = [0, 0];
                }
                echart_4.setOption(makeOptionFour())
            }
        });
    }

    function makeOptionFour() {
        let option = {
            color: ['rgba(0, 250, 255, 1)', 'rgba(231, 131, 249, 1)'],
            legend: {
                show: true,
                data: echarts5Array,
                right: '0',
                top: '10',
                textStyle: {
                    color: ['', '']
                }
            },
            tooltip: {},
            grid: [
                { bottom: '20', top: '40', right: '5' }
            ],
            xAxis: {
                type: 'category',
                data: packageAreaArray,    //底部x轴显示的名字
                splitLine: { show: false },
                axisLine: {
                    lineStyle: {
                        color: 'rgba(33, 224, 253, 1)'
                    }
                }
            },
            yAxis: {
                type: 'value',
                splitLine: {
                    show: false
                },
                axisLine: {
                    lineStyle: {
                        color: 'rgba(33, 224, 253, 1)'
                    }
                }
            },
            series: [
                {
                    name: I18n.getValue("sis_home_page_package_sum"),								//第一类的标题
                    data: packageCountArray,				//第一类的数据
                    type: 'bar',

                }, {
                    name: I18n.getValue("sis_home_page_package_alarm_sum"),								//第二类的标题
                    data: packageAlarmCountArray,				//第二类的数据
                    type: 'bar',

                }
            ]
        };
        return option
    }

    let echart_5 = echarts.init(document.getElementById('echart_5'))
    getDoardWarningPackageDate();
    var typeArray = [];
    var countArray = [];
    function getDoardWarningPackageDate() {
        $.ajax({
            url:"/sisPackageTransaction.do/getDeviceWarningPackageDate",
            type:"post",
            success:function(data) {
                typeArray = data.data.typeArray;
                countArray = data.data.countArray;
                if (typeArray.length == 0) {
                    typeArray = [I18n.getValue("sis_board_knife"), I18n.getValue("sis_borad_liquid"), I18n.getValue("sis_borad_lighter"), I18n.getValue("sis_borad_guns"), I18n.getValue("sis_borad_Inflammable"), I18n.getValue("sis_borad_lithiumBattery"), I18n.getValue("sis_borad_metal"), I18n.getValue("sis_borad_policeEquipment"), I18n.getValue("sis_borad_other")];
                    countArray = [0, 0, 0, 0, 0, 0, 0, 0, 0];
                }
                echart_5.setOption(makeOptionFive());
            }
        });
    }

    function makeOptionFive() {
        let option = {
            color: 'rgba(12, 129, 254, 1)',
            grid: {
                bottom: '0', top: '40', right: '5',
                containLabel: true
            },
            tooltip: {
                trigger: 'item',
                formatter: "{c} {b}",    	//设置鼠标悬浮上去的内容
                show: true,
                transitionDuration: 0,
            },
            xAxis: {

                type: 'category',
                data: typeArray,  //
                splitLine: { show: false },
                axisLine: {
                    lineStyle: {
                        color: 'rgba(33, 224, 253, 1)'
                    }
                }
            },
            yAxis: {
                type: 'value',
                splitLine: {
                    show: false
                },
                axisLine: {
                    lineStyle: {
                        color: 'rgba(33, 224, 253, 1)'
                    }
                }
            },
            series: [{
                data: countArray,			   //对应每一种类型的数据
                type: 'bar',
                barMaxWidth: '20'

            }]
        }
        return option
    }
    // 页面尺寸
    function resizeEchart() {
        pie_echart1.resize()
        pie_echart2.resize()
        pie_echart3.resize()
        pie_echart4.resize()
        echart_2.resize()
        echart_3.resize()
        echart_4.resize()
        echart_5.resize()
        // myChart.resize()
        // myChart2.resize()
    }

    // try {
    //     var resizeObserver = new ResizeObserver(entries => {
    //         for (const entry of entries) {
    //             console.log('html')
    //             Width = $('#board')[0].clientWidth
    //             setWidth()
    //             debugger
    //             resizeEchart()
    //         }
    //     })
    //     resizeObserver.observe(main)
    // } catch (e) {
    //     messageBox({
    //         messageType : "alert",
    //         text : "ResizeObserver API not supported in this device."
    //     });
    // }
    window.onresize = function () {
        Width = $('#board')[0].clientWidth
        setWidth()
        resizeEchart()
    }


    var devAll = [];
    var rayDate = [];
    getDevAllData();
    function getDevAllData() {
        $.ajax({
            url:"/sisDevice.do?getDevAllData",
            type:"post",
            success:function(data) {
                devAll = data.data.array;
                document.getElementById('maptext2').innerText= I18n.getValue("sis_home_page_state_on_line") + ":" + data.data.online + I18n.getValue("sis_home_page_unit")   //地图上设备数量
                document.getElementById('maptext3').innerText= I18n.getValue("sis_home_page_state_off_line") + ":" + data.data.offline + I18n.getValue("sis_home_page_unit");
                rayDate = data.data.ray;
                setMap();
            }
        });
    }
//处理地级市位置点的数据时在  geoCoordMap  对象里面
    function setMap() {
        var myChart = echarts.init(document.getElementById('container'));
        var app = {};
        var shanghai = I18n.getValue("sis_home_page_shang_hai");
        option = null;
        let geoCoordMap = { // 地图地点的经度纬度//经纬度是为了后面处理点与点之间发射线的时候可以通过名字在地图上找到位置
            //此处为数据在某一些地级市的时候，将数据加在经纬度后面	 data对象里面, { 'data': 60 }
            '上海': [121.4648, 31.2891],
            '东莞': [113.8953, 22.901],
            '东营': [118.7073, 37.5513],
            '中山': [113.4229, 22.478],
            '临汾': [111.4783, 36.1615],
            '临沂': [118.3118, 35.2936],
            '丹东': [124.541, 40.4242],
            '丽水': [119.5642, 28.1854],
            '乌鲁木齐': [87.9236, 43.5883],
            '佛山': [112.8955, 23.1097],
            '保定': [115.0488, 39.0948],
            '兰州': [103.5901, 36.3043],
            '包头': [110.3467, 41.4899],
            '北京': [116.4551, 40.2539],
            '北海': [109.314, 21.6211],
            '南京': [118.8062, 31.9208],
            '南宁': [108.479, 23.1152],
            '南昌': [116.0046, 28.6633],
            '南通': [121.1023, 32.1625],
            '厦门': [118.1689, 24.6478],
            '台州': [121.1353, 28.6688],
            '合肥': [117.29, 32.0581],
            '呼和浩特': [111.4124, 40.4901],
            '咸阳': [108.4131, 34.8706],
            '哈尔滨': [127.9688, 45.368],
            '黑龙江': [127.9688, 45.368],
            '唐山': [118.4766, 39.6826],
            '嘉兴': [120.9155, 30.6354],
            '大同': [113.7854, 39.8035],
            '大连': [122.2229, 39.4409],
            '天津': [117.4219, 39.4189],
            '太原': [112.3352, 37.9413],
            '威海': [121.9482, 37.1393],
            '宁波': [121.5967, 29.6466],
            '宝鸡': [107.1826, 34.3433],
            '宿迁': [118.5535, 33.7775],
            '常州': [119.4543, 31.5582],
            '广州': [113.5107, 23.2196],
            '廊坊': [116.521, 39.0509],
            '延安': [109.1052, 36.4252],
            '张家口': [115.1477, 40.8527],
            '徐州': [117.5208, 34.3268],
            '德州': [116.6858, 37.2107],
            '惠州': [114.6204, 23.1647],
            '成都': [103.9526, 30.7617],
            '扬州': [119.4653, 32.8162],
            '承德': [117.5757, 41.4075],
            '拉萨': [91.1865, 30.1465],
            '无锡': [120.3442, 31.5527],
            '日照': [119.2786, 35.5023],
            '昆明': [102.9199, 25.4663],
            '杭州': [119.5313, 29.8773],
            '枣庄': [117.323, 34.8926],
            '柳州': [109.3799, 24.9774],
            '株洲': [113.5327, 27.0319],
            '武汉': [114.3896, 30.6628],
            '汕头': [117.1692, 23.3405],
            '江门': [112.6318, 22.1484],
            '沈阳': [123.1238, 42.1216],
            '沧州': [116.8286, 38.2104],
            '河源': [114.917, 23.9722],
            '泉州': [118.3228, 25.1147],
            '泰安': [117.0264, 36.0516],
            '泰州': [120.0586, 32.5525],
            '济南': [117.1582, 36.8701],
            '济宁': [116.8286, 35.3375],
            '海口': [110.3893, 19.8516],
            '淄博': [118.0371, 36.6064],
            '淮安': [118.927, 33.4039],
            '深圳': [114.5435, 22.5439],
            '清远': [112.9175, 24.3292],
            '温州': [120.498, 27.8119],
            '渭南': [109.7864, 35.0299],
            '湖州': [119.8608, 30.7782],
            '湘潭': [112.5439, 27.7075],
            '滨州': [117.8174, 37.4963],
            '潍坊': [119.0918, 36.524],
            '烟台': [120.7397, 37.5128],
            '玉溪': [101.9312, 23.8898],
            '珠海': [113.7305, 22.1155],
            '盐城': [120.2234, 33.5577],
            '盘锦': [121.9482, 41.0449],
            '石家庄': [114.4995, 38.1006],
            '福州': [119.4543, 25.9222],
            '秦皇岛': [119.2126, 40.0232],
            '绍兴': [120.564, 29.7565],
            '聊城': [115.9167, 36.4032],
            '肇庆': [112.1265, 23.5822],
            '舟山': [122.2559, 30.2234],
            '苏州': [120.6519, 31.3989],
            '莱芜': [117.6526, 36.2714],
            '菏泽': [115.6201, 35.2057],
            '营口': [122.4316, 40.4297],
            '葫芦岛': [120.1575, 40.578],
            '衡水': [115.8838, 37.7161],
            '衢州': [118.6853, 28.8666],
            '西宁': [101.4038, 36.8207],
            '西安': [109.1162, 34.2004],
            '贵阳': [106.6992, 26.7682],
            '连云港': [119.1248, 34.552],
            '邢台': [114.8071, 37.2821],
            '邯郸': [114.4775, 36.535],
            '郑州': [113.4668, 34.6234],
            '鄂尔多斯': [108.9734, 39.2487],
            '重庆': [107.7539, 30.1904],
            '金华': [120.0037, 29.1028],
            '铜川': [109.0393, 35.1947],
            '银川': [106.3586, 38.1775],
            '镇江': [119.4763, 31.9702],
            '长春': [125.8154, 44.2584],
            '长沙': [113.0823, 28.2568],
            '长治': [112.8625, 36.4746],
            '阳泉': [113.4778, 38.0951],
            '青岛': [120.4651, 36.3373],
            '韶关': [113.7964, 24.7028],
            '吐鲁番': [89.18596, 42.94244],
            '那曲': [92.05136, 31.47614],
            '吕梁': [111.15081, 37.51761],
            '伊春': [128.669, 47.72582],
            '呼伦贝尔': [119.73572, 49.21336],
            '嘉峪关': [98.33435281250001, 39.668377553435185],
            '汉中': [107.03194, 33.06784]
        }

        // 发射点数组
        let GZData = rayDate;
        // let GZData = [
        //     [
        //         [{ name: '汕头' }, { name: '黑龙江' }],
        //         [{ name: '广州' }, { name: '福州' }],
        //         // [{ name: '广州' }, { name: '吕梁' }],
        //         // [{ name: '广州' }, { name: '长春' }],
        //         // [{ name: '广州' }, { name: '汉中' }],
        //         // [{ name: '广州' }, { name: '那曲' }],
        //         // [{ name: '广州' }, { name: '北京' }],
        //         // [{ name: '广州' }, { name: '常州' }],
        //         // [{ name: '广州' }, { name: '北京' }],
        //         // [{ name: '广州' }, { name: '南宁' }],
        //         // [{ name: '广州' }, { name: '昆明' }],
        //         // [{ name: '广州' }, { name: '呼和浩特' }],
        //         // [{ name: '广州' }, { name: '西宁' }],
        //         // [{ name: '广州' }, { name: '呼伦贝尔' }],
        //         // [{ name: '广州' }, { name: '嘉峪关' }],
        //         // [{ name: '广州' }, { name: '成都' }],
        //         // [{ name: '广州' }, { name: '伊春' }],
        //         // [{ name: '广州' }, { name: '汕头' }],
        //         [{ name: '广州' }, { name: '海口' }]
        //     ]
        // ]
        // 发射点数组下标
        let launchIndex = 0

        // 按照数组顺序循环发射
        let len = GZData.length
        let arrIndex = launchIndex
        if (launchIndex < len - 1) {
            launchIndex = launchIndex + 1
        } else {
            launchIndex = 0
        }
        // 防止切换用户列表时，定时器延迟造成下标超出数组问题
        if (arrIndex > len - 1) {
            launchIndex = 0
            arrIndex = 0
        }

        // 数组遍历
        let lineDataArr = []
        lineDataArr.push(GZData[arrIndex])

        // // 自定义多个发射点（push多少个就会有多少个同时发射点）
        // lineDataArr.push(GZData[0])
        // lineDataArr.push(GZData[1])

        // 处理线路所需要的数据格式data
        let convertData = function (data) {
            // console.log(data)
            let res = []
            for (let i = 0; i < data.length; i++) {
                let dataItem = data[i]
                debugger;
                let fromCoord = geoCoordMap[dataItem[0].name]
                let toCoord = geoCoordMap[dataItem[1].name]
                if (fromCoord && toCoord) {
                    res.push({
                        fromName: dataItem[0].name,
                        toName: dataItem[1].name,
                        coords: [fromCoord, toCoord]
                    })
                }
            }
            return res
        }
        // 发射点和线路颜色
        let color = ['#ffa022', '#a6c84c', '#46bee9'] // 橙 墨绿 蓝
        let seriesData = []
        lineDataArr.forEach(function (item, i) {
            seriesData.push(
                { // 亮光发射效果
                    // name: item[0] + ' Top10',
                    name: '广州',
                    type: 'lines',
                    zlevel: 1,
                    effect: {
                        show: true,
                        period: 6, // 特效动画的时间，单位为 s
                        // delay: i * 5000, // 特效动画的延时，支持设置成数字或者回调。单位ms
                        trailLength: 0.7,
                        color: '#fff',
                        symbolSize: 3
                    },
                    label: {
                        show: true
                    },
                    lineStyle: {
                        normal: {
                            color: color[i],
                            width: 0,
                            curveness: 0.2
                        }
                    },
                    // data: convertData(item[1])
                    data: convertData(item)
                },
                { // 线路效果
                    // name: item[0] + ' Top10',
                    name: '广州',
                    type: 'lines',
                    zlevel: 2,
                    effect: {
                        // show: true,
                        // period: 6,
                        // trailLength: 0,
                        // symbol: planePath,
                        // symbolSize: 55
                    },
                    label: {
                        show: true
                    },
                    lineStyle: {
                        normal: {
                            color: color[i],
                            width: 1.5,
                            opacity: 0.4,
                            curveness: 0.2
                        }
                    },
                    // data: convertData(item[1])
                    data: convertData(item)
                },
                { // 文字和地点涟漪效果
                    // name: item[0] + ' Top10',
                    name: '广州',
                    type: 'effectScatter',
                    coordinateSystem: 'geo',
                    // geoIndex: 0,
                    zlevel: 2,
                    rippleEffect: {
                        brushType: 'stroke'
                    },
                    label: {
                        emphasis: { // 有这一层为鼠标移入涟漪点才显示文字，去掉这一层那么直接显示文字再地图上
                            show: true,
                            // position: 'top',
                            formatter: '{b}'
                            // offset: [10, -4]
                        }
                    },
                    // label: { // 涟漪文字位置
                    //     normal: {
                    //         show: true,
                    //         position: 'right',
                    //         formatter: '{b}'
                    //     }
                    // },
                    symbolSize: 8,
                    // symbolOffset:[4, 4], // 标记相对于原本位置的偏移
                    itemStyle: { // 涟漪相关颜色
                        normal: {
                            color: color[i]
                        }
                        // color: color[i]
                    },
                    data: item.map(function (dataItem) {
                        return {
                            name: dataItem[1].name,
                            value: geoCoordMap[dataItem[1].name].concat([dataItem[1].value])
                        }
                    })
                }

            )
        })
        // 中国地图线路特效配置 end
        option = {
            // backgroundColor: '#0c1c30', // 图形容器背景色
            tooltip: { // 鼠标移到图里面的浮动提示框

                formatter(params, ticket, callback) {
                    var areaName = params.name;
                    // var htmlStr=setDate(areaName);
                    let value = params.value
                    if (Array.isArray(value)) { // 鼠标移到涟漪点上处理效果
                        value = value[2].data
                    }
                    if (value === undefined) { // 鼠标移到路线上不显示浮层
                        return ''
                    }
                    if (isNaN(value)) {
                        value = 0
                    }
                    var htmlStr="";
                    let dev = 0;
                    let gate = 0;
                    let vid = 0;
                    let devOff = 0;
                    let gateOff = 0;
                    let vidOff = 0;
                    function setDate() {
                        var str="";
                        $.ajax({
                            url:"/sisDevice.do?getMapDevAllData",
                            type:"post",
                            data: {
                                areaName:areaName
                            },
                            async:false,
                            success:function(data) {
                                dev = data.data.dev;
                                gate = data.data.gate;
                                vid = data.data.vid;
                                devOff = data.data.devOff;
                                gateOff = data.data.gateOff;
                                vidOff = data.data.vidOff;
                                str = "<div style='font-size:16px;'> "+params.name+"</div>" +
                                    "<p style='text-align:left;margin-top:4px;'>"+I18n.getValue('sis_home_page_dev_on_line')+"："+dev+I18n.getValue('sis_home_page_unit') +"&nbsp;&nbsp;&nbsp;&nbsp;"+I18n.getValue('sis_home_page_state_off_line')+"："+devOff+I18n.getValue('sis_home_page_unit') +
                                    "<br/>"+I18n.getValue('sis_home_page_gate_on_line')+"："+gate+I18n.getValue('sis_home_page_unit') +"&nbsp;&nbsp;&nbsp;&nbsp;"+I18n.getValue('sis_home_page_state_off_line')+"："+gateOff+I18n.getValue('sis_home_page_unit') +
                                    "<br/>"+I18n.getValue('sis_home_page_vid_on_line')+"："+vid+I18n.getValue('sis_home_page_unit') +"&nbsp;&nbsp;&nbsp;&nbsp;"+I18n.getValue('sis_home_page_state_off_line')+"："+vidOff+I18n.getValue('sis_home_page_unit')+"<br/></p>";
                            }
                        });
                        return str;
                    }
                    return setDate();
                },
                backgroundColor: "rgba(8, 42, 74, 1)",//提示标签背景颜色
                // textStyle:{color:"#fff"} //提示标签字体颜色
            },
            // visualMap的详细配置解析：https://echarts.baidu.com/option.html#visualMap
            visualMap: { // 左下角的颜色区域
                type: 'continuous', // 定义为分段型 visualMap
                min: 0,
                max: 100,
                itemWidth: 10,
                itemHeight: 100,
                // top: 20,
                bottom: 10,
                left: 20,
                text: ['高', '低'],
                textStyle: { // 文字颜色
                    color: '#ddd'
                },
                calculable: true, // 是否显示手柄
                inRange: {
                    color: ['#0c1c30', '#216bc2', '#7760f6', '#9900FF'],
                    // symbolSize: [60, 100] // 大小（这里会影响涟漪散点图的显示，所以去掉）
                }
            },
            // geo配置详解： https://echarts.baidu.com/option.html#geo
            geo: { // 地理坐标系组件用于地图的绘制
                map: 'china', // 表示中国地图
                // roam: true, // 是否开启鼠标缩放和平移漫游
                zoom: 1.2, // 当前视角的缩放比例（地图的放大比例）
                // top:20,
                label: {
                    show: true,
                    color: '#f2f2f2' // 文字颜色
                },
                itemStyle: { // 地图区域的多边形 图形样式。
                    areaColor: 'rgba(16, 48, 58, 1)', // 地区默认颜色
                    // borderColor: '#678dd6', //片区边框颜色
                    borderWidth: 1, // 边框描绘
                    borderColor: 'rgba(4, 209, 232, 1)', //片区边框颜色
                    emphasis: { // 高亮状态下的多边形和标签样式
                        areaColor: '#24cbff', // 高亮区域背景颜色
                        shadowBlur: 20,
                        shadowColor: 'rgba(4, 209, 232, 1)'
                    }
                },
            },
            series: [
                ...seriesData, // 中国地图线路特效配置
                {
                    // name: '', // 浮动框的标题（上面的formatter自定义了提示框数据，所以这里可不写）
                    type: 'map',
                    geoIndex: 0,
                    label: {
                        show: true
                    },
                    // 这是需要配置地图上的某个地区的数据，根据后台的返回的数据进行拼接（下面是我定义的假数据）
                    //下方为设置省级区域的设备数量，以及根据这个数量去定义该区域的颜色，省级一下的点的颜色也可在这里写上比如 { 'name':'汕头', 'value':60 }
                    data: devAll
                }
            ]
        };

        if (option && typeof option === "object") {
            myChart.setOption(option, true);
        }
    }
    var myChart2 = echarts.init(dom2);
    var app2 = {};
    let option2 = null;
    function map2() {
        option2 = {
            // backgroundColor: '#0c1c30', // 图形容器背景色
            tooltip: { // 鼠标移到图里面的浮动提示框
                textStyle: {
                    height: '50'
                },
                formatter(params, ticket, callback) {
                    // console.log(params)
                    let value = params.value
                    if (Array.isArray(value)) { // 鼠标移到涟漪点上处理效果
                        value = value[2].data
                    }
                    if (value === undefined) { // 鼠标移到路线上不显示浮层
                        return ''
                    }
                    if (isNaN(value)) {
                        value = 0
                    }

                    let htmlStr = `<div style='font-size:16px; height:50px;'> ${params.name}</div><p style='text-align:left;margin-top:4px;'>区域分布：${value}%<br/></p>`
                    return htmlStr
                },
                backgroundColor: "rgba(8, 42, 74, 1)",//提示标签背景颜色
                // textStyle:{color:"#fff"} //提示标签字体颜色
            },
            // visualMap的详细配置解析：https://echarts.baidu.com/option.html#visualMap
            visualMap: { // 左下角的颜色区域
                show:false,

            },
            // geo配置详解： https://echarts.baidu.com/option.html#geo
            geo: { // 地理坐标系组件用于地图的绘制
                map: 'china', // 表示中国地图
                // roam: true, // 是否开启鼠标缩放和平移漫游
                zoom: 1.2, // 当前视角的缩放比例（地图的放大比例）
                // top:20,
                label: {
                    show: true,
                    color: '#f2f2f2' // 文字颜色
                },
                itemStyle: { // 地图区域的多边形 图形样式。
                    areaColor: 'rgba(16, 48, 58, 1)', // 地区默认颜色
                    // borderColor: '#678dd6', //片区边框颜色
                    borderWidth: 5, // 边框描绘
                    borderColor: 'rgba(4, 209, 232, 1)', //片区边框颜色
                    shadowBlur: 20,
                    shadowColor: 'rgba(4, 209, 232, 1)',
                    emphasis: { // 高亮状态下的多边形和标签样式
                        areaColor: '#24cbff', // 高亮区域背景颜色
                        shadowBlur: 20,
                        shadowColor: 'rgba(4, 209, 232, 1)'
                    }
                },
            },
            series: [
                {
                    // name: '', // 浮动框的标题（上面的formatter自定义了提示框数据，所以这里可不写）
                    type: 'map',
                    geoIndex: 0,
                    label: {
                        show: true
                    },
                    // 这是需要配置地图上的某个地区的数据，根据后台的返回的数据进行拼接（下面是我定义的假数据）
                    //下方为设置省级区域的设备数量，以及根据这个数量去定义该区域的颜色，省级一下的点的颜色也可在这里写上比如 { 'name':'汕头', 'value':60 }
                    data: []
                }
            ]
        };
        myChart2.setOption(option2, true);
    }

    // map2()
});