var today = new Date();
var year = today.getFullYear();
var month = today.getMonth() + 1;
var day = today.getDate();

function setMonthAndYear(month, year, uuid) {
    if (month < 10) {
        $("#dateSelected" + uuid).val(year + "-0" + month);
        $("#todayDay" + uuid).text(year + "-0" + month);
    } else {
        $("#dateSelected" + uuid).val(year + "-" + month);
        $("#todayDay" + uuid).text(year + "-" + month);
    }
}

function bindPreNextClick(uuid, schType){
	$("#pre" + uuid).click(function() {
		year = $("#dateSelected" + uuid).val().split("-")[0]; 
		month = $("#dateSelected" + uuid).val().split("-")[1];
		if (month == 1) {
			month = 12;
			year--;
		} else {
			month--;
		}
		setMonthAndYear(month, year, uuid);
		listJsonSch(uuid, schType);
	});
	
	$("#next" + uuid).click(function() {
		year = $("#dateSelected" + uuid).val().split("-")[0]; 
		month = $("#dateSelected" + uuid).val().split("-")[1];
		if (month == 12) {
			month = 1;
			year++;
		} else {
			month++;
		}
		setMonthAndYear(month, year, uuid);
		listJsonSch(uuid, schType);
	});
}

function initCalendar(month, day, uuid) {
    var monthDayNum = getMonthDay(year, month);

    $("#monthBox" + uuid + " ul").html("");

    // 获取第一天星期几
    var week = weekHandle();
    var liText = "";
    var preMonthDay = month - 1 == 0 ? getMonthDay(year, 12) : getMonthDay(year, month - 1);
    var preLen = preMonthDay - week + 1;
    var nextLen = 42 - monthDayNum - week;

    // 拼凑日期box的id
    var preYearStr = "" + year;
    var preMonthStr = "" + (month - 1);

    var nextYearStr = "" + year;
    var nextMonthStr = "" + (month + 1);

    var monthStr = "" + month;

    // 上个月
    if ((month - 1) < 10) {
        preMonthStr = "0" + (month - 1);
    }
    if (month - 1 == 0) {
        preYearStr = "" + (year - 1);
        preMonthStr = "12";
    }
    
    // 本月
    if (month < 10) {
        monthStr = "0" + month;
    }
    
    // 下个月
    if ((month + 1) < 10) {
        nextMonthStr = "0" + (month + 1);
    }
    if (month + 1 > 12) {
        nextYearStr = "" + (year + 1);
        nextMonthStr = "01";
    }

    // 上个月末尾
    for (var i = week; i > 0; i--) {
        var idStr = preYearStr + "-" + preMonthStr + "-" + preLen + uuid;
        liText += "<li class=\"other\">";
        liText += "<div class=\"schBox\">"
        liText += "<span class=\"exception\" id=\"exception_" + idStr + "\"></span>"
        liText += "<span class=\"otherDay\">" + preLen + "</span>";
        liText += "<div id=\"inter_" + idStr + "\"></div>";
        liText += "<div class=\"schDateBox\" id=" + idStr + "></div>";
        liText += "</div>";
        liText += "</li>";
        preLen++;
    }

    // 本月
    for (var i = 1; i <= monthDayNum; i++) {
        var dayStr = i < 10 ? "0" + i : "" + i;
        var idStr = year + "-" + monthStr + "-" + dayStr + uuid;
        liText += "<li>";
        liText += "<div class=\"schBox\">";
        liText += "<span class=\"exception\" id=\"exception_" + idStr + "\"></span>";
        liText += "<span class=\"day\">" + i + "</span>";
        liText += "<div id=\"inter_" + idStr + "\"></div>";
        liText += "<div class=\"schDateBox\" id=" + idStr + "></div>";
        liText += "</div>";
        liText += "</li>";
    }
    
    // 下个月初
    for (var i = 1; i <= nextLen; i++) {
        var dayStr = i < 10 ? "0" + i : "" + i;
        var idStr = nextYearStr + "-" + nextMonthStr + "-" + dayStr + uuid;
        liText += "<li class=\"other\">";
        liText += "<div class=\"schBox\">"
        liText += "<span class=\"exception\" id=\"exception_" + idStr + "\"></span>"
        liText += "<span class=\"otherDay\">" + i + "</span>";
        liText += "<div id=\"inter_" + idStr + "\"></div>";
        liText += "<div class=\"schDateBox\" id=" + idStr + "></div>";
        liText += "</div>";
        liText += "</li>";
    }
    $("#monthBox" + uuid + " ul").append(liText);
}

//跨天班次临时存储函数
function createObject(interBox, html, otherDateBox, className, shiftName, titleStr, uuid) {
    var object = {};

    object.interBox = "inter_" + interBox + uuid;
    object.html = html; // 每一个对象的函数对象都指向同一个函数对象
    object.className = className;
    object.shiftName = shiftName;
    object.titleStr = titleStr;
    // 设置跨天排班所占位置高度，由于底层是浮动布局，跨天排班是定位布局，所以不会自动撑高div块，所以需要手动设置高度，下同
    $("#inter_" + interBox + uuid).css("height", "26px");
    $("#" + interBox + uuid).css("height", "55px");
    if (otherDateBox) {
        object.otherDateBox = otherDateBox;
    }
    return object;
}

// 获取这一个月的天数
function getMonthDay(year, month) {
	var arr = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
	// 判断是否是瑞年
	var leap = isLeapYear(year);
	if (leap && month == 2) {
		return 29;
	} else {
		return arr[month - 1];
	}
}

// 判断是否是瑞年
function isLeapYear(year) {
	if ((year % 4 == 0 && year % 100 != 0)
			|| (year % 100 == 0 && year % 400 == 0)) {
		return true;
	} else {
		return false;
	}
}

// 获取一个月的第一天星期几
function weekHandle() {
	var weekArr = new Array(0, 1, 2, 3, 4, 5, 6);
	var date = new Date(year + "/" + month + "/" + 1);
	return date.getDay();
}

// 获取第二天日期
function getNextDay(date) {
	var tomorrow = new Date(new Date(date).getTime() + 86400000);
	return formatDate(tomorrow);
}

// 获取前一天日期
function getPreDay(date) {
	var yesterday = new Date(new Date(date).getTime() - 86400000);
	return formatDate(yesterday);
}

function formatDate(date) {  
    var y = date.getFullYear();  
    var m = date.getMonth() + 1;  
    m = m < 10 ? '0' + m : m;  
    var d = date.getDate();  
    d = d < 10 ? ('0' + d) : d;  
    return y + '-' + m + '-' + d;  
}

// 获取星期几
function getDay(date) {
	return new Date(date).getDay();
}

// 跨天排班的班次相关html处理
function createHtml(attShiftJson, titleStr, interSchArray, dateBoxWidth, date, uuid) {
	var htmlInter = "";
	var htmlOther = "";
	var positionWidth = 0;
	if (attShiftJson.computeInter == "0") {// 记为第一日
		var torrowDate = getNextDay(date);
		var today = getDay(date);
		if (today == 6) {// 星期六
			positionWidth = 7 * (dateBoxWidth + 6) - 78;
			htmlInter = "<span class=\"schFirstPre\" style=\"left:" + positionWidth + "px; background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
			htmlOther = "<span class=\"schFirstNext\" style=\"left: 3px; background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
			interSchArray.push(createObject(date, htmlInter, torrowDate, "schFirstPre", attShiftJson.shiftName, titleStr, uuid));
			interSchArray.push(createObject(torrowDate, htmlOther, null, "schFirstNext", attShiftJson.shiftName, titleStr, uuid));
		} else {
			positionWidth = (today + 1) * (dateBoxWidth + 6) - 78;
			htmlInter = "<span class=\"schInter\" style=\"left:" + positionWidth + "px; background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
			interSchArray.push(createObject(date, htmlInter, torrowDate, "schInter", attShiftJson.shiftName, titleStr, uuid));
		}
	} else {// 记为第二日
		var yesterDate = getPreDay(date);
		var today = getDay(date);
		if (today == 0) {// 星期日
			positionWidth = 7 * (dateBoxWidth + 6) - 18;// 根据盒子模型计算
			htmlInter = "<span class=\"schSecondNext\" style=\"left: 3px; background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
			htmlOther = "<span class=\"schSecondPre\" style=\"left:" + positionWidth + "px; background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
			interSchArray.push(createObject(date, htmlInter, yesterDate, "schSecondNext", attShiftJson.shiftName, titleStr, uuid));
			interSchArray.push(createObject(yesterDate, htmlOther, null, "schSecondPre", attShiftJson.shiftName, titleStr, uuid));
		} else {
			positionWidth = today * (dateBoxWidth + 6) - 18;
			htmlInter = "<span class=\"schInter\" style=\"left:" + positionWidth + "px; background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
			interSchArray.push(createObject(date, htmlInter, yesterDate, "schInter", attShiftJson.shiftName, titleStr, uuid));
		}
	}
}

//日历填充数据
function listJsonSch(uuid, schType) {
	var schId = $("#schId" + uuid).val();
	var dateSelected = $("#dateSelected" + uuid).val();
	var html = "";
	var interSchArray = [];
	var dateBoxWidth = 110;//日历格子宽度
	if(schId){
		$.ajax({
	        data: {
	        	schId: schId,
	        	dateSelected: dateSelected
	        },
	        dataType: "json",
	        type: "post",
	        url: "att" + schType + "Sch.do?getAttShiftSchJsonByDate",
	        success: function(data) {
		        if (data.data.result == "success") {
		        	initCalendar(month, day, uuid);
		        	
		        	$.each(data.data.attSchJson, function(i, attDateJson) {
	                    //日历格子还原到初始化状态
	                    $("#" + attDateJson.date + uuid).empty();
	                    $("#" + attDateJson.date + uuid).css("height", "80px");
	                    $("#inter_" + attDateJson.date + uuid).empty();
	                    $("#inter_" + attDateJson.date + uuid).css("height", "0");
	                    //判断是否有排班
	                    if (attDateJson.times > 0) {
	                        $.each(attDateJson.attShiftArray, function(j, attShiftJson) {
	                            //将时间段信息放入班次title
	                            var titleStr = attShiftJson.shiftName + ":&#13;";
	                            $.each(attShiftJson.attTimeSlotArray, function(k, value) {
	                                titleStr += value + "&#13;";
	                            });
	                            //判断班次是否包含时间段信息，没有则不显示班次
	                            if (attShiftJson.times > 0) {
	                                if (attDateJson.tempSymbol == "0") {//正常排班
	                                    if (attShiftJson.interDay == "0") {//不是跨天
	                                        //正常排班
	                                        html += "<span class=\"sch\" style=\"background:" + attShiftJson.shiftColor + ";\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
	                                    } else {//跨天
	                                        createHtml(attShiftJson, titleStr, interSchArray, dateBoxWidth, attDateJson.date, uuid);
	                                    }
	                                } else {//临时排班
	                                    if (attShiftJson.isTemp == "1") {
	                                        if (attShiftJson.interDay == "0") {//不是跨天
	                                            //正常排班
	                                            html += "<span class=\"sch\" style=\"background:" + attShiftJson.shiftColor + "\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
	                                        } else {//跨天
	                                            createHtml(attShiftJson, titleStr, interSchArray, dateBoxWidth, attDateJson.date, uuid);
	                                        }
	                                    } else {
	                                        //划掉正常排班
	                                        html += "<span class=\"sch\" style=\"text-decoration: line-through;background: #fff;\" title=\"" + titleStr + "\">" + attShiftJson.shiftName + "</span>";
	                                    }
	                                }
	                            }
	                        });
	                    }
	                    //非跨天排班数据填充渲染
	                    $("#" + attDateJson.date + uuid).html(html);
	                    html = "";
	                });
		        	if (schType == "Person") {
		        		$.each(data.data.exceptionArray, function(i, attDateJson) {
			        		$("#exception_" + attDateJson.date + uuid).text(attDateJson.exceptionSymbol);
			        		$("#exception_" + attDateJson.date + uuid).css("background", "#f0a986");
			        		$("#exception_" + attDateJson.date + uuid).attr("title", attDateJson.exceptionValue);
			        	});
		        	}
	                //渲染跨天排班
	                for(var item in interSchArray) {
	                    var spans = $("#" + interSchArray[item].interBox + " ." + interSchArray[item].className);
	                    if (spans.length == 0) {
	                        $("#" + interSchArray[item].interBox).append(interSchArray[item].html);
	                    } else {
	                        //多个跨天班次
	                        var oldText = spans.eq(0).html();
	                        var oldTitle = spans.eq(0).attr("title");
	                        spans.eq(0).html(oldText + "," + interSchArray[item].shiftName);
	                        var curTitle = $('<div/>').html(interSchArray[item].titleStr).text();
	                        spans.eq(0).attr("title", oldTitle + curTitle);
	                    }
	                    
	                    //跨天排班超出部分占据一个格子
	                    if (interSchArray[item].otherDateBox) {
	                        $("#inter_" + interSchArray[item].otherDateBox + uuid).css("height", "26px");
	                        $("#" + interSchArray[item].otherDateBox + uuid).css("height", "55px");
	                    }
	                }
	                interSchArray = [];
		        }
	        }
	    });
	}else{
		initCalendar(month, day, uuid);
	}
}
