/**
 * 用于安检设备添加人员或人员添加安检设备xml配置文件中的相关方法
 */
// 执行进度条
function doLevelProgress(delPath)
{
	var progressParams = 
	{
		"winTitle" : "${common_progress_proCmd}",
		"dealDataPath" : delPath,
		"singleMode" : false,
		"callback" : function(){
			window.setTimeout(function(){
				reloadGrid("leftGridbox");
				reloadGrid("rightGridbox");
			}, 2000);
		}
	};
	openProgress(progressParams);
}


/**
 * 删除人员后的回调
 */
var opPersonFunc = function(num)
{
	setCount(num, "del", "person", 3000);
};

/**
 * 删除设备后的回调
 */
var opDeviceFunc = function(num)
{
	setCount(num, "del", "device", 3000);
}

/**
 * 删除安检设备的人员
 * @param delPath
 */
function delPersonFromDevice(delPath)
{
	//判断路径中是否存在"#",存在则取#号后面是数据为路径（在list页面中操作xml中存在）
	gridName = delPath.split("#")[1] ? delPath.split("#")[1] : defaultGridName;
	delPath = delPath.indexOf("#")>0 ? delPath.split("#")[0] : delPath;
	var idsName = delPath.split("^")[1] ? delPath.split("^")[1] : "ids";
	var ids = getGridCheckboxValue(idsName);
	var path = delPath;
	var num = ids.split(",").length;
	if(ids != "") //判断是否至少选中一个
	{
		if(delPath.indexOf("$(") > 0)
		{
			var objId  = delPath.substring(delPath.indexOf("$(") + "$(".length, delPath.lastIndexOf(")"));
			delPath = delPath.replace("$(" + objId +")", $("#" + objId).val());
		}
		
		var devId = delPath.split("^")[0].split("devId=")[1];
		delPath = delPath.split("^")[0] + (delPath.indexOf("?") > 0 ? "&" : "?") + "un=" + Date.parse(new Date())+"&"+idsName+"="+ids;
		messageBox({
			messageType: "confirm", 
			text: "${common_prompt_sureToDelThese}", 
			callback : function(data)
			{
				if(data)
				{
					$.ajax({
						type: "POST",
						url: "sisDeviceAddPersonAction!personCount.action?id="+devId,
						dataType: "json",
						async: false,
						success: function(retData)
						{
							var deviceCount = retData.data;
							if(deviceCount > 0)
							{
								var progressParams = 
								{
									"winTitle" : "${common_progress_proCmd}",
									"dealDataPath" : delPath,
									"singleMode" : false,
									"callback" : function()
									{
										opPersonFunc(num);
									}
								};
								openProgress(progressParams);
							}
							else
							{
								$.ajax({
									type: "POST",
									url: delPath,
									success: function(result)
								    {
										dealRetResult(result, opPersonFunc(num));
								    },
									error:function (XMLHttpRequest, textStatus, errorThrown)
									{
										openMessage(msgType.error, "${common_prompt_serverError}" + XMLHttpRequest.status);
									}
						        });
							}
						}
					});
				}
			}
		});
	}
	else 
	{
		messageBox({messageType:"alert",text:"${common_prompt_selectObj}"});
	}
}

/**
 * 删除所有安检设备的人员
 * @param delPath
 */
function delAllPersonFromDevice(delPath)
{
	delPath = delPath.indexOf("#")>0 ? delPath.split("#")[0] : delPath;
	if(delPath.indexOf("$(") > 0)
	{
		var objId  = delPath.substring(delPath.indexOf("$(") + "$(".length, delPath.lastIndexOf(")"));
		delPath = delPath.replace("$(" + objId +")", $("#" + objId).val());
	}
	var devId = delPath.split("^")[0].split("devId=")[1];
	messageBox({
		messageType: "confirm", 
		text: "${common_prompt_sureToDelThese}", 
		callback : function(data)
		{
			if(data)
			{
				$.ajax({
					type: "POST",
					url: "sisDeviceAddPersonAction!personCount.action?id="+devId,
					dataType: "json",
					async: false,
					success: function(retData)
					{
						var deviceCount = retData.data;
						if(deviceCount > 0)
						{
							var progressParams = 
							{
								"winTitle" : "${common_progress_proCmd}",
								"dealDataPath" : delPath,
								"singleMode" : false,
								"callback" : function()
								{
									opPersonFunc(deviceCount);
								}
							};
							openProgress(progressParams);
						}
						else
						{
							$.ajax({
								type: "POST",
								url: delPath,
								success: function(result)
							    {
									dealRetResult(result, opPersonFunc(num));
							    },
								error:function (XMLHttpRequest, textStatus, errorThrown)
								{
									openMessage(msgType.error, "${common_prompt_serverError}" + XMLHttpRequest.status);
								}
					        });
						}
					}
				});
			}
		}
	});
}

/**
 * 删除人员的安检设备
 * @param delPath
 */
function delDeviceFromPerson(delPath)
{
	//判断路径中是否存在"#",存在则取#号后面是数据为路径（在list页面中操作xml中存在）
	gridName = delPath.split("#")[1] ? delPath.split("#")[1] : defaultGridName;
	delPath = delPath.indexOf("#")>0 ? delPath.split("#")[0] : delPath;
	var idsName = delPath.split("^")[1] ? delPath.split("^")[1] : "ids";
	var ids = getGridCheckboxValue(idsName);
	var path = delPath;
	var num = ids.split(",").length;
	if(ids != "") //判断是否至少选中一个
	{
		if(delPath.indexOf("$(") > 0)
		{
			var objId  = delPath.substring(delPath.indexOf("$(") + "$(".length, delPath.lastIndexOf(")"));
			delPath = delPath.replace("$(" + objId +")", $("#" + objId).val());
		}
		
		var personId = delPath.split("^")[0].split("personId=")[1];
		delPath = delPath.split("^")[0] + (delPath.indexOf("?") > 0 ? "&" : "?") + "un=" + Date.parse(new Date())+"&"+idsName+"="+ids;
		messageBox({
			messageType: "confirm", 
			text: "${common_prompt_sureToDelThese}", 
			callback : function(data)
			{
				if(data)
				{
					$.ajax({
						type: "POST",
						url: "sisPersonAddDeviceAction!deviceCount.action?id="+personId,
						dataType: "json",
						async: false,
						success: function(retData)
						{
							var deviceCount = retData.data;
							if(deviceCount > 0)
							{
								var progressParams = 
								{
									"winTitle" : "${common_progress_proCmd}",
									"dealDataPath" : delPath,
									"singleMode" : false,
									"callback" : function()
									{
										opDeviceFunc(num);
									}
								};
								openProgress(progressParams);
							}
							else
							{
								$.ajax({
									type: "POST",
									url: delPath,
									success: function(result)
								    {
										dealRetResult(result, opDeviceFunc(num));
								    },
									error:function (XMLHttpRequest, textStatus, errorThrown)
									{
										openMessage(msgType.error, "${common_prompt_serverError}" + XMLHttpRequest.status);
									}
						        });
							}
						}
					});
				}
			}
		});
	}
	else 
	{
		messageBox({messageType:"alert",text:"${common_prompt_selectObj}"});
	}
}

// 更新列表中的门、人 数量
function setCount(num, opType, type, timeOut, id)
{
	var mygrid = mygrids["leftGridbox"];
	var rowId = mygrid.getSelectedRowId();
	rowId = (rowId == undefined || rowId == null || rowId == "") ? id : rowId;
	var rowIndex = mygrid.getRowIndex(rowId);
	var type = (type == "person") ? "#personCount" : "#deviceCount";
	var colIndex =  mygrid.getColIndexById(type);//人员数列索引
	var count = parseInt(mygrid.cells(rowId, colIndex).cell.innerHTML);
	count = count != "" ? parseInt(count) : 0;
	num = num != "" ? parseInt(num) : 0;
	if(id != undefined)
	{
		mygrid.selectRow(rowIndex, true, true, true);//加完后重新点击查询
	}
	else
	{
		reloadGrid("rightGridbox");//右边列表已经保存了过滤参数，直接刷新
	}
	if(opType != undefined && opType == "add")//添加人员后，以右边人员列表总人数更新人数
	{
		window.setTimeout(function(){
			count = mygrids["rightGridbox"].pagingToolbar.getItemText("recordsCount");
			mygrid.cells(rowId, colIndex).cell.innerHTML = count;//更新个数
		}, timeOut);
	}
	else
	{
		count = (count - num > 0) ?  count - num : 0;
		mygrid.cells(rowId, colIndex).cell.innerHTML = count;//更新个数
	}
}
