/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.wx.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.pers.service.wx.PersApiTokenService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VisApiTokenFilter
implements Filter {
    @Autowired
    private PersApiTokenService persApiTokenService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isBlank((CharSequence)request.getParameter("token"))) {
            jsonObject.put("ret", (Object)"unauthorized");
            jsonObject.put("msg", (Object)"unauthorized");
            jsonObject.put("date", (Object)"");
            res.getWriter().write(jsonObject.toJSONString());
        } else {
            ZKResultMsg zkResultMsg = this.persApiTokenService.checkToken(request.getParameter("token"));
            if (zkResultMsg.isSuccess()) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                Map extraParams = (Map)zkResultMsg.getData();
                PosIDApiTokenRequest posIDApiTokenRequest = new PosIDApiTokenRequest(httpServletRequest);
                posIDApiTokenRequest.addParameters(extraParams);
                chain.doFilter((ServletRequest)posIDApiTokenRequest, response);
            } else {
                jsonObject.put("ret", (Object)zkResultMsg.getRet());
                jsonObject.put("msg", (Object)zkResultMsg.getMsg());
                jsonObject.put("date", zkResultMsg.getData());
                res.getWriter().write(jsonObject.toJSONString());
            }
        }
    }

    public void destroy() {
    }

    class PosIDApiTokenRequest
    extends HttpServletRequestWrapper {
        private HttpServletRequest request;
        private Map<String, String[]> params;

        public PosIDApiTokenRequest(HttpServletRequest request) {
            super(request);
            this.params = new HashMap<String, String[]>();
            this.params.putAll(request.getParameterMap());
        }

        public PosIDApiTokenRequest(HttpServletRequest request, Map<String, Object> extraParams) {
            this(request);
            this.addParameters(extraParams);
        }

        public String getParameter(String name) {
            String[] values = this.params.get(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public void addParameters(Map<String, Object> extraParams) {
            for (Map.Entry<String, Object> entry : extraParams.entrySet()) {
                this.addParameter(entry.getKey(), entry.getValue());
            }
        }

        public void addParameter(String name, Object value) {
            if (value != null) {
                System.out.println(value);
                if (value instanceof String[]) {
                    this.params.put(name, (String[])value);
                } else if (value instanceof String) {
                    this.params.put(name, new String[]{(String)value});
                } else {
                    this.params.put(name, new String[]{String.valueOf(value)});
                }
            }
        }
    }
}

