/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersWiegandFmtRemote;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersWiegandFmtService;
import com.zkteco.zkbiosecurity.pers.vo.PersWiegandFmtItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersWiegandFmtController
extends BaseController
implements PersWiegandFmtRemote {
    @Autowired
    private PersWiegandFmtService persWiegandFmtService;
    @Autowired
    private PersParamsService persParamsService;

    @RequiresPermissions(value={"pers:wiegandFmt"})
    public ModelAndView index() {
        return new ModelAndView("pers/wiegandFmt/persWiegandFmt");
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresPermissions(value={"pers:wiegandFmt:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id, @RequestParam(value="cardFmt", required=false) String cardFmts, @RequestParam(value="parityFmt", required=false) String parityFmts, @RequestParam(value="wiegandCount", required=false) String wiegandCount, @RequestParam(value="siteCode", required=false) String siteCodes) {
        PersWiegandFmtItem item = new PersWiegandFmtItem();
        if (StringUtils.isEmpty((CharSequence)id)) {
            if (!StringUtils.isNotEmpty((CharSequence)cardFmts)) {
                this.request.setAttribute("siteCodeLen", (Object)this.persParamsService.getValByName("pers.siteCodeLen"));
                return new ModelAndView("pers/wiegandFmt/editPersWiegandFmt");
            }
            item.setCardFmt(cardFmts);
            item.setParityFmt(parityFmts);
            item.setSiteCode(siteCodes);
            item.setWiegandCount(Short.valueOf(wiegandCount));
            List list = this.persWiegandFmtService.getByCondition(item);
            if (list.size() > 0) {
                item = (PersWiegandFmtItem)list.get(0);
            }
        } else {
            item = this.persWiegandFmtService.getItemById(id);
        }
        this.request.setAttribute("item", (Object)item);
        String parityFmt = item.getParityFmt();
        String cardFmt = item.getCardFmt();
        int[] odd = this.getParity(parityFmt, 'o');
        this.request.setAttribute("oStart", (Object)odd[0]);
        this.request.setAttribute("oCount", (Object)odd[1]);
        int[] even = this.getParity(parityFmt, 'e');
        this.request.setAttribute("eStart", (Object)even[0]);
        this.request.setAttribute("eCount", (Object)even[1]);
        int[] cid = this.getParity(cardFmt, 'c');
        this.request.setAttribute("cStart", (Object)cid[0]);
        this.request.setAttribute("cCount", (Object)cid[1]);
        int[] siteCode = this.getParity(cardFmt, 's');
        this.request.setAttribute("sStart", (Object)siteCode[0]);
        this.request.setAttribute("sCount", (Object)siteCode[1]);
        int[] fCode = this.getParity(cardFmt, 'f');
        this.request.setAttribute("fStart", (Object)fCode[0]);
        this.request.setAttribute("fCount", (Object)fCode[1]);
        int[] mCode = this.getParity(cardFmt, 'm');
        this.request.setAttribute("mStart", (Object)mCode[0]);
        this.request.setAttribute("mCount", (Object)mCode[1]);
        int[] parity = this.getParity(cardFmt, 'p');
        this.request.setAttribute("firstParity", (Object)parity[0]);
        this.request.setAttribute("secondParity", (Object)parity[1]);
        this.request.setAttribute("siteCodeLen", (Object)this.persParamsService.getValByName("pers.siteCodeLen"));
        return new ModelAndView("pers/wiegandFmt/editPersWiegandFmt");
    }

    @RequiresPermissions(value={"pers:wiegandFmt:edit"})
    @LogRequest(module="pers_module", object="pers_wiegandFmt", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(PersWiegandFmtItem item) {
        String ret;
        String[] retArray;
        ZKResultMsg res = new ZKResultMsg();
        if (item.getIsDefaultFmt() == null) {
            item.setIsDefaultFmt(Boolean.valueOf(false));
        }
        if (item.getWiegandMode() == 1 && (retArray = (ret = this.wiegandFmtStr(item)).split(":", 2)).length == 2) {
            item.setCardFmt(retArray[0]);
            item.setParityFmt(retArray[1]);
        }
        if (StringUtils.isEmpty((CharSequence)item.getSiteCode())) {
            item.setSiteCode("0");
        }
        this.persWiegandFmtService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:wiegandFmt"})
    public DxGrid list(PersWiegandFmtItem condition) {
        condition.setAutoMode(Short.valueOf((short)0));
        Pager pager = this.persWiegandFmtService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:wiegandFmt:del"})
    @LogRequest(module="pers_module", object="pers_wiegandFmt", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.persWiegandFmtService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String wiegandFmtStr(PersWiegandFmtItem wgFmt) {
        short sParity;
        String oStart = this.request.getParameter("oStart");
        String oCount = this.request.getParameter("oCount");
        String eStart = this.request.getParameter("eStart");
        String eCount = this.request.getParameter("eCount");
        String cStart = this.request.getParameter("cStart");
        String cCount = this.request.getParameter("cCount");
        String sStart = this.request.getParameter("sStart");
        String sCount = this.request.getParameter("sCount");
        String mStart = this.request.getParameter("mStart");
        String mCount = this.request.getParameter("mCount");
        String firstParity = this.request.getParameter("firstParity");
        String secondParity = this.request.getParameter("secondParity");
        char[] chr = new char[wgFmt.getWiegandCount().shortValue()];
        for (int i = 0; i < wgFmt.getWiegandCount(); ++i) {
            chr[i] = 120;
        }
        int oMin = -1;
        int oMax = -1;
        int eMin = -1;
        int eMax = -1;
        if (oStart != null && !"".equals(oStart) && oCount != null && !"".equals(oCount)) {
            oMin = Integer.parseInt(oStart) - 1;
            oMax = Integer.parseInt(oStart) + Integer.parseInt(oCount) - 2;
        }
        if (eStart != null && !"".equals(eStart) && eCount != null && !"".equals(eCount)) {
            eMin = Integer.parseInt(eStart) - 1;
            eMax = Integer.parseInt(eStart) + Integer.parseInt(eCount) - 2;
        }
        for (int i = 0; i < wgFmt.getWiegandCount(); ++i) {
            if (oMin <= i && i <= oMax) {
                chr[i] = 111;
            }
            if (eMin > i || i > eMax) continue;
            chr[i] = chr[i] == 'o' ? 98 : 101;
        }
        String oddEvenStr = new String(chr);
        for (int i = 0; i < wgFmt.getWiegandCount(); ++i) {
            chr[i] = 120;
        }
        int cMin = -1;
        int cMax = -1;
        int sMin = -1;
        int sMax = -1;
        int mMin = -1;
        int mMax = -1;
        if (cStart != null && !"".equals(cStart) && cCount != null && !"".equals(cCount)) {
            cMin = Integer.parseInt(cStart) - 1;
            cMax = Integer.parseInt(cStart) + Integer.parseInt(cCount) - 2;
        }
        if (sStart != null && !"".equals(sStart) && sCount != null && !"".equals(sCount)) {
            sMin = Integer.parseInt(sStart) - 1;
            sMax = Integer.parseInt(sStart) + Integer.parseInt(sCount) - 2;
        }
        if (mStart != null && !"".equals(mStart) && mCount != null && !"".equals(mCount)) {
            mMin = Integer.parseInt(mStart) - 1;
            mMax = Integer.parseInt(mStart) + Integer.parseInt(mCount) - 2;
        }
        for (int i = 0; i < wgFmt.getWiegandCount(); ++i) {
            if (cMin <= i && i <= cMax) {
                chr[i] = 99;
            }
            if (sMin <= i && i <= sMax) {
                chr[i] = 115;
            }
            if (mMin > i || i > mMax) continue;
            chr[i] = 109;
        }
        short fParity = firstParity != null && !"".equals(firstParity) ? Short.parseShort(firstParity) : (short)0;
        short s = sParity = secondParity != null && !"".equals(secondParity) ? Short.parseShort(secondParity) : (short)0;
        if (fParity != 0 && fParity <= wgFmt.getWiegandCount()) {
            chr[fParity - 1] = 112;
        }
        if (sParity != 0 && sParity <= wgFmt.getWiegandCount()) {
            chr[sParity - 1] = 112;
        }
        String cidCompStr = new String(chr);
        return cidCompStr + ":" + oddEvenStr;
    }

    public int[] getParity(String fmt, char chr) {
        String str = String.valueOf(chr);
        int[] tempArray = new int[2];
        if ('p' == chr) {
            tempArray[0] = fmt.indexOf(str) + 1;
            tempArray[1] = fmt.lastIndexOf(str) + 1;
        } else {
            tempArray[0] = fmt.indexOf(str) + 1;
            int length = fmt.lastIndexOf(str) - fmt.indexOf(str);
            if (fmt.lastIndexOf(str) == -1) {
                tempArray[1] = 0;
            } else {
                int n = tempArray[1] = length > 0 ? length + 1 : 1;
            }
            if ('o' == chr || 'e' == chr) {
                int bStart = fmt.indexOf(98) + 1;
                int bLength = fmt.lastIndexOf(98) - fmt.indexOf(98);
                if (bLength > 0) {
                    tempArray[1] = tempArray[1] + bLength + 1;
                    if (tempArray[0] > bStart) {
                        tempArray[0] = tempArray[0] - (bLength + 1);
                    }
                }
            }
        }
        return tempArray;
    }

    public String isExist(String name) {
        boolean rs = !this.persWiegandFmtService.existsByName(name);
        return rs + "";
    }

    public ZKResultMsg checkSiteCode(String siteCode, String siteCodeCount) {
        ZKResultMsg rsm = new ZKResultMsg();
        boolean ret = true;
        BigInteger siteCodeNum = new BigInteger(siteCode);
        BigInteger maxSiteCode = new BigInteger("2").pow(Integer.parseInt(siteCodeCount)).subtract(new BigInteger("1"));
        if (siteCodeNum.compareTo(maxSiteCode) > 0) {
            ret = false;
        }
        rsm.setRet(String.valueOf(ret));
        return I18nUtil.i18nMsg((ZKResultMsg)rsm);
    }

    public boolean isExistAcc() {
        return this.persWiegandFmtService.isExistAcc();
    }
}

