/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersParamsRemote;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PersParamsController
extends BaseController
implements PersParamsRemote {
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersCardService persCardService;

    @RequiresPermissions(value={"pers:params:edit"})
    @LogRequest(module="pers_module", object="common_leftMenu_paramSet", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        params.put("pers.ocrCertNoType", params.get("certNoType"));
        params.put("pers.ocrDriveVerson", params.get("driverLink"));
        this.persParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.persParamsService.getPersParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String checkMaxPinLenth(@RequestParam(value="pers.pinLen") int pinLen) {
        long maxPinLen = this.persPersonService.getMaxPinLenth();
        return String.valueOf(maxPinLen <= (long)pinLen);
    }

    public String checkPinLenWithDev(@RequestParam(value="pinLen") int pinLen) {
        return String.valueOf(this.persParamsService.checkMaxPinLenthWithDev(Integer.valueOf(pinLen)));
    }

    public ZKResultMsg checkPinLetters(@RequestParam(value="pinSupportLetter") String pinSupportLetter) {
        if (StringUtils.isNotBlank((CharSequence)pinSupportLetter)) {
            if (Boolean.parseBoolean(pinSupportLetter)) {
                if (this.persParamsService.hasPullDev()) {
                    return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_param_noSupportPinLetter"));
                }
            } else {
                int personCount = this.persPersonService.checkPinIsExistLetters();
                if (personCount > 0) {
                    return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_param_donotChangePin"));
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public String checkPinIncrement(String pinSupportIncrement) {
        int count = this.persPersonService.checkPinIncrement(pinSupportIncrement);
        if (count > 0) {
            return String.valueOf(false);
        }
        return String.valueOf(true);
    }

    public String checkIsExistCard() {
        long count = this.persCardService.count();
        return String.valueOf(count > 0L);
    }

    public String checkIsExistCards() {
        long count = this.persCardService.countByCardType((short)1);
        return String.valueOf(count > 0L);
    }

    public String checkDevNoSupportMultiCard() {
        return String.valueOf(this.persParamsService.checkDevSupportMultiCard());
    }

    public ZKResultMsg checkMaxCardBit(@RequestParam(value="cardLen") int cardLen) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.persParamsService.checkDevMaxCardBit(cardLen));
    }

    public String checkSingleAttSystem() {
        return String.valueOf(this.persParamsService.checkSingleAttSystem());
    }
}

