/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.ResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiBioTemplateItem;
import com.zkteco.zkbiosecurity.pers.service.PersBioTemplateService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersBioTemplateItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/bioTemplate"})
@Api(tags={"PersBioTemplate"}, description="person bioTemplate")
public class PersApiBioTemplateController {
    private static final Logger log = LoggerFactory.getLogger(PersApiBioTemplateController.class);
    @Autowired
    private PersBioTemplateService persBioTemplateService;
    @Autowired
    private PersPersonService persPersonService;

    @ApiOperation(value="Get BioTemplate List", notes="Get BioTemplate List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getFgListByPin/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage list(@ApiParam(name="pin", value="pin", required=true) @RequestParam String pin) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        ArrayList<PersApiBioTemplateItem> apiBioTemplateList = new ArrayList<PersApiBioTemplateItem>();
        PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
        if (persPersonItem != null) {
            List persBioTemplateList = this.persBioTemplateService.getItemByPersonId(persPersonItem.getId());
            for (PersBioTemplateItem persBioTemplate : persBioTemplateList) {
                apiBioTemplateList.add(PersApiBioTemplateItem.createBioTemplate((PersBioTemplateItem)persBioTemplate));
            }
            rs.setData(apiBioTemplateList);
        } else {
            rs = ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Delete BioTemplate By pin And templateNo", notes="Delete BioTemplate By pin And templateNo", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/delete/{pin}{templateNo}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage delete(@ApiParam(name="pin", value="pin") @RequestParam String pin, @ApiParam(name="templateNo", value="templateNo") @RequestParam Short templateNo) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
        if (persPersonItem != null) {
            int result = this.persBioTemplateService.deleteBioTemplateByPinAndTemplateNo(pin, templateNo);
            if (result == 0) {
                rs = ApiResultMessage.message((int)-34, (String)I18nUtil.i18nCode((String)"pers_api_dataNotExist", (Object[])new Object[0]));
            }
        } else {
            rs = ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Add BioTemplate", notes="Add BioTemplate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage add(@RequestBody PersApiBioTemplateItem apiBioTemplate, HttpServletResponse response) {
        ApiResultMessage rs = new ApiResultMessage();
        int result = this.persBioTemplateService.addBioTemplate(apiBioTemplate);
        if (result == -31) {
            rs = ApiResultMessage.message((int)result, (String)I18nUtil.i18nCode((String)"pers_api_fingerprintExisted", (Object[])new Object[0]));
        } else if (result == -22) {
            rs = ApiResultMessage.message((int)result, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
        } else if (result == -32) {
            rs = ApiResultMessage.message((int)result, (String)I18nUtil.i18nCode((String)"pers_api_validtypeIncorrect", (Object[])new Object[0]));
        } else if (result == -33) {
            rs = ApiResultMessage.message((int)result, (String)I18nUtil.i18nCode((String)"pers_api_templateNoRang", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="deleteByPin BioTemplate", notes="deleteById BioTemplate", response=ResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/deleteByPin/{pin}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage deleteAll(@ApiParam(name="pin", value="pin") @RequestParam String pin) {
        ApiResultMessage rs = new ApiResultMessage();
        PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
        if (persPersonItem != null) {
            this.persBioTemplateService.deleteByPersonPin(pin);
        } else {
            rs = ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
        }
        return rs;
    }
}

