/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.client.service;

import com.zkteco.zkbiosecurity.att.client.utils.AttUploadPageUtil;
import com.zkteco.zkbiosecurity.att.service.AttCloudMessageSendService;
import com.zkteco.zkbiosecurity.att.service.AttDeviceService;
import com.zkteco.zkbiosecurity.att.vo.AttDeviceCloudItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AttDeviceMessageUpload {
    @Autowired
    private AttDeviceService attDeviceService;
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private AttCloudMessageSendService attCloudMessageSendService;

    @Scheduled(cron="0 0 0/1 * * ?")
    public ZKResultMsg attDeviceMessageUpload() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.attCloudMessageSendService.isActiveLicense()) {
            Long pushTime = this.attDeviceService.getLastPushTime();
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setAppId(this.baseLicenseService.getAppId());
            zkMessage.setModuleCode("att");
            zkMessage.setMessageId("attCloudDeviceHandleMessage#handleAttDeviceMessage");
            if (pushTime == null) {
                Long count = this.attDeviceService.getAllDeviceCount();
                if (count > 0L) {
                    int page = AttUploadPageUtil.getPage(count);
                    for (int i = 0; i < page; ++i) {
                        List attDeviceCloudItemList = this.attDeviceService.getDeviceCloudItems(new AttDeviceCloudItem(), i, 30);
                        if (attDeviceCloudItemList == null || attDeviceCloudItemList.size() <= 0) continue;
                        for (AttDeviceCloudItem attDeviceCloudItem : attDeviceCloudItemList) {
                            attDeviceCloudItem.setOnlineStatus(this.attDeviceService.getDevStatus(attDeviceCloudItem.getDevSn()));
                        }
                        zkMessage.setListContent(attDeviceCloudItemList);
                        this.baseLicenseClientService.sendMessage(zkMessage);
                    }
                }
            } else {
                Date lastUpdate = new Date(pushTime);
                List devInfoList = this.attDeviceService.getUploadCloudDevicesByLastPushTime(lastUpdate = DateUtil.addMinute((Date)lastUpdate, (int)-1));
                if (devInfoList != null && !devInfoList.isEmpty()) {
                    List devInfos = CollectionUtil.split((Collection)devInfoList, (int)30);
                    for (List devInfo : devInfos) {
                        if (devInfo == null || devInfo.size() <= 0) continue;
                        for (AttDeviceCloudItem attDeviceCloudItem : devInfo) {
                            attDeviceCloudItem.setOnlineStatus(this.attDeviceService.getDevStatus(attDeviceCloudItem.getDevSn()));
                        }
                        zkMessage.setListContent(devInfo);
                        this.baseLicenseClientService.sendMessage(zkMessage);
                    }
                }
            }
            this.attDeviceService.setLastPushTime();
        }
        return ZKResultMsg.successMsg();
    }
}

