/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POS_CARDMANAGE t LEFT JOIN POS_CARDKIND P ON P.ID=t.CARDKIND_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@Where(after="AND t.IS_VALID=0")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosCardManageItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @GridColumn(label="pos_card_deptNum", width="120")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_card_deptName", width="110")
    private String deptName;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pos_card_card", width="120")
    private String cardNo;
    @Column(name="t.SYS_CARD_NO")
    @GridColumn(label="pos_card_accountNum", width="120")
    private Integer sysCardNo;
    @Column(name="t.CARD_PRIVAGE")
    @GridColumn(label="pos_card_type", width="80", format="0=pos_card_generalCard,1=pos_card_manageCard,2=pos_card_operateCard")
    private Integer cardPrivage;
    @Column(name="P.NAME")
    @GridColumn(label="pos_card_cardName", width="120")
    private String name;
    @Column(name="t.BALANCE")
    @GridColumn(label="pos_card_blance")
    private Double balance;
    @Column(name="t.SUBBALANCE")
    @GridColumn(label="pos_card_subBlance", width="88", showExpression="true")
    private Double subBalance;
    @Column(name="t.CARD_STATUS")
    @GridColumn(label="pos_card_cardStatus", width="90", format="1=pos_card_valid,3=pos_op_lostCard,4=pos_card_pastDue,5=pos_card_stopUse")
    private String cardStatus;
    @Column(name="t.ISSUE_DATE")
    @GridColumn(label="pos_card_sendCardDate", width="140")
    private Date issueDate;
    @Column(name="t.CARD_PWD")
    @GridColumn(label="pos_cardManage_cardPwd", show=false)
    private String cardPwd;
    @Column(name="t.CARD_COST")
    @GridColumn(label="pos_cardManage_cardCost", show=false)
    private Double cardCost;
    @Column(name="t.MNG_COST")
    @GridColumn(label="pos_cardManage_mngCost", show=false)
    private Double mngCost;
    @Column(name="t.PASSWORD")
    @GridColumn(label="pos_cardManage_password", show=false)
    private String password;
    @Column(name="t.CARD_SERIAL_NUM")
    @GridColumn(label="pos_cardManage_cardSerialNum", show=false)
    private Integer cardSerialNum;
    @Column(name="t.IS_VALID")
    @GridColumn(label="pos_cardManage_isValid", show=false)
    private Integer isValid;
    @Column(name="t.POS_DATE")
    @GridColumn(label="pos_cardManage_posDate", show=false)
    private Date posDate;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="pos_cardManage_deptId", show=false)
    private String deptId;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="pos_cardManage_personId", show=false)
    private String personId;
    @Column(name="t.CARDKIND_ID")
    @GridColumn(label="pos_cardManage_posCardKind", show=false)
    private String posCardKindId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public PosCardManageItem() {
    }

    public PosCardManageItem(Boolean equals) {
        super(equals);
    }

    public PosCardManageItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosCardManageItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, Integer cardPrivage, Integer sysCardNo, String cardPwd, Double balance, Double cardCost, Double mngCost, String password, String cardNo, Integer cardSerialNum, Date issueDate, Integer isValid, String cardStatus, Date posDate, Double subBalance) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.cardPrivage = cardPrivage;
        this.sysCardNo = sysCardNo;
        this.cardPwd = cardPwd;
        this.balance = balance;
        this.cardCost = cardCost;
        this.mngCost = mngCost;
        this.password = password;
        this.cardNo = cardNo;
        this.cardSerialNum = cardSerialNum;
        this.issueDate = issueDate;
        this.isValid = isValid;
        this.cardStatus = cardStatus;
        this.posDate = posDate;
        this.subBalance = subBalance;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Integer getSysCardNo() {
        return this.sysCardNo;
    }

    public Integer getCardPrivage() {
        return this.cardPrivage;
    }

    public String getName() {
        return this.name;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Double getSubBalance() {
        return this.subBalance;
    }

    public String getCardStatus() {
        return this.cardStatus;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getCardPwd() {
        return this.cardPwd;
    }

    public Double getCardCost() {
        return this.cardCost;
    }

    public Double getMngCost() {
        return this.mngCost;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getCardSerialNum() {
        return this.cardSerialNum;
    }

    public Integer getIsValid() {
        return this.isValid;
    }

    public Date getPosDate() {
        return this.posDate;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPosCardKindId() {
        return this.posCardKindId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosCardManageItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosCardManageItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosCardManageItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosCardManageItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosCardManageItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosCardManageItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosCardManageItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PosCardManageItem setSysCardNo(Integer sysCardNo) {
        this.sysCardNo = sysCardNo;
        return this;
    }

    public PosCardManageItem setCardPrivage(Integer cardPrivage) {
        this.cardPrivage = cardPrivage;
        return this;
    }

    public PosCardManageItem setName(String name) {
        this.name = name;
        return this;
    }

    public PosCardManageItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosCardManageItem setSubBalance(Double subBalance) {
        this.subBalance = subBalance;
        return this;
    }

    public PosCardManageItem setCardStatus(String cardStatus) {
        this.cardStatus = cardStatus;
        return this;
    }

    public PosCardManageItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosCardManageItem setCardPwd(String cardPwd) {
        this.cardPwd = cardPwd;
        return this;
    }

    public PosCardManageItem setCardCost(Double cardCost) {
        this.cardCost = cardCost;
        return this;
    }

    public PosCardManageItem setMngCost(Double mngCost) {
        this.mngCost = mngCost;
        return this;
    }

    public PosCardManageItem setPassword(String password) {
        this.password = password;
        return this;
    }

    public PosCardManageItem setCardSerialNum(Integer cardSerialNum) {
        this.cardSerialNum = cardSerialNum;
        return this;
    }

    public PosCardManageItem setIsValid(Integer isValid) {
        this.isValid = isValid;
        return this;
    }

    public PosCardManageItem setPosDate(Date posDate) {
        this.posDate = posDate;
        return this;
    }

    public PosCardManageItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosCardManageItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosCardManageItem setPosCardKindId(String posCardKindId) {
        this.posCardKindId = posCardKindId;
        return this;
    }

    public PosCardManageItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public PosCardManageItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosCardManageItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosCardManageItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", cardNo=" + this.getCardNo() + ", sysCardNo=" + this.getSysCardNo() + ", cardPrivage=" + this.getCardPrivage() + ", name=" + this.getName() + ", balance=" + this.getBalance() + ", subBalance=" + this.getSubBalance() + ", cardStatus=" + this.getCardStatus() + ", issueDate=" + this.getIssueDate() + ", cardPwd=" + this.getCardPwd() + ", cardCost=" + this.getCardCost() + ", mngCost=" + this.getMngCost() + ", password=" + this.getPassword() + ", cardSerialNum=" + this.getCardSerialNum() + ", isValid=" + this.getIsValid() + ", posDate=" + this.getPosDate() + ", deptId=" + this.getDeptId() + ", personId=" + this.getPersonId() + ", posCardKindId=" + this.getPosCardKindId() + ", notInId=" + this.getNotInId() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

