/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.util;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLClientUtil {
    private static volatile SSLContext sslContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLContext createSSLContext(String type, String path, String password) throws Exception {
        if (null != sslContext) return sslContext;
        Class<SSLClientUtil> clazz = SSLClientUtil.class;
        synchronized (SSLClientUtil.class) {
            if (null != sslContext) return sslContext;
            KeyStore ks = KeyStore.getInstance(type);
            InputStream ksInputStream = SSLClientUtil.keyStoreInputStream(path);
            ks.load(ksInputStream, password.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sslContext;
        }
    }

    private static InputStream keyStoreInputStream(String urlStr) {
        try {
            if (urlStr.toLowerCase().startsWith("http://") || urlStr.toLowerCase().startsWith("https://")) {
                DataInputStream in = null;
                URL url = new URL(urlStr);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                in = new DataInputStream(conn.getInputStream());
                return in;
            }
            if (urlStr.toLowerCase().startsWith("classpath:")) {
                return SSLClientUtil.getInputStream(urlStr);
            }
            FileInputStream ksInputStream = new FileInputStream(urlStr);
            return ksInputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("url\u8f6c\u6362\u8f93\u5165\u6d41\u5931\u8d25,\u9519\u8bef\u4fe1\u606f{}" + e.getMessage());
            return null;
        }
    }

    public static InputStream getInputStream(String path) throws IOException {
        path = path.replace("classpath:", "");
        InputStream is = SSLClientUtil.class.getResourceAsStream(path);
        ClassLoader classLoader = SSLClientUtil.getDefaultClassLoader();
        if (is == null && classLoader != null) {
            is = classLoader.getResourceAsStream(path);
        }
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(path);
        }
        if (is == null) {
            throw new FileNotFoundException(" cannot be opened because it does not exist");
        }
        return is;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = SSLClientUtil.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

