/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.internal.util;

import com.zkteco.cloud.sdk.internal.util.StringUtils;
import com.zkteco.cloud.sdk.internal.util.WebUtils;
import com.zkteco.cloud.sdk.internal.util.ZKCloudUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ZKCLoudLogger {
    private static final String LOG_SPLIT = "^_^";
    private static String osName = System.getProperties().getProperty("os.name");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        ZKCLoudLogger.needEnableLogger = needEnableLogger;
    }

    public static void logApiError(String appKey, String apiName, String url, Map<String, String> params, long latency, String errorMessage) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ZKCLoudLogger.formatDateTime(new Date()));
        sb.append(LOG_SPLIT);
        sb.append(appKey);
        sb.append(LOG_SPLIT);
        sb.append(apiName);
        sb.append(LOG_SPLIT);
        sb.append(ZKCloudUtils.getIntranetIp());
        sb.append(LOG_SPLIT);
        sb.append(osName);
        sb.append(LOG_SPLIT);
        sb.append(latency);
        sb.append(LOG_SPLIT);
        sb.append(url);
        try {
            sb.append(LOG_SPLIT);
            sb.append(WebUtils.buildQuery(params, "utf-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append(LOG_SPLIT);
        sb.append(errorMessage);
    }

    private static String formatDateTime(Date date) {
        return StringUtils.formatDateTime(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }
}

