/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgWingGateRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceOptionService;
import com.zkteco.zkbiosecurity.psg.service.PsgWingGateService;
import com.zkteco.zkbiosecurity.psg.vo.PsgWingGateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgWingGateController
extends BaseController
implements PsgWingGateRemote {
    @Autowired
    private PsgWingGateService psgWingGateService;
    @Autowired
    private PsgDeviceOptionService psgDeviceOptionService;

    @RequiresPermissions(value={"psg:wingGate"})
    public ModelAndView index() {
        return new ModelAndView("psg/wingGate/psgWingGate");
    }

    @RequiresPermissions(value={"psg:wingGate:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String unmannedTimeRange;
            PsgWingGateItem item = this.psgWingGateService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            String delayCloseGateTimeRange = this.psgDeviceOptionService.getValueByNameAndDevSn(item.getDevSn(), "PassCloseDelayRange");
            if (!"0".equals(delayCloseGateTimeRange)) {
                this.request.setAttribute("delayCloseGateTimeRange", (Object)delayCloseGateTimeRange);
            }
            if (!"0".equals(unmannedTimeRange = this.psgDeviceOptionService.getValueByNameAndDevSn(item.getDevSn(), "PassUnmannedRange"))) {
                this.request.setAttribute("unmannedTimeRange", (Object)unmannedTimeRange);
            }
        }
        return new ModelAndView("psg/wingGate/editPsgWingGate");
    }

    @RequiresPermissions(value={"psg:wingGate:edit"})
    @LogRequest(module="psg_module", object="psg_device_wingGate", opType="common_op_edit", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg save(PsgWingGateItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgWingGateService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:wingGate:refresh"})
    public DxGrid list(PsgWingGateItem condition) {
        Pager pager = this.psgWingGateService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

