/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.psg.remote.PsgDeviceMonitorRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceMonitorService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceMonitorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgDeviceMonitorController
extends ExportController
implements PsgDeviceMonitorRemote {
    @Autowired
    private PsgDeviceService psgDeviceService;
    @Autowired
    private PsgDeviceMonitorService psgDeviceMonitorService;

    @RequiresPermissions(value={"psg:deviceMonitor", "psg:deviceMonitor:browse"})
    public ModelAndView index() {
        return new ModelAndView("psg/deviceMonitor/psgDeviceMonitor");
    }

    @RequiresPermissions(value={"psg:deviceMonitor:export"})
    @LogRequest(module="psg_module", object="common_leftMenu_devMonitioring", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        List psgDeviceMonitorItemList;
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        String queryConditions = request.getParameter("queryConditions");
        String[] conditionAry = queryConditions.replaceAll("%20", " ").split("&");
        String devStatus = "";
        for (String query : conditionAry) {
            if (!query.startsWith("devStatus")) continue;
            devStatus = query.split("=", 2)[1];
        }
        int beginIndex = 0;
        int exportCount = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.parseInt(recordStart) - 1;
            exportCount = Integer.parseInt(recordCount) > 30000 ? 30000 : Integer.parseInt(recordCount);
        }
        PsgDeviceItem psgDeviceItem = new PsgDeviceItem();
        this.setConditionValue((BaseItem)psgDeviceItem);
        String areaIds = this.psgDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            psgDeviceItem.setAreaIdIn(areaIds);
        }
        if (!(psgDeviceMonitorItemList = this.psgDeviceMonitorService.filterDeviceState(psgDeviceItem, beginIndex, exportCount, devStatus)).isEmpty()) {
            psgDeviceMonitorItemList.stream().forEach(psgDeviceMonitorItem -> {
                if (StringUtils.isBlank((CharSequence)psgDeviceMonitorItem.getLastError())) {
                    psgDeviceMonitorItem.setLastError(I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]));
                }
            });
        }
        this.excelExport(psgDeviceMonitorItemList, PsgDeviceMonitorItem.class);
    }

    @RequiresPermissions(value={"psg:deviceMonitor:clearCmdCache"})
    @LogRequest(module="psg_module", object="common_leftMenu_devMonitioring", opType="psg_dev_clearAllCmdCache", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg clearCmdCache(String sn, String alias) {
        this.psgDeviceService.clearCmdCache(sn, new String[0]);
        ZKResultMsg resultMsg = new ZKResultMsg();
        resultMsg.setMsg("common_devMonitor_clearCmdSuccess");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

