/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.controller;

import com.zkteco.zkbiosecurity.adms.remote.AdmsDevCmdRemote;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDevCmdItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdmsDevCmdController
extends ExportController
implements AdmsDevCmdRemote {
    @Autowired
    private AdmsDevCmdService admsDevCmdService;

    @RequiresPermissions(value={"adms:devCmd"})
    public ModelAndView index(String sn) {
        if (StringUtils.isNotBlank((CharSequence)sn)) {
            this.request.setAttribute("sn", (Object)sn);
        }
        return new ModelAndView("adms/devCmd/admsDevCmd");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.admsDevCmdService.getItemById(id));
        }
        return new ModelAndView("adms/devCmd/editAdmsDevCmd");
    }

    @RequiresPermissions(value={"adms:device:testCmd"})
    public ModelAndView testCmd(String sn) {
        if (StringUtils.isNotBlank((CharSequence)sn)) {
            this.request.setAttribute("sn", (Object)sn);
        }
        return new ModelAndView("adms/devCmd/testDevCmd");
    }

    public ZKResultMsg save(AdmsDevCmdItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.admsDevCmdService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg action(String sn, String cmdType, String cmdContent) {
        final Long cmdId = this.admsDevCmdService.addCmd(sn, cmdContent, Boolean.valueOf(false));
        ExecutorService threadPool = Executors.newSingleThreadExecutor();
        Future<Integer> future = threadPool.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer rs = null;
                for (int i = 0; i < 120; ++i) {
                    rs = AdmsDevCmdController.this.admsDevCmdService.getResultVal(cmdId);
                    if (rs != null) {
                        return rs;
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
        Integer rs2 = null;
        try {
            rs2 = future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (rs2 != null && rs2 >= 0) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    @RequiresPermissions(value={"adms:devCmd:clearCmd"})
    @LogRequest(module="adms_module", object="adms_devCmd_entity", opType="adms_devCmd_clearCmd", opContent="adms_devCmd_clearCmd")
    public ZKResultMsg clean() {
        ZKResultMsg res = new ZKResultMsg();
        this.admsDevCmdService.cleanAllCmd();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"adms:devCmd:refresh"})
    public DxGrid list(AdmsDevCmdItem codition) {
        Pager pager = this.admsDevCmdService.getItemListByPage(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        this.admsDevCmdService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"adms:devCmd:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AdmsDevCmdItem admsDevCmdItem = new AdmsDevCmdItem();
        this.setConditionValue((BaseItem)admsDevCmdItem);
        List admsDevCmdItemList = this.admsDevCmdService.getExportItemList(admsDevCmdItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(admsDevCmdItemList, AdmsDevCmdItem.class);
    }
}

