/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttMonthDetailReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttMonthDetailReportService;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.vo.AttMonthDetailReportItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttMonthDetailReportController
extends ExportController
implements AttMonthDetailReportRemote {
    @Autowired
    private AttMonthDetailReportService attMonthDetailReportService;
    @Autowired
    private AttRecordService attRecordService;
    @Autowired(required=false)
    private AuthDepartmentService authDepartmentService;

    @RequiresPermissions(value={"att:monthDetailReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attMonthDetail");
    }

    @RequiresPermissions(value={"att:monthDetailReport:refresh"})
    public DxGrid list(AttMonthDetailReportItem condition) {
        Pager pager = this.attMonthDetailReportService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:monthDetailReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_monthDetailReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttMonthDetailReportItem attMonthDetailReportItem = new AttMonthDetailReportItem();
        this.setConditionValue((BaseItem)attMonthDetailReportItem);
        List itemList = this.attRecordService.getMonthDetailReportItemData(request.getSession().getId(), AttMonthDetailReportItem.class, (BaseItem)attMonthDetailReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AttMonthDetailReportItem.class);
    }

    public Map<String, String> getAttSymbolsJson() {
        return this.attMonthDetailReportService.getAttSymbolsJson();
    }
}

