/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.constants.AttDeviceConstant;
import com.zkteco.zkbiosecurity.att.remote.AttDeviceRemote;
import com.zkteco.zkbiosecurity.att.service.AttDeviceOptionService;
import com.zkteco.zkbiosecurity.att.service.AttDeviceService;
import com.zkteco.zkbiosecurity.att.vo.AttDeviceItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.EmptyUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttDeviceController
extends BaseController
implements AttDeviceRemote {
    @Autowired
    private AttDeviceService attDeviceService;
    @Autowired
    private AttDeviceOptionService attDeviceOptionService;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;

    @RequiresPermissions(value={"att:device"})
    public ModelAndView index() {
        return new ModelAndView("att/device/attDevice");
    }

    @RequiresPermissions(value={"att:device:edit"})
    public ModelAndView edit(String id) {
        String ipAddress = this.request.getParameter("ipAddress");
        String devSn = this.request.getParameter("devSn");
        AttDeviceItem attDeviceItem = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            attDeviceItem = this.attDeviceService.getItemById(id);
        } else {
            attDeviceItem = new AttDeviceItem();
            attDeviceItem.setDevName(devSn);
            attDeviceItem.setDevSn(devSn);
            attDeviceItem.setIpAddress(ipAddress);
            attDeviceItem.setIsRegDevice(Boolean.valueOf(false));
            attDeviceItem.setTimeZone(DateFormatUtils.format((Date)new Date(), (String)"Z"));
        }
        this.request.setAttribute("item", (Object)attDeviceItem);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("att/device/editAttDevice");
    }

    @RequiresPermissions(value={"att:device:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="common_op_add", requestParams={"devName"}, opContent="att_device_authDevice")
    public ZKResultMsg auth(AttDeviceItem item) {
        if (StringUtils.isBlank((CharSequence)item.getId())) {
            item.setStatus(Boolean.valueOf(true));
            item.setCommPort(AttDeviceConstant.ATT_COMM_PORT);
            item.setUpdateFlag("111110101101");
            item.setDataDownFlag("000");
            item.setTransInterval(AttDeviceConstant.ATT_TRANS_INTERVAL);
            item.setTransTimes("00:00;14:05");
            item.setRealTime(AttDeviceConstant.ATT_REAL_TIME);
            item.setCmdCount(AttDeviceConstant.ATT_CMD_COUNT);
            item.setSearchInterval(AttDeviceConstant.ATT_SEARCH_INTERVAL);
            item.setEncrypt(String.valueOf(AttDeviceConstant.ATT_IS_ENCRYPT));
        } else {
            this.attDeviceService.updateEditInfo(item.getId(), item.getDevName(), item.getAreaId(), item.getTimeZone(), item.getIsRegDevice());
        }
        ZKResultMsg res = this.attDeviceService.authDevice(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:device:refresh"})
    public DxGrid list(AttDeviceItem condition) {
        Pager pager = this.attDeviceService.getItemsByAuthUserPage(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        List deviceItems = pager.getData();
        if (EmptyUtil.isNotEmpty((Collection)deviceItems)) {
            for (AttDeviceItem attDeviceItem : deviceItems) {
                attDeviceItem.setWaitCmdCount(this.attDeviceService.getWaitCmdCount(attDeviceItem.getDevSn()));
                attDeviceItem.setOnlineStatus(this.attDeviceService.getDevStatus(attDeviceItem.getDevSn()));
            }
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:device:del"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="common_op_del", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg delete(String ids) {
        this.attDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:device:enable"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="common_enable", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg enable(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:disable"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="common_disable", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg disable(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_syncDev", requestParams={"names"}, opContent="common_dev_name")
    @RequiresPermissions(value={"att:device:syncdev"})
    public ZKResultMsg syncDev(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.syncDev(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:settime"})
    public ModelAndView setTime(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("att/device/setTime");
    }

    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_account", requestParams={"startTime", "endTime"}, opContent="att_op_account")
    public ZKResultMsg verify(String ids) {
        String startTime = this.request.getParameter("startTime");
        String endTime = this.request.getParameter("endTime");
        ZKResultMsg zKResultMsg = this.attDeviceService.verify(ids, startTime, endTime);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:fillpin"})
    public ModelAndView fillPin(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("att/device/setFillPin");
    }

    public ZKResultMsg getPersonInfo(String ids) {
        String pin = this.request.getParameter("pin");
        ZKResultMsg zKResultMsg = this.attDeviceService.getPersonInfo(ids, pin);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:setstamp"})
    public ModelAndView setStamp(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        boolean isRegDevice = this.attDeviceService.checkExitIsRegDevice(ids);
        this.request.setAttribute("isRegDevice", (Object)isRegDevice);
        return new ModelAndView("att/device/setStamp");
    }

    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_check", requestParams={"ids"}, opContent="att_common_deviceId")
    public ZKResultMsg reUpload(String ids) {
        String isUploadAttLog = this.request.getParameter("isUploadAttLog") == null ? "0" : "1";
        String isUploadOperLog = this.request.getParameter("isUploadOperLog") == null ? "0" : "1";
        String isUploadAttPhoto = this.request.getParameter("isUploadAttPhoto") == null ? "0" : "1";
        ZKResultMsg zKResultMsg = this.attDeviceService.reUpload(ids, isUploadAttLog, isUploadOperLog, isUploadAttPhoto);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:deletecmd"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_deleteCmd", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg deleteCmd(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.deleteCmd(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:setsms"})
    public ModelAndView setSms(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("att/device/setSms");
    }

    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_dataSms", requestParams={"msg"}, opContent="att_common_msg")
    public ZKResultMsg addSms(String ids) {
        String startTime = this.request.getParameter("startTime");
        String msg = this.request.getParameter("msg");
        String min = this.request.getParameter("min");
        ZKResultMsg zKResultMsg = this.attDeviceService.addSms(ids, startTime, msg, min);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:clearattpic"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_clearAttPic", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg clearAttPic(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.clearAttPic(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:clearattlog"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="att_op_clearAttLog", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg clearAttLog(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.clearAttLog(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:reboot"})
    @LogRequest(module="att_module", object="att_leftMenu_device", opType="common_dev_reboot", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg reboot(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.reboot(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:device:getdevopt"})
    public ZKResultMsg getDevOpt(String ids) {
        ZKResultMsg zKResultMsg = this.attDeviceService.getDevOpt(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public String devNameVaild() {
        String devName = this.request.getParameter("devName");
        boolean ret = this.attDeviceService.vaildName(devName);
        return ret + "";
    }

    public String devSnVaild() {
        String devSn = this.request.getParameter("devSn");
        boolean ret = this.attDeviceService.vaildSn(devSn);
        return ret + "";
    }

    public String devIpVaild() {
        String ipAddress = this.request.getParameter("ipAddress");
        boolean ret = this.attDeviceService.vaildIpAdress(ipAddress);
        return ret + "";
    }

    public ZKResultMsg checkDeviceStatus(String ids) {
        if (!this.attDeviceService.checkDeviceStatus(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_device_disabledOrOffline", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg checkExitIsRegDevice(String ids) {
        if (!this.attDeviceService.checkDeviceStatus(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_device_disabledOrOffline", (Object[])new Object[0]));
        }
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (this.attDeviceService.checkExitIsRegDevice(ids)) {
            resultMsg.setRet("isReg");
        } else {
            resultMsg.setRet("noIsReg");
        }
        return resultMsg;
    }

    @RequiresPermissions(value={"att:device:search"})
    @LogRequest(module="att_module", object="common_leftMenu_device", opType="common_dev_searchDev", opContent="common_dev_searchDev")
    public ZKResultMsg searchDev(Long nowTime) {
        HashMap<String, Object> devInfo = new HashMap<String, Object>();
        List devcieItems = this.attDeviceService.searchDeviceList();
        devInfo.put("devCount", devcieItems.size());
        devInfo.put("devData", devcieItems);
        devInfo.put("nowTime", nowTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(devInfo));
    }

    public ZKResultMsg getAllIPSn() {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.attDeviceService.getAllIPSn()));
    }

    @RequiresPermissions(value={"att:device:queryOption"})
    public ZKResultMsg queryDeviceOption(String devId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONArray jsonArray = null;
        Map optionMap = this.attDeviceOptionService.getOptionMapByDevId(devId);
        if (optionMap.isEmpty()) {
            return resultMsg;
        }
        jsonArray = optionMap.containsKey("MultiBioDataCount") || optionMap.containsKey("MultiBioPhotoCount") ? this.buildDevOptionInfoExp(optionMap) : this.buildDevOptionInfo(optionMap);
        resultMsg.setData((Object)jsonArray);
        return resultMsg;
    }

    private JSONArray buildDevOptionInfoExp(Map<String, String> optionMap) {
        String multiBioDataSupport = optionMap.get("MultiBioDataSupport");
        String[] bioDataSupportAry = multiBioDataSupport.split(":");
        String multiBioPhotoSupport = optionMap.get("MultiBioPhotoSupport");
        String[] bioPhotoSupportAry = multiBioPhotoSupport.split(":");
        String multiBioDataCount = optionMap.get("MultiBioDataCount");
        String[] bioDataCountAry = multiBioDataCount.split(":");
        String maxMultiBioDataCount = optionMap.get("MaxMultiBioDataCount");
        String[] maxBioDataCountAry = maxMultiBioDataCount.split(":");
        String multiBioPhotoCount = optionMap.get("MultiBioPhotoCount");
        String[] bioPhotoCountAry = multiBioPhotoCount.split(":");
        String maxMultiBioPhotoCount = optionMap.get("MaxMultiBioPhotoCount");
        String[] maxBioPhotoCountAry = maxMultiBioPhotoCount.split(":");
        String bioVersion = optionMap.get("MultiBioVersion");
        String[] bioVersionAry = bioVersion.split(":");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        int i = 0;
        while (i < AttDeviceConstant.NEW_DEVICE_OPTION_NAME.size()) {
            String optionName = null;
            String optionValue = null;
            String optionKey1 = "";
            String optionKey2 = "";
            String optionKey = "";
            String index = "";
            jsonObject = new JSONObject();
            switch (i) {
                case 0: 
                case 8: {
                    optionKey1 = (String)AttDeviceConstant.NEW_DEVICE_OPTION_NAME.get(i);
                    optionKey2 = (String)AttDeviceConstant.NEW_DEVICE_OPTION_NAME.get(i + 1);
                    optionName = I18nUtil.i18nCode((String)((String)AttDeviceConstant.NEW_DEVICE_OPTION_I18N.get(optionKey1)), (Object[])new Object[0]);
                    String keyContent = optionMap.get(optionKey2);
                    optionValue = optionKey2.contains("AttLog") ? optionMap.get(optionKey1) + "/" + Integer.valueOf("".equals(keyContent) ? "0" : keyContent) * 10000 : optionMap.get(optionKey1) + "/" + Integer.valueOf("".equals(keyContent) ? "0" : keyContent) * 100;
                    jsonObject.put("optionName", (Object)optionName);
                    jsonObject.put("optionValue", (Object)optionValue);
                    jsonArray.add((Object)jsonObject);
                    i += 2;
                    break;
                }
                case 10: 
                case 16: 
                case 17: {
                    optionKey = (String)AttDeviceConstant.NEW_DEVICE_OPTION_NAME.get(i);
                    optionName = I18nUtil.i18nCode((String)((String)AttDeviceConstant.NEW_DEVICE_OPTION_I18N.get(optionKey)), (Object[])new Object[0]);
                    optionValue = optionMap.get(optionKey);
                    jsonObject.put("optionName", (Object)optionName);
                    jsonObject.put("optionValue", (Object)optionValue);
                    jsonArray.add((Object)jsonObject);
                    ++i;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    optionKey1 = (String)AttDeviceConstant.NEW_DEVICE_OPTION_NAME.get(i);
                    index = optionKey1.split("_")[1];
                    if (StringUtils.isNotBlank((CharSequence)index) && "1".equals(bioDataSupportAry[Integer.valueOf(index)])) {
                        optionName = I18nUtil.i18nCode((String)((String)AttDeviceConstant.NEW_DEVICE_OPTION_I18N.get(optionKey1)), (Object[])new Object[0]);
                        optionValue = bioDataCountAry[Integer.valueOf(index)] + "/" + maxBioDataCountAry[Integer.valueOf(index)];
                        jsonObject.put("optionName", (Object)optionName);
                        jsonObject.put("optionValue", (Object)optionValue);
                        jsonArray.add((Object)jsonObject);
                    }
                    if (3 == i && StringUtils.isNotBlank((CharSequence)index)) {
                        if ("1".equals(bioPhotoSupportAry[Integer.valueOf(index)])) {
                            jsonObject = new JSONObject();
                            optionKey1 = (String)AttDeviceConstant.NEW_DEVICE_OPTION_NAME.get(i + 1);
                            optionName = I18nUtil.i18nCode((String)((String)AttDeviceConstant.NEW_DEVICE_OPTION_I18N.get(optionKey1)), (Object[])new Object[0]);
                            optionValue = bioPhotoCountAry[Integer.valueOf(index)] + "/" + maxBioPhotoCountAry[Integer.valueOf(index)];
                            jsonObject.put("optionName", (Object)optionName);
                            jsonObject.put("optionValue", (Object)optionValue);
                            jsonArray.add((Object)jsonObject);
                        }
                        ++i;
                    }
                    ++i;
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    if (11 == i) {
                        jsonObject.put("optionName", (Object)(I18nUtil.i18nCode((String)"pers_person_templateVersion", (Object[])new Object[0]) + ":"));
                        jsonObject.put("optionValue", (Object)"");
                        jsonArray.add((Object)jsonObject);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(index = (optionKey = (String)AttDeviceConstant.NEW_DEVICE_OPTION_NAME.get(i)).split("_")[1])) && !"0".equals(bioVersionAry[Integer.valueOf(index)])) {
                        optionName = I18nUtil.i18nCode((String)((String)AttDeviceConstant.NEW_DEVICE_OPTION_I18N.get(optionKey)), (Object[])new Object[0]);
                        optionValue = bioVersionAry[Integer.valueOf(index)];
                        jsonObject = new JSONObject();
                        jsonObject.put("optionName", (Object)optionName);
                        jsonObject.put("optionValue", (Object)optionValue);
                        jsonArray.add((Object)jsonObject);
                    }
                    ++i;
                }
            }
        }
        return jsonArray;
    }

    private JSONArray buildDevOptionInfo(Map<String, String> optionMap) {
        String userCount = optionMap.get("UserCount");
        String maxUserCount = optionMap.get("~MaxUserCount");
        String faceCount = optionMap.get("FaceCount");
        String maxFaceCount = optionMap.get("~MaxFaceCount");
        String fPCount = optionMap.get("FPCount");
        String maxFingerCount = optionMap.get("~MaxFingerCount");
        String fvCount = optionMap.get("FvCount");
        String maxFvCount = optionMap.get("~MaxFvCount");
        String pvCount = optionMap.get("PvCount");
        String maxPvCount = optionMap.get("~MaxPvCount");
        String transactionCount = optionMap.get("TransactionCount");
        String maxAttLogCount = optionMap.get("~MaxAttLogCount");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        ArrayList versionList = new ArrayList();
        for (int i = 0; i < AttDeviceConstant.ATT_DEVICE_OPTION_SHOWLIST.size(); ++i) {
            String optionKey = (String)AttDeviceConstant.ATT_DEVICE_OPTION_SHOWLIST.get(i);
            String optionName = I18nUtil.i18nCode((String)((String)AttDeviceConstant.ATT_DEVICE_OPTION_I18N.get(optionKey)), (Object[])new Object[0]);
            String optionValue = null;
            jsonObject = new JSONObject();
            if (i < 6) {
                switch (i) {
                    case 0: {
                        if (StringUtils.isBlank((CharSequence)maxUserCount) || "0".equals(maxUserCount)) break;
                        optionValue = userCount + "/" + Integer.valueOf(maxUserCount) * 100;
                        break;
                    }
                    case 1: {
                        if (StringUtils.isBlank((CharSequence)maxFaceCount) || "0".equals(maxFaceCount)) break;
                        optionValue = faceCount + "/" + maxFaceCount;
                        break;
                    }
                    case 2: {
                        if (StringUtils.isBlank((CharSequence)maxFingerCount) || "0".equals(maxFingerCount)) break;
                        optionValue = fPCount + "/" + Integer.valueOf(maxFingerCount) * 100;
                        break;
                    }
                    case 3: {
                        if (StringUtils.isBlank((CharSequence)maxFvCount) || "0".equals(maxFvCount)) break;
                        optionValue = fvCount + "/" + Integer.valueOf(maxFvCount) * 100;
                        break;
                    }
                    case 4: {
                        if (StringUtils.isBlank((CharSequence)maxPvCount) || "0".equals(maxPvCount)) break;
                        optionValue = pvCount + "/" + maxPvCount;
                        break;
                    }
                    case 5: {
                        if (StringUtils.isBlank((CharSequence)maxAttLogCount) || "0".equals(maxAttLogCount)) break;
                        optionValue = transactionCount + "/" + Integer.valueOf(maxAttLogCount) * 10000;
                    }
                }
                continue;
            }
            if (i == 7) {
                JSONObject templateVersion = new JSONObject();
                templateVersion.put("optionName", (Object)(I18nUtil.i18nCode((String)"pers_person_templateVersion", (Object[])new Object[0]) + ":"));
                templateVersion.put("optionValue", (Object)"");
                jsonArray.add((Object)templateVersion);
            }
            optionValue = optionMap.get(optionKey);
            if (StringUtils.isBlank(optionValue) || "0".equals(optionValue)) continue;
            jsonObject.put("optionName", (Object)optionName);
            jsonObject.put("optionValue", (Object)optionValue);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    @RequiresPermissions(value={"att:device:search"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("att/device/opAttSearchDev");
    }

    public TreeItem tree() {
        List attDeviceItemList = this.attDeviceService.getByCondition(new AttDeviceItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem pItem = new TreeItem("0");
        TreeItem item = null;
        for (AttDeviceItem attDeviceItem : attDeviceItemList) {
            item = new TreeItem();
            item.setId(attDeviceItem.getId());
            item.setText(attDeviceItem.getDevName());
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

