/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttCustomRuleRemote;
import com.zkteco.zkbiosecurity.att.service.AttCustomRuleService;
import com.zkteco.zkbiosecurity.att.vo.AttCustomRuleItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttCustomRuleController
extends BaseController
implements AttCustomRuleRemote {
    @Autowired
    private AttCustomRuleService attCustomRuleService;

    @RequiresPermissions(value={"att:customRule"})
    public ModelAndView index() {
        return new ModelAndView("att/customRule/attCustomRule");
    }

    @RequiresPermissions(value={"att:customRule:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attCustomRuleService.getItemById(id));
        }
        return new ModelAndView("att/customRule/editAttCustomRule");
    }

    @RequiresPermissions(value={"att:customRule:edit"})
    public ZKResultMsg save(AttCustomRuleItem item) {
        String maxOverTimeType = item.getMaxOvertimeType();
        String maxOverTimeMinutes = item.getMaxOvertimeMinutes();
        String smallOvertime = item.getShortestOvertimeMinutes();
        if (!"notLimited".equals(maxOverTimeType) && Integer.valueOf(smallOvertime) > Integer.valueOf(maxOverTimeMinutes)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_rule_overtimeWarning", (Object[])new Object[0]));
        }
        this.attCustomRuleService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:customRule:refresh"})
    public DxGrid list(AttCustomRuleItem condition) {
        Pager pager = this.attCustomRuleService.getItemsByPage(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:customRule:del"})
    public ZKResultMsg delete(String ids) {
        this.attCustomRuleService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String ruleName) {
        boolean isExist = this.attCustomRuleService.existName(ruleName);
        return String.valueOf(!isExist);
    }

    public ModelAndView groupCustomRule(String groupIds) {
        this.request.setAttribute("groupIds", (Object)groupIds);
        return new ModelAndView("att/group/groupCustomRule");
    }

    public TreeItem groupCustomRuleTree() {
        AttCustomRuleItem condition = new AttCustomRuleItem();
        condition.setRuleType("0");
        List attCustomRuleItemList = this.attCustomRuleService.getByCondition(condition);
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AttCustomRuleItem attCustomRuleItem : attCustomRuleItemList) {
            item = new TreeItem();
            item.setId(attCustomRuleItem.getId());
            item.setText(attCustomRuleItem.getRuleName());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"att:customRule:edit"})
    public ZKResultMsg batchGroupCustomRule(String groupIds, String ruleId) {
        this.attCustomRuleService.batchGroupCustomRule(groupIds, ruleId);
        return ZKResultMsg.successMsg();
    }
}

