/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.msg.controller;

import com.zkteco.zkbiosecurity.att.api.msg.vo.AppMessageStateItem;
import com.zkteco.zkbiosecurity.att.api.msg.vo.AppStatisticalMsgCountMessageItem;
import com.zkteco.zkbiosecurity.att.service.AttMsgService;
import com.zkteco.zkbiosecurity.att.util.I18nMsgUtil;
import com.zkteco.zkbiosecurity.base.vo.ZKPageResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/msg"})
public class AttApiMsgController {
    @Autowired
    private AttMsgService attMsgService;

    @RequestMapping(path={"/getTodoMsg"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKPageResultMsg getTodoMsg(@RequestParam(name="customerId") String customerId, @RequestParam(name="currentPage") int currentPage, @RequestParam(name="pageSize") int pageSize, @RequestParam(name="businessCodes", required=false) String businessCodes, @RequestParam(name="filter", required=false) String filter) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attMsgService.getTodoMsg(customerId, currentPage, pageSize, businessCodes, filter);
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getNotifyMsg"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKPageResultMsg getNotifyMsg(@RequestParam(name="customerId") String customerId, @RequestParam(name="currentPage") int currentPage, @RequestParam(name="pageSize") int pageSize, @RequestParam(name="businessCodes", required=false) String businessCodes, @RequestParam(name="filter", required=false) String filter) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attMsgService.getNotifyMsg(customerId, currentPage, pageSize, businessCodes, filter);
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/changeMsgStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg changeMsgStatus(@RequestBody AppMessageStateItem appMessageStateItem) {
        String messageIds = appMessageStateItem.getId();
        ZKPageResultMsg resultMsg = this.attMsgService.changeMsgStatus(messageIds);
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/statisticalMsgCount"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg statisticalMsgCount(@RequestBody AppStatisticalMsgCountMessageItem appStatisticalMsgCountMessageItem) {
        String customerId = appStatisticalMsgCountMessageItem.getCustomerId();
        ZKPageResultMsg resultMsg = this.attMsgService.statisticalMsgCount(customerId, appStatisticalMsgCountMessageItem.getBusinessCodes());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }
}

