/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.api.vo.AppAttSignInItem;
import com.zkteco.zkbiosecurity.att.h5.service.AttApiH5RecordService;
import com.zkteco.zkbiosecurity.att.util.I18nMsgUtil;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.base.vo.ZKPageResultMsg;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5RecordController {
    @Autowired
    private AttApiH5RecordService attApiRecordH5Service;

    @RequestMapping(path={"/getAttendanceInfo"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getAttendanceInfo(@RequestParam(name="customerId") String customerId, @RequestParam(name="date") String date) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDate(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiRecordH5Service.getAttendanceInfo(customerId, date));
    }

    @RequestMapping(path={"/getAttendancePage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getAttendancePage(@RequestBody JSONObject data) {
        String customerId = data.getString("customerId");
        String date = data.getString("date");
        Integer page = data.getInteger("page");
        Integer pageSize = data.getInteger("pageSize");
        if (!ValidatorsUtils.isDate(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        if (page == null || pageSize == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        return I18nMsgUtil.i18nMsg(this.attApiRecordH5Service.getAttendancePage(customerId, date, page, pageSize));
    }

    @RequestMapping(path={"/getSignInList"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getSignInList(@RequestBody AppAttSignInItem appAttSignInItem) {
        String customerId = appAttSignInItem.getCustomerId();
        String date = appAttSignInItem.getDate();
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDate(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiRecordH5Service.getSignInList(appAttSignInItem));
    }

    @RequestMapping(path={"/getMonthReport"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getMonthReport(@RequestParam(name="customerId") String customerId, @RequestParam(name="date") String date) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isMonth(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiRecordH5Service.getMonthReport(customerId, date));
    }

    @RequestMapping(path={"/getDayDetailReport"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getDayDetailReport(@RequestParam(name="customerId") String customerId, @RequestParam(name="date") String date) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDate(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiRecordH5Service.getDayDetailReport(customerId, date));
    }

    @RequestMapping(path={"/getDayValidCard"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getDayValidCard(@RequestParam(name="customerId") String customerId, @RequestParam(name="date") String date) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDate(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiRecordH5Service.getDayValidCard(customerId, date));
    }

    @RequestMapping(path={"/getAttCalendar"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getAttCalendar(@RequestParam(name="customerId") String customerId, @RequestParam(name="schDate") String schDate) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isMonth(schDate)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiRecordH5Service.getAttCalendar(customerId, schDate));
    }
}

