/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AppAttApplyTaskItem;
import com.zkteco.zkbiosecurity.att.service.AttLeaveService;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5LeaveController {
    @Autowired
    private AttLeaveService attLeaveService;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;

    @RequestMapping(path={"/getLeaveTypeList"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLeaveTypeList() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attLeaveTypeService.listLeaveType());
    }

    @RequestMapping(path={"/calcApplyTimeLong"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg calcApplyTimeLong(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        String customerId = appAttApplyTaskItem.getCustomerId();
        String startTime = appAttApplyTaskItem.getStartTime();
        String endTime = appAttApplyTaskItem.getEndTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDateTime = null;
        Date endDateTime = null;
        try {
            startDateTime = sdf.parse(startTime);
            endDateTime = sdf.parse(endTime);
        }
        catch (ParseException e) {
            throw new ZKBusinessException("400", "att_timeSlot_time");
        }
        String leaveHours = this.attLeaveService.calLeaveTime(customerId, startDateTime, endDateTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)leaveHours));
    }
}

