/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleReaderRemote;
import com.zkteco.zkbiosecurity.ele.service.EleReaderService;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleReaderController
extends BaseController
implements EleReaderRemote {
    @Autowired
    private EleReaderService eleReaderService;

    @RequiresPermissions(value={"ele:reader"})
    public ModelAndView index() {
        return new ModelAndView("ele/reader/eleReader");
    }

    @RequiresPermissions(value={"ele:reader:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleReaderService.getItemById(id));
        }
        return new ModelAndView("ele/reader/editEleReader");
    }

    @RequiresPermissions(value={"ele:reader:edit"})
    @LogRequest(module="ele_module", object="common_leftMenu_reader", opType="common_op_edit", requestParams={"name"}, opContent="ele_reader_name")
    public ZKResultMsg save(EleReaderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String applyTo = this.request.getParameter("applyTo");
        this.eleReaderService.saveReader(item, applyTo, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:reader:refresh"})
    public DxGrid list(EleReaderItem condition) {
        Pager pager = this.eleReaderService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:reader:del"})
    public ZKResultMsg del(String ids) {
        this.eleReaderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getVerifyMode(String deviceId) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = new SelectItem();
        selectItem.setValue("1");
        selectItem.setText((Object)"\u6307\u7eb9");
        selectItems.add(selectItem);
        selectItem = new SelectItem();
        selectItem.setValue("2");
        selectItem.setText((Object)"\u6307\u7eb9\u6216\u5361");
        selectItems.add(selectItem);
        return new ZKResultMsg(selectItems);
    }

    public boolean isExist(EleReaderItem item) {
        String readerName = this.request.getParameter("readerName");
        if (!item.getName().equals(readerName)) {
            return this.eleReaderService.isExist(item.getName());
        }
        return true;
    }
}

