/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleDeviceMonitorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceMonitorService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceMonitorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleDeviceMonitorController
extends ExportController
implements EleDeviceMonitorRemote {
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleDeviceMonitorService eleDeviceMonitorService;

    @RequiresPermissions(value={"ele:deviceMonitor", "ele:deviceMonitor:browse"})
    public ModelAndView index() {
        return new ModelAndView("ele/deviceMonitor/eleDeviceMonitor");
    }

    @LogRequest(module="ele_module", object="common_leftMenu_devMonitioring", opType="ele_dev_clearAllCmdCache", requestParams={"alias"}, opContent="common_dev_name")
    @RequiresPermissions(value={"ele:deviceMonitor:clearCmdCache"})
    public ZKResultMsg clearCmdCache(String sn, String alias) {
        this.eleDeviceService.clearCmdCache(sn);
        ZKResultMsg resultMsg = new ZKResultMsg();
        resultMsg.setMsg("common_devMonitor_clearCmdSuccess");
        return resultMsg;
    }

    @LogRequest(module="ele_module", object="common_leftMenu_devMonitioring", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"ele:deviceMonitor:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        List eleDeviceMonitorItemList;
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        String queryConditions = request.getParameter("queryConditions");
        String[] conditionAry = queryConditions.replaceAll("%20", " ").split("&");
        String devStatus = "";
        for (String query : conditionAry) {
            if (!query.startsWith("devStatus")) continue;
            devStatus = query.split("=", 2)[1];
        }
        int beginIndex = 0;
        int endIndex = 30000;
        int exportCount = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.parseInt(recordStart) - 1;
            exportCount = Integer.parseInt(recordCount) > 30000 ? 30000 : Integer.parseInt(recordCount);
        }
        EleDeviceItem eleDeviceItem = new EleDeviceItem();
        this.setConditionValue((BaseItem)eleDeviceItem);
        String areaIds = this.eleDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            eleDeviceItem.setAreaIdIn(areaIds);
        }
        if (!(eleDeviceMonitorItemList = this.eleDeviceMonitorService.filterDeviceState(eleDeviceItem, beginIndex, exportCount, devStatus)).isEmpty()) {
            eleDeviceMonitorItemList.stream().forEach(eleDeviceMonitorItem -> {
                if (StringUtils.isBlank((CharSequence)eleDeviceMonitorItem.getLastError())) {
                    eleDeviceMonitorItem.setLastError(I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]));
                }
            });
        }
        this.excelExport(eleDeviceMonitorItemList, EleDeviceMonitorItem.class);
    }
}

