/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccTransactionPersonDoorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionPersonDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class AccTransactionPersonDoorController
extends ExportController
implements AccTransactionPersonDoorRemote {
    @Autowired
    private AccDoorService accDoorService;

    @RequiresPermissions(value={"acc:transactionByPerson:refresh"})
    public DxGrid list(AccTransactionPersonDoorItem condition) {
        Pager pager = this.accDoorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:transactionByPerson:export"})
    @LogRequest(module="acc_module", object="common_leftMenu_searchByPerson", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String personId = request.getParameter("personId");
        AccTransactionPersonDoorItem accTransactionPersonDoorItem = new AccTransactionPersonDoorItem();
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            accTransactionPersonDoorItem.setPersonId(personId);
        }
        List itemList = this.accDoorService.getPersonDoorItemData(AccTransactionPersonDoorItem.class, (BaseItem)accTransactionPersonDoorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccTransactionPersonDoorItem.class);
    }
}

