/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccTimeSegRemote;
import com.zkteco.zkbiosecurity.acc.service.AccTimeSegService;
import com.zkteco.zkbiosecurity.acc.vo.AccTimeSegItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccTimeSegController
extends BaseController
implements AccTimeSegRemote {
    private final int maxTimeSegCount = 255;
    @Autowired
    private AccTimeSegService accTimeSegService;

    @RequiresPermissions(value={"acc:timeSeg"})
    public ModelAndView index() {
        return new ModelAndView("acc/timeSeg/accTimeSeg");
    }

    @RequiresPermissions(value={"acc:timeSeg:edit", "acc:timeSeg:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("tempAccTimeSeg", (Object)this.accTimeSegService.getItemById(id));
        }
        return new ModelAndView("acc/timeSeg/editAccTimeSeg");
    }

    @RequiresPermissions(value={"acc:timeSeg:edit", "acc:timeSeg:add"})
    @LogRequest(module="acc_module", object="common_leftMenu_timeZone", opType="common_op_edit", requestParams={"name"}, opContent="common_timeSeg_name")
    public ZKResultMsg save(AccTimeSegItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accTimeSegService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:timeSeg:refresh"})
    public DxGrid list(AccTimeSegItem codition) {
        Pager pager = this.accTimeSegService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:timeSeg:del"})
    @LogRequest(module="acc_module", object="common_leftMenu_timeZone", opType="common_op_del", requestParams={"names"}, opContent="common_timeSeg_name")
    public ZKResultMsg del(String ids) {
        this.accTimeSegService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String name) {
        return this.accTimeSegService.validName(name);
    }

    public ZKResultMsg getTimeSegList() {
        return new ZKResultMsg((Object)this.accTimeSegService.getTimeSegList());
    }

    public ZKResultMsg dataValid(AccTimeSegItem accTimeSegItem) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String result = "true";
        int timeSegCount = this.accTimeSegService.getTimeSegList().size();
        if (timeSegCount == 255) {
            result = I18nUtil.i18nCode((String)"common_timeSeg_countError", (Object[])new Object[]{String.valueOf(255)});
            resultMsg.setData((Object)result);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        String checkResult = this.checkTimeseg(accTimeSegItem.getMondayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart1", (Object[])new Object[0]), accTimeSegItem.getMondayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd1", (Object[])new Object[0]), accTimeSegItem.getMondayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart2", (Object[])new Object[0]), accTimeSegItem.getMondayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd2", (Object[])new Object[0]), accTimeSegItem.getMondayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart3", (Object[])new Object[0]), accTimeSegItem.getMondayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getTuesdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart1", (Object[])new Object[0]), accTimeSegItem.getTuesdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd1", (Object[])new Object[0]), accTimeSegItem.getTuesdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart2", (Object[])new Object[0]), accTimeSegItem.getTuesdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd2", (Object[])new Object[0]), accTimeSegItem.getTuesdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart3", (Object[])new Object[0]), accTimeSegItem.getTuesdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getWednesdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart1", (Object[])new Object[0]), accTimeSegItem.getWednesdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd1", (Object[])new Object[0]), accTimeSegItem.getWednesdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart2", (Object[])new Object[0]), accTimeSegItem.getWednesdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd2", (Object[])new Object[0]), accTimeSegItem.getWednesdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart3", (Object[])new Object[0]), accTimeSegItem.getWednesdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getThursdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart1", (Object[])new Object[0]), accTimeSegItem.getThursdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd1", (Object[])new Object[0]), accTimeSegItem.getThursdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart2", (Object[])new Object[0]), accTimeSegItem.getThursdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd2", (Object[])new Object[0]), accTimeSegItem.getThursdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart3", (Object[])new Object[0]), accTimeSegItem.getThursdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getFridayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart1", (Object[])new Object[0]), accTimeSegItem.getFridayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd1", (Object[])new Object[0]), accTimeSegItem.getFridayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart2", (Object[])new Object[0]), accTimeSegItem.getFridayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd2", (Object[])new Object[0]), accTimeSegItem.getFridayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart3", (Object[])new Object[0]), accTimeSegItem.getFridayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getSaturdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart1", (Object[])new Object[0]), accTimeSegItem.getSaturdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd1", (Object[])new Object[0]), accTimeSegItem.getSaturdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart2", (Object[])new Object[0]), accTimeSegItem.getSaturdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd2", (Object[])new Object[0]), accTimeSegItem.getSaturdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart3", (Object[])new Object[0]), accTimeSegItem.getSaturdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getHolidayType1Start1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1Start1", (Object[])new Object[0]), accTimeSegItem.getHolidayType1End1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1End1", (Object[])new Object[0]), accTimeSegItem.getHolidayType1Start2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1Start2", (Object[])new Object[0]), accTimeSegItem.getHolidayType1End2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1End2", (Object[])new Object[0]), accTimeSegItem.getHolidayType1Start3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1Start3", (Object[])new Object[0]), accTimeSegItem.getHolidayType1End3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1End3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getHolidayType2Start1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2Start1", (Object[])new Object[0]), accTimeSegItem.getHolidayType2End1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2End1", (Object[])new Object[0]), accTimeSegItem.getHolidayType2Start2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2Start2", (Object[])new Object[0]), accTimeSegItem.getHolidayType2End2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2End2", (Object[])new Object[0]), accTimeSegItem.getHolidayType2Start3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2Start3", (Object[])new Object[0]), accTimeSegItem.getHolidayType2End3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2End3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(accTimeSegItem.getHolidayType3Start1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3Start1", (Object[])new Object[0]), accTimeSegItem.getHolidayType3End1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3End1", (Object[])new Object[0]), accTimeSegItem.getHolidayType3Start2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3Start2", (Object[])new Object[0]), accTimeSegItem.getHolidayType3End2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3End2", (Object[])new Object[0]), accTimeSegItem.getHolidayType3Start3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3Start3", (Object[])new Object[0]), accTimeSegItem.getHolidayType3End3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3End3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        resultMsg.setData((Object)result);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    private String checkTimeseg(String start1, String start1Vname, String end1, String end1Vname, String start2, String start2Vname, String end2, String end2Vname, String start3, String start3Vname, String end3, String end3Vname) {
        String checkResult = this.checkStartEndTime(start1, start1Vname, end1, end1Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start2, start2Vname, end2, end2Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start3, start3Vname, end3, end3Vname);
        if (checkResult != null) {
            return checkResult;
        }
        if (start1.equals("00:00") && end1.equals("00:00")) {
            if (!start2.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start2Vname});
            }
            if (!end2.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end2Vname});
            }
            if (!start3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start3Vname});
            }
            if (!end3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end3Vname});
            }
        } else if (start2.toString().equals("00:00") && end2.toString().equals("00:00")) {
            if (!start3.toString().equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start3Vname});
            }
            if (!end3.toString().equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end3Vname});
            }
        } else {
            if (DateUtil.stringToDate((String)start2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end1, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start2Vname, end1Vname});
            }
            if (!end3.equals("00:00") && DateUtil.stringToDate((String)start3, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start3Vname, end2Vname});
            }
        }
        return null;
    }

    private String checkStartEndTime(String startTime, String startVname, String endTime, String endVname) {
        Date startDate = DateUtil.stringToDate((String)startTime, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM);
        Date endDate = DateUtil.stringToDate((String)endTime, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM);
        if (startDate.getTime() > endDate.getTime()) {
            return I18nUtil.i18nCode((String)"common_timeSeg_fillError4", (Object[])new Object[]{startVname, endVname});
        }
        if (startDate.getTime() == endDate.getTime() && !startTime.toString().equals("00:00")) {
            return I18nUtil.i18nCode((String)"common_timeSeg_fillError5", (Object[])new Object[]{startVname, endVname});
        }
        return null;
    }
}

