/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.remote.AccMapRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccMapPosService;
import com.zkteco.zkbiosecurity.acc.service.AccMapService;
import com.zkteco.zkbiosecurity.acc.service.AccParamService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.utils.AccEnumUtil;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMapItem;
import com.zkteco.zkbiosecurity.acc.vo.AccMapPosItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccMapController
extends BaseController
implements AccMapRemote {
    @Autowired
    private AccMapService accMapService;
    @Autowired
    private AccMapPosService accMapPosService;
    @Autowired
    private AccParamService accParamService;
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccDeviceService accDeviceService;
    private static final long MAX_FILE_SIZE = 0x500000L;

    @RequiresPermissions(value={"acc:map"})
    public ModelAndView index() {
        String loadPlugins = (String)this.accParamService.getVidParams().get("vid.loadPlugins");
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        return new ModelAndView("acc/map/accMap");
    }

    @RequiresPermissions(value={"acc:map:add", "acc:map:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accMapService.getItemById(id));
            this.request.setAttribute("editPage", (Object)true);
        }
        return new ModelAndView("acc/map/editAccMap");
    }

    @RequiresPermissions(value={"acc:map:add", "acc:map:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="common_op_edit", requestParams={"name"}, opContent="base_map_name")
    public ZKResultMsg save(@RequestParam(value="file", required=false) MultipartFile file, AccMapItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String modify = this.request.getParameter("modify_path");
        String path = this.systemFilePath + File.separator + "/upload/acc/accMap";
        if (StringUtils.isBlank((CharSequence)item.getId()) || "on".equals(modify)) {
            AccMapItem oldMap;
            File oldPic;
            if (file == null || file.getSize() > 0x500000L) {
                throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"acc_map_imgSizeError", (Object[])new Object[]{5}), (Object[])new Object[0]);
            }
            File upLoadPicPath = new File(path);
            if (!upLoadPicPath.isAbsolute()) {
                path = ClassUtil.getRootPath() + "/" + path;
                upLoadPicPath = new File(path);
            }
            if (!upLoadPicPath.exists()) {
                upLoadPicPath.mkdirs();
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getId()}) && (oldPic = new File((oldMap = this.accMapService.getItemById(item.getId())).getMapPath())).exists()) {
                oldPic.delete();
            }
            long fName = System.currentTimeMillis();
            item.setMapPath(path + "/" + fName + ".jpg");
            try {
                String mapName = path + "/" + fName + ".jpg";
                File mapFile = new File(mapName);
                file.transferTo(mapFile);
            }
            catch (IOException e) {
                throw new ZKBusinessException("AccMapItem SaveMap Exception");
            }
        }
        this.accMapService.saveItem(item);
        res.setData((Object)item.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:map:refresh"})
    public DxGrid list(AccMapItem codition) {
        Pager pager = this.accMapService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:map:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="common_op_del", requestParams={"name"}, opContent="base_map_name")
    public ZKResultMsg del(String ids) {
        this.accMapService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getMapTree() {
        List items = this.accMapService.createMapTree(this.request.getSession().getId());
        if (items == null || items.isEmpty()) {
            TreeItem infoItem = new TreeItem();
            infoItem.setId("_");
            infoItem.setText("<span class='warningColor'>" + I18nUtil.i18nCode((String)"base_map_addMap", (Object[])new Object[0]) + "</span>");
            infoItem.setIm0("comm_iconAlert.png");
            items.add(infoItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ModelAndView getMap(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccMapItem tempMapItem = this.accMapService.getItemById(id);
            String imgBase64Str = "";
            String mapPath = tempMapItem.getMapPath();
            File mapfile = new File(mapPath);
            if (mapfile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(mapfile);
                    byte[] data = new byte[((InputStream)in).available()];
                    ((InputStream)in).read(data);
                    imgBase64Str = Base64Utils.encodeToString((byte[])data);
                    tempMapItem.setMapPath("data:image/jpg;base64," + imgBase64Str);
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new ZKBusinessException("AccMapController getMap base64 error");
                }
            }
            AccMapPosItem accMapPosItem = new AccMapPosItem();
            accMapPosItem.setMapId(id);
            ArrayList<AccMapPosItem> mapPosList = new ArrayList<AccMapPosItem>();
            List mapPosItemList = this.accMapPosService.getByCondition(accMapPosItem);
            boolean isShow = true;
            for (AccMapPosItem pos : mapPosItemList) {
                Map channelMap;
                isShow = true;
                if ("AccDoor".equals(pos.getEntityType())) {
                    AccDoorItem accDoorItem = this.accDoorService.getItemById(pos.getEntityId());
                    AccDeviceItem accDeviceItem = this.accDeviceService.getItemById(accDoorItem.getDeviceId());
                    if (accDeviceItem.getWgReaderId() != null) {
                        isShow = false;
                    }
                    if (!accDoorItem.getEnabled().booleanValue()) {
                        isShow = false;
                    }
                    pos.setEntityName(accDoorItem.getName());
                } else if ("VidChannel".equals(pos.getEntityType()) && (channelMap = this.accMapPosService.getVidChannelById(pos.getEntityId())).size() > 0) {
                    Boolean enabled = Boolean.valueOf((String)channelMap.get("enabled"));
                    if (!enabled.booleanValue()) {
                        isShow = false;
                    }
                    pos.setEntityName((String)channelMap.get("name"));
                }
                if (!isShow) continue;
                mapPosList.add(pos);
            }
            this.request.setAttribute("tempMap", (Object)tempMapItem);
            this.request.setAttribute("mapPosList", mapPosList);
            this.request.setAttribute("mapId", (Object)id);
        }
        String personPhotoMaxHeight = this.accParamService.getParamValByName("acc.personPhotoMaxHeight");
        String accIsShowPhoto = this.accParamService.getParamValByName("acc.isShowPhoto");
        String accIsShowSound = this.accParamService.getParamValByName("acc.isShowSound");
        String loadPlugins = (String)this.accParamService.getVidParams().get("vid.loadPlugins");
        this.request.setAttribute("personPhotoMaxHeight", (Object)personPhotoMaxHeight);
        this.request.setAttribute("accIsShowPhoto", (Object)accIsShowPhoto);
        this.request.setAttribute("accIsShowSound", (Object)accIsShowSound);
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        this.request.setAttribute("gridName", (Object)this.request.getParameter("gridName"));
        return new ModelAndView("acc/map/accMapRTMonitor");
    }

    @RequiresPermissions(value={"acc:map:saveMapPos"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="common_op_savePositon", requestParams={"name"}, opContent="base_map_name")
    public ZKResultMsg saveMapPos(String mapId, Double mapWidth, Double mapHeight, String posArray) {
        this.accMapService.saveMapPos(mapId, mapWidth, mapHeight, posArray);
        if ("addEntityToMap".equals(this.request.getParameter("flag"))) {
            return null;
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:map:addDoorToMap"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="acc_map_addDoor", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg addDoor(String mapId, Double width, String entityType, String entityIds, String logMethod) {
        this.accMapService.addEntity(mapId, width, entityType, entityIds, logMethod);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:map:addChannelToMap"})
    @LogRequest(module="acc_module", object="acc_leftMenu_electronicMap", opType="acc_map_addChannel", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg addChannel(String mapId, Double width, String entityType, String entityIds, String logMethod) {
        this.accMapService.addEntity(mapId, width, entityType, entityIds, logMethod);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(AccMapItem item) {
        String mapName = this.request.getParameter("mapName");
        if (!item.getName().equals(mapName)) {
            return this.accMapService.isExist(item.getName());
        }
        return true;
    }

    @RequiresPermissions(value={"acc:map:addDoorToMap", "acc:map:addChannelToMap"})
    public ModelAndView getEntitySelectItem(String mapId, String entityType, String width) {
        this.request.setAttribute("mapId", (Object)mapId);
        this.request.setAttribute("entityType", (Object)entityType);
        this.request.setAttribute("width", (Object)width);
        if (entityType.equals("AccDoor")) {
            this.request.setAttribute("logMethod", (Object)"addDoorToMap");
            return new ModelAndView("acc/map/accMapSelectDoor");
        }
        this.request.setAttribute("logMethod", (Object)"addChannelToMap");
        return new ModelAndView("acc/map/accMapSelectChannel");
    }

    public ZKResultMsg isExistVid() {
        ZKResultMsg res = new ZKResultMsg();
        if (!this.accMapService.isExistVidDevice()) {
            res.setRet("false");
            res.setMsg("common_vid_noDev");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @MessageMapping(value={"/accMapMonitor/getDoorState"})
    @SendTo(value={"/topic/accMapMonitor/getDoorState"})
    public Object getDoorState(String params) {
        JSONObject paramJson = JSONObject.parseObject((String)params);
        JSONObject resultJson = new JSONObject();
        JSONArray doorStates = new JSONArray();
        JSONArray doorStateArray = (JSONArray)this.accRTMonitorService.getDoorState(paramJson.getString("doorIds")).getData();
        if (Objects.nonNull(doorStateArray) && doorStateArray.size() > 0) {
            for (int i = 0; i < doorStateArray.size(); ++i) {
                JSONObject door = doorStateArray.getJSONObject(i);
                JSONObject data = new JSONObject();
                int sensor = door.getIntValue("sensor");
                int relay = door.getIntValue("relay");
                int alarm = door.getIntValue("alarm");
                int connect = door.getIntValue("connect");
                short alarmLevel = door.getShortValue("alarmLevel");
                int doorState = door.getIntValue("doorState");
                boolean isNewAccess = door.getBooleanValue("isNewAccess");
                String alarmValue = AccEnumUtil.Alarm.getValue(doorState, alarmLevel, alarm);
                data.put("id", (Object)door.getString("id"));
                data.put("areaId", (Object)door.getString("areaId"));
                data.put("devAlias", (Object)door.getString("devAlias"));
                data.put("devSn", (Object)door.getString("devSn"));
                data.put("no", (Object)door.getString("no"));
                data.put("name", (Object)door.getString("name"));
                data.put("connect", (Object)connect);
                data.put("sensor", (Object)AccEnumUtil.Sensor.getValue(doorState, sensor));
                data.put("relay", (Object)AccEnumUtil.Relay.getValue(doorState, relay));
                data.put("alarm", (Object)alarmValue);
                if (isNewAccess) {
                    alarmLevel = 0;
                }
                data.put("image", (Object)AccEnumUtil.DoorImage.getValue(doorState, connect, alarmLevel, alarm, relay, sensor));
                data.put("lockDisplay", (Object)door.getString("lockDisplay"));
                data.put("opDisplay", (Object)(doorState == 1 || doorState == 3 ? "inline" : "none"));
                data.put("iconFolderName", (Object)door.getString("iconFolderName"));
                if (connect == 0) {
                    data.put("audio", (Object)"/public/media/sound/alarm.wav");
                } else if (alarm > 0 && !door.getBoolean("isDisableAudio").booleanValue()) {
                    data.put("audio", (Object)"/public/media/sound/alarm.wav");
                }
                doorStates.add((Object)data);
            }
            resultJson.put("doorStates", (Object)doorStates);
        }
        resultJson.put("clientId", (Object)paramJson.getString("clientId"));
        return resultJson;
    }

    @MessageMapping(value={"/accMapMonitor/getEventData"})
    @SendTo(value={"/topic/accMapMonitor/getEventData"})
    public JSONObject getEventData() {
        return null;
    }

    public ModelAndView getVidPreview() {
        String channelId = this.request.getParameter("channelId");
        this.request.setAttribute("channelId", (Object)channelId);
        String vidDevice = this.request.getParameter("vidDevice");
        this.request.setAttribute("vidDevice", (Object)vidDevice);
        ModelAndView modelAndView = new ModelAndView("vid/preview/opVidPreview");
        if (this.accMapService.isExistVid()) {
            String loadPlugins = (String)this.accParamService.getVidParams().get("vid.loadPlugins");
            this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        } else if (this.accMapService.isExistVms()) {
            Map vmsChannelMap = this.accMapService.getVmsChannelById(channelId);
            if (Objects.nonNull(vmsChannelMap) && !vmsChannelMap.isEmpty()) {
                this.request.setAttribute("serialNumber", vmsChannelMap.get("serialNumber"));
                this.request.setAttribute("channelNo", vmsChannelMap.get("channelNo"));
            }
            return new ModelAndView("vms/preview/opVmsPreview");
        }
        return modelAndView;
    }
}

