/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccLevelRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccTimeSegService;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelSelectDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccLevelController
extends ExportController
implements AccLevelRemote {
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AccTimeSegService accTimeSegService;
    @Autowired
    private AccPersonService accPersonService;

    @RequiresPermissions(value={"acc:level"})
    public ModelAndView index() {
        return new ModelAndView("acc/level/accLevel");
    }

    @RequiresPermissions(value={"acc:level:add", "acc:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("personCount", (Object)this.accLevelService.getLevelPersonCount(id));
            this.request.setAttribute("doorCount", (Object)this.accLevelService.getLevelDoorCount(id));
            this.request.setAttribute("item", (Object)this.accLevelService.getItemById(id));
        } else {
            this.request.setAttribute("timeSegId", (Object)(Objects.nonNull(this.accTimeSegService.getInitTimeSeg()) ? this.accTimeSegService.getInitTimeSeg().getId() : ""));
        }
        return new ModelAndView("acc/level/editAccLevel");
    }

    @RequiresPermissions(value={"acc:level:add", "acc:level:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_op_edit", requestParams={"name"}, opContent="common_level_name")
    public ZKResultMsg save(AccLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        item = this.accLevelService.saveItem(item);
        String levelId = item.getId();
        if (StringUtils.isNotBlank((CharSequence)levelId)) {
            this.accLevelService.syncTimeSegVisLevelToDev(levelId);
            if (item.getChangeLevel() != null && item.getChangeLevel().booleanValue()) {
                List deviceIdList = this.accLevelService.getDevIdsByLevelId(levelId);
                List personIdList = this.accLevelService.getPersonIdsByLevelId(levelId);
                ArrayList tempPersonIdList = new ArrayList();
                int devSize = deviceIdList.size();
                for (int i = 0; i < devSize; ++i) {
                    int total = (int)((double)i * 100.0 / (double)devSize);
                    total = total == 100 ? 99 : total;
                    int personSize = personIdList.size();
                    for (int j = 0; j < personSize; ++j) {
                        tempPersonIdList.add(personIdList.get(j));
                        if (tempPersonIdList.size() % 500 != 0) continue;
                        this.accLevelService.syncTimeSegLevelToDev((String)deviceIdList.get(i), tempPersonIdList);
                        this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                    if (tempPersonIdList.size() > 0) {
                        this.accLevelService.syncTimeSegLevelToDev((String)deviceIdList.get(i), tempPersonIdList);
                        this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        tempPersonIdList = new ArrayList();
                    }
                    this.accLevelService.issuedDownloadToDev("devType", (String)deviceIdList.get(i));
                }
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]), "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        res.setData((Object)item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:level:refresh"})
    public DxGrid list(AccLevelItem codition) {
        Pager pager = this.accLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:level:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_op_del", requestParams={"names"}, opContent="common_level_name")
    public ZKResultMsg del(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(ids.split(",")));
            AccLevelItem accLevelItem = new AccLevelItem();
            accLevelItem.setInitFlag(Boolean.valueOf(true));
            if (levelIdList.contains(((AccLevelItem)this.accLevelService.getByCondition(accLevelItem).get(0)).getId())) {
                resultMsg.setRet("500");
                resultMsg.setMsg("common_prompt_initDataCanNotDel");
            } else {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
                ArrayList tempPersonIdList = new ArrayList();
                int levelSize = levelIdList.size();
                for (int i = 0; i < levelSize; ++i) {
                    int total = (int)((double)i * 100.0 / (double)levelSize);
                    total = total == 100 ? 99 : total;
                    List personIdList = this.accLevelService.getPersonIdsByLevelId((String)levelIdList.get(i));
                    if (personIdList != null && personIdList.size() > 0) {
                        List deviceIdList = this.accLevelService.getDevIdsByLevelId((String)levelIdList.get(i));
                        for (String deviceId : deviceIdList) {
                            int personSize = personIdList.size();
                            for (int j = 0; j < personSize; ++j) {
                                tempPersonIdList.add(personIdList.get(j));
                                if (tempPersonIdList.size() % 500 != 0) continue;
                                this.accLevelService.immeDelLevel(deviceId, (String)levelIdList.get(i), tempPersonIdList);
                                this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                                tempPersonIdList = new ArrayList();
                            }
                            if (tempPersonIdList.size() <= 0) continue;
                            this.accLevelService.immeDelLevel(deviceId, (String)levelIdList.get(i), tempPersonIdList);
                            this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                        }
                        continue;
                    }
                    this.accLevelService.delAccLevelDoorByLevelId((String)levelIdList.get(i));
                }
                this.accLevelService.deleteByIds(ids);
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getLevelList() {
        return new ZKResultMsg((Object)this.accLevelService.getLevelList(this.request.getSession().getId()));
    }

    public DxGrid selectDoorlist(AccLevelSelectDoorItem codition) {
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        String levelId = codition.getLevelId();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (doorIdList != null && doorIdList.size() > 0) {
                codition.setSelectId(codition.getSelectId() + "," + StringUtils.join((Iterable)doorIdList, (String)","));
            }
            codition.setSelectDoorIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDoorIdsIn(codition.getSelectId());
        }
        codition.setFilterId(levelId);
        codition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.accDoorService.getPagerFilterAuth(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:level:addDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_map_addDoor", requestParams={"levelName", "doorNames"}, opContent="common_level_name")
    public ZKResultMsg addDoor(String levelId, String doorIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)doorIds)) {
            ArrayList<String> doorIdList = new ArrayList<String>(Arrays.asList(doorIds.split(",")));
            List asWGReaderDoorIdList = this.accDoorService.getDoorIdsAsWGReaderByDoorId(doorIdList);
            if (asWGReaderDoorIdList != null && asWGReaderDoorIdList.size() > 0) {
                doorIdList.addAll(asWGReaderDoorIdList);
            }
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.accLevelService.addLevelByParamIds(StringUtils.join(doorIdList, (String)","), levelId, "door");
            List deviceIdList = this.accDoorService.getDevAndParentDevIdsByDoorIds(doorIdList);
            List personIdList = this.accLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.accPersonService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.accLevelService.handleLevelAddDoor(personArrayId, StringUtils.join((Iterable)deviceIdList, (String)","), levelId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
                this.accLevelService.issuedDownloadToDev("devType", StringUtils.join((Iterable)deviceIdList, (String)","));
            }
            this.accLevelService.setVisitorToDev(levelId, deviceIdList);
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:level:delDoor"})
    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_level_doorDelete", requestParams={"levelName", "doorNames"}, opContent="common_level_name")
    public ZKResultMsg delDoor(String levelId, String doorIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)doorIds)) {
            ArrayList<String> doorIdList = new ArrayList<String>(Arrays.asList(doorIds.split(",")));
            List asWGReaderDoorIdList = this.accDoorService.getDoorIdsAsWGReaderByDoorIdAndLevelId(doorIdList, levelId);
            if (asWGReaderDoorIdList != null && asWGReaderDoorIdList.size() > 0) {
                doorIdList.addAll(asWGReaderDoorIdList);
            }
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.accLevelService.delLevelDoorByParams(levelId, doorIdList);
            List deviceIdList = this.accDoorService.getDevIdsByDoorIds(doorIdList);
            List personIdList = this.accLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.accPersonService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.accLevelService.handleLevelDelDoor(levelId, personArrayId, StringUtils.join((Iterable)deviceIdList, (String)","));
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            this.accLevelService.delVisitorToDev(levelId, deviceIdList);
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:level:refresh"})
    public DxGrid doorList(AccLevelDoorItem codition) {
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        if (doorIdList != null && doorIdList.size() > 0) {
            codition.setNotInId(StringUtils.join((Iterable)doorIdList, (String)","));
        }
        Pager pager = this.accDoorService.accLevelDoorList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg doorListByApp(String id) {
        AccLevelDoorItem condition = new AccLevelDoorItem();
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        if (doorIdList != null && doorIdList.size() > 0) {
            condition.setNotInId(StringUtils.join((Iterable)doorIdList, (String)","));
        }
        List acclevels = this.accLevelService.getLevelByPersonId(id);
        ArrayList doors = new ArrayList();
        for (AccLevelItem item : acclevels) {
            String levelId = item.getId();
            condition.setAccLevelId(levelId);
            List doorItems = this.accDoorService.getItemsByPage((BaseItem)condition, 0, 1000000).getData();
            doors.addAll(doorItems);
        }
        ZKResultMsg msg = new ZKResultMsg(doors);
        return msg;
    }

    public String valid(String name) {
        AccLevelItem item = this.accLevelService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    @RequiresPermissions(value={"acc:level:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccLevelDoorItem accLevelDoorItem = new AccLevelDoorItem();
        this.setConditionValue((BaseItem)accLevelDoorItem);
        List accLevelDoorItemList = this.accDoorService.getExportItemList(accLevelDoorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(accLevelDoorItemList, AccLevelDoorItem.class);
    }

    public ZKResultMsg getPersonCount(String levelId) {
        Long personCount = this.accLevelService.getLevelPersonCount(levelId);
        return new ZKResultMsg((Object)personCount);
    }

    public ZKResultMsg levelIsDelete(String ids) {
        ZKResultMsg zkResultMsg = this.accLevelService.levelIsDelete(ids);
        if ("vis".equals(zkResultMsg.getData())) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"acc_level_visUsed", (Object[])new Object[]{zkResultMsg.getMsg()}));
        }
        return zkResultMsg;
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_8", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:openDoor"})
    public ZKResultMsg openDoor(String ids, String openInterval) {
        Map dataMap = this.accLevelService.operateDoor("openDoor", openInterval, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_9", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:closeDoor"})
    public ZKResultMsg closeDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("closeDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_7", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:cancelAlarmDoor"})
    public ZKResultMsg cancelAlarmDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("cancelAlarm", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_8", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:normalOpenDoor"})
    public ZKResultMsg normalOpenDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("normalOpenDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_enable", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:enableDoor"})
    public ZKResultMsg enableDoor(String ids) {
        ZKResultMsg res = this.accLevelService.enableDoor(ids, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="common_disable", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:disableDoor"})
    public ZKResultMsg disableDoor(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        this.accLevelService.disableDoor(ids, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_newEventNo_233", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:lockDoor"})
    public ZKResultMsg lockDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("lockDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_newEventNo_234", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:unLockDoor"})
    public ZKResultMsg unLockDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("unLockDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_11", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:enableNormalOpenDoor"})
    public ZKResultMsg enableNormalOpenDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("enableNormalOpenDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }

    @LogRequest(module="acc_module", object="acc_leftMenu_level", opType="acc_eventNo_10", requestParams={"names"}, opContent="common_level_name")
    @RequiresPermissions(value={"acc:level:disableNormalOpenDoor"})
    public ZKResultMsg disableNormalOpenDoor(String ids) {
        Map dataMap = this.accLevelService.operateDoor("disableNormalOpenDoor", null, ids, this.request.getSession().getId());
        if (dataMap.size() > 1) {
            return this.accLevelService.dealResultData(dataMap);
        }
        return new ZKResultMsg();
    }
}

