/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.constants.AccConstants;
import com.zkteco.zkbiosecurity.acc.remote.AccExtDeviceRemote;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccExtDeviceService;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceSelectItem;
import com.zkteco.zkbiosecurity.acc.vo.AccExtDeviceItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccExtDeviceController
extends BaseController
implements AccExtDeviceRemote {
    @Autowired
    private AccExtDeviceService accExtDeviceService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;

    public ModelAndView index() {
        return new ModelAndView("acc/extDevice/accExtDevice");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccExtDeviceItem item = this.accExtDeviceService.getItemById(id);
            if (item.getDevProtocolType() == null) {
                item.setDevProtocolType(Short.valueOf((short)1));
            }
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("acc/extDevice/editAccExtDevice");
    }

    public ZKResultMsg save(AccExtDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (101 == item.getExtBoardType()) {
            this.accExtDeviceService.setDM10(item);
        } else if (103 == item.getExtBoardType()) {
            this.accExtDeviceService.setAUX485(item);
        } else if (104 == item.getExtBoardType()) {
            this.accExtDeviceService.setEX0808(item);
        }
        return res;
    }

    public DxGrid list(AccExtDeviceItem codition) {
        Pager pager = this.accExtDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg del(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        this.accExtDeviceService.deleteByIds(ids);
        return res;
    }

    public DxGrid selectDeviceList(AccDeviceSelectItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        pager.setData(new ArrayList());
        if (condition.getType().equals("noSelected")) {
            String filterIds = condition.getSelectId();
            List accDeviceItems = this.accDeviceService.getByCondition(new AccDeviceItem());
            for (AccDeviceItem accDeviceItem : accDeviceItems) {
                if (this.isSupportExtBoardFun(accDeviceItem.getSn())) continue;
                if (StringUtils.isBlank((CharSequence)filterIds)) {
                    filterIds = accDeviceItem.getId();
                    continue;
                }
                filterIds = filterIds + "," + accDeviceItem.getId();
            }
            condition.setNotInId(filterIds);
            pager = this.accDeviceService.getDeviceSelectItem(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    private boolean isSupportExtBoardFun(String sn) {
        return this.accDeviceOptionService.isSupportFunList(sn, 45) || this.accDeviceOptionService.isSupportFunList(sn, 46) || this.accDeviceOptionService.isSupportFunList(sn, 47);
    }

    public ZKResultMsg getExtBoardTypeSelect(String devId) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 45)) {
            selectItem = new SelectItem();
            selectItem.setValue("101");
            selectItem.setText((Object)"DM10");
            selectItems.add(selectItem);
        }
        if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 46)) {
            selectItem = new SelectItem();
            selectItem.setValue("103");
            selectItem.setText((Object)"AUX485");
            selectItems.add(selectItem);
        }
        if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 47)) {
            selectItem = new SelectItem();
            selectItem.setValue("104");
            selectItem.setText((Object)"EX0808");
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public boolean isExistAlias(String alias) {
        return this.accExtDeviceService.isExistAlias(alias);
    }

    public boolean isExistAddress(Short commAddress, String devId) {
        return this.accExtDeviceService.isExistAddress(commAddress, devId);
    }

    public ZKResultMsg getDevProtocolTypeSelect(String devId) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            SelectItem selectItem = null;
            Short selectedType = this.accExtDeviceService.getDevProtocolType(devId);
            if (selectedType != null && AccConstants.EXT_PROTOCOL_TYPE.containsKey(selectedType)) {
                selectItem = new SelectItem();
                selectItem.setValue(selectedType + "");
                selectItem.setText(AccConstants.EXT_PROTOCOL_TYPE.get(selectedType));
                selectItems.add(selectItem);
                return new ZKResultMsg(selectItems);
            }
            if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 49)) {
                selectItem = new SelectItem();
                selectItem.setValue(AccConstants.EXT_PROTOCOL_TYPE_OSDP + "");
                selectItem.setText((Object)"OSDP");
                selectItems.add(selectItem);
            }
            selectItem = new SelectItem();
            selectItem.setValue(AccConstants.EXT_PROTOCOL_TYPE_ZK485 + "");
            selectItem.setText((Object)"ZK485");
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getExtBoardTypeSelects(String devId, String devProtocolType) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)devProtocolType)) {
            SelectItem selectItem = null;
            if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 45) && AccConstants.EXT_PROTOCOL_TYPE_ZK485.toString().equals(devProtocolType)) {
                selectItem = new SelectItem();
                selectItem.setValue("101");
                selectItem.setText((Object)"DM10");
                selectItems.add(selectItem);
            }
            if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 46) && AccConstants.EXT_PROTOCOL_TYPE_ZK485.toString().equals(devProtocolType)) {
                selectItem = new SelectItem();
                selectItem.setValue("103");
                selectItem.setText((Object)"AUX485");
                selectItems.add(selectItem);
            }
            if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 47)) {
                selectItem = new SelectItem();
                selectItem.setValue("104");
                selectItem.setText((Object)"EX0808");
                selectItems.add(selectItem);
            }
        }
        return new ZKResultMsg(selectItems);
    }
}

