/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccCombOpenDoorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccCombOpenDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.vo.AccCombOpenDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccCombOpenSelectDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccCombOpenDoorController
extends BaseController
implements AccCombOpenDoorRemote {
    @Autowired
    private AccCombOpenDoorService accCombOpenDoorService;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccDoorService accDoorService;

    @RequiresPermissions(value={"acc:combOpenDoor"})
    public ModelAndView index() {
        return new ModelAndView("acc/combOpenDoor/accCombOpenDoor");
    }

    @RequiresPermissions(value={"acc:combOpenDoor:add", "acc:combOpenDoor:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accCombOpenDoorService.getItemById(id));
            List accCombOpenCombItemList = this.accCombOpenDoorService.getAccCombOpenCombList(id);
            this.request.setAttribute("tempList", (Object)accCombOpenCombItemList);
        }
        return new ModelAndView("acc/combOpenDoor/editAccCombOpenDoor");
    }

    @RequiresPermissions(value={"acc:combOpenDoor:add", "acc:combOpenDoor:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_combOpen", opType="common_op_edit", requestParams={"name"}, opContent="acc_combOpen_comboName")
    public ZKResultMsg save(AccCombOpenDoorItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String[] groupIds = this.request.getParameterValues("groupId");
        String[] openerNumbers = this.request.getParameterValues("openerNumber");
        String[] sorts = this.request.getParameterValues("sort");
        ArrayList<String> groupList = new ArrayList<String>();
        for (String groupId : groupIds) {
            if (!StringUtils.isNotBlank((CharSequence)groupId)) continue;
            groupList.add(groupId);
        }
        groupIds = groupList.toArray(new String[5]);
        this.accCombOpenDoorService.saveItem(item, groupIds, sorts, openerNumbers);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:combOpenDoor:refresh"})
    public DxGrid list(AccCombOpenDoorItem codition) {
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.accCombOpenDoorService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List accCombOpenDoorItemList = pager.getData();
        accCombOpenDoorItemList.forEach(accCombOpenDoorItem -> {
            accCombOpenDoorItem.setVerifyOneTime(String.valueOf(this.accCombOpenDoorService.getCombOpenPersonByGroup(accCombOpenDoorItem.getId())));
            accCombOpenDoorItem.setCombOpenPersonId(this.accCombOpenDoorService.getCombOpenComb(accCombOpenDoorItem.getId()));
        });
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:combOpenDoor:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_combOpen", opType="common_op_del", requestParams={"names"}, opContent="acc_combOpen_comboName")
    public ZKResultMsg del(String ids) {
        this.accCombOpenDoorService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        AccCombOpenDoorItem item = this.accCombOpenDoorService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg validBackgroundVerify(String doorId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        boolean backgroundVerifyFlag = true;
        backgroundVerifyFlag = this.accCombOpenDoorService.validBackgroundVerify(doorId);
        zkResultMsg.setData((Object)backgroundVerifyFlag);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectDoorlist(AccCombOpenSelectDoorItem codition) {
        List doorIdList = this.accDoorService.getDoorIdAsReader();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (doorIdList != null && doorIdList.size() > 0) {
                codition.setSelectId(codition.getSelectId() + "," + StringUtils.join((Iterable)doorIdList, (String)","));
            }
            codition.setSelectDoorIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDoorIdsIn(codition.getSelectId());
        }
        String authAreaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        codition.setEnabled(Boolean.valueOf(true));
        Pager pager = this.accCombOpenDoorService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

