/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import sun.font.CoreMetrics;
import sun.font.FontLineMetrics;
import sun.font.TextSource;

final class StandardTextSource
extends TextSource {
    private final char[] chars;
    private final int start;
    private final int len;
    private final int cstart;
    private final int clen;
    private final int level;
    private final int flags;
    private final Font font;
    private final FontRenderContext frc;
    private final CoreMetrics cm;

    StandardTextSource(char[] chars, int start, int len, int cstart, int clen, int level, int flags, Font font, FontRenderContext frc, CoreMetrics cm) {
        if (chars == null) {
            throw new IllegalArgumentException("bad chars: null");
        }
        if (cstart < 0) {
            throw new IllegalArgumentException("bad cstart: " + cstart);
        }
        if (start < cstart) {
            throw new IllegalArgumentException("bad start: " + start + " for cstart: " + cstart);
        }
        if (clen < 0) {
            throw new IllegalArgumentException("bad clen: " + clen);
        }
        if (cstart + clen > chars.length) {
            throw new IllegalArgumentException("bad clen: " + clen + " cstart: " + cstart + " for array len: " + chars.length);
        }
        if (len < 0) {
            throw new IllegalArgumentException("bad len: " + len);
        }
        if (start + len > cstart + clen) {
            throw new IllegalArgumentException("bad len: " + len + " start: " + start + " for cstart: " + cstart + " clen: " + clen);
        }
        if (font == null) {
            throw new IllegalArgumentException("bad font: null");
        }
        if (frc == null) {
            throw new IllegalArgumentException("bad frc: null");
        }
        this.chars = chars;
        this.start = start;
        this.len = len;
        this.cstart = cstart;
        this.clen = clen;
        this.level = level;
        this.flags = flags;
        this.font = font;
        this.frc = frc;
        if (cm != null) {
            this.cm = cm;
        } else {
            LineMetrics metrics = font.getLineMetrics(chars, cstart, clen, frc);
            this.cm = ((FontLineMetrics)metrics).cm;
        }
    }

    @Override
    public char[] getChars() {
        return this.chars;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLength() {
        return this.len;
    }

    @Override
    public int getContextStart() {
        return this.cstart;
    }

    @Override
    public int getContextLength() {
        return this.clen;
    }

    @Override
    public int getLayoutFlags() {
        return this.flags;
    }

    @Override
    public int getBidiLevel() {
        return this.level;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontRenderContext getFRC() {
        return this.frc;
    }

    @Override
    public CoreMetrics getCoreMetrics() {
        return this.cm;
    }

    @Override
    public TextSource getSubSource(int start, int length, int dir) {
        if (start < 0 || length < 0 || start + length > this.len) {
            throw new IllegalArgumentException("bad start (" + start + ") or length (" + length + ")");
        }
        int level = this.level;
        if (dir != 2) {
            boolean ltr;
            boolean bl = ltr = (this.flags & 8) == 0;
            if (!(dir == 0 && ltr || dir == 1 && !ltr)) {
                throw new IllegalArgumentException("direction flag is invalid");
            }
            level = ltr ? 0 : 1;
        }
        return new StandardTextSource(this.chars, this.start + start, length, this.cstart, this.clen, level, this.flags, this.font, this.frc, this.cm);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean withContext) {
        int chLimit;
        int chStart;
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("[start:");
        buf.append(this.start);
        buf.append(", len:");
        buf.append(this.len);
        buf.append(", cstart:");
        buf.append(this.cstart);
        buf.append(", clen:");
        buf.append(this.clen);
        buf.append(", chars:\"");
        if (withContext) {
            chStart = this.cstart;
            chLimit = this.cstart + this.clen;
        } else {
            chStart = this.start;
            chLimit = this.start + this.len;
        }
        for (int i = chStart; i < chLimit; ++i) {
            if (i > chStart) {
                buf.append(" ");
            }
            buf.append(Integer.toHexString(this.chars[i]));
        }
        buf.append("\"");
        buf.append(", level:");
        buf.append(this.level);
        buf.append(", flags:");
        buf.append(this.flags);
        buf.append(", font:");
        buf.append(this.font);
        buf.append(", frc:");
        buf.append(this.frc);
        buf.append(", cm:");
        buf.append(this.cm);
        buf.append("]");
        return buf.toString();
    }
}

