/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarOutputStream
extends ZipOutputStream {
    private static final int JAR_MAGIC = 51966;
    private boolean firstEntry = true;

    public JarOutputStream(OutputStream out, Manifest man) throws IOException {
        super(out);
        if (man == null) {
            throw new NullPointerException("man");
        }
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(e);
        man.write(new BufferedOutputStream(this));
        this.closeEntry();
    }

    public JarOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    @Override
    public void putNextEntry(ZipEntry ze) throws IOException {
        if (this.firstEntry) {
            byte[] edata = ze.getExtra();
            if (edata == null || !JarOutputStream.hasMagic(edata)) {
                if (edata == null) {
                    edata = new byte[4];
                } else {
                    byte[] tmp = new byte[edata.length + 4];
                    System.arraycopy(edata, 0, tmp, 4, edata.length);
                    edata = tmp;
                }
                JarOutputStream.set16(edata, 0, 51966);
                JarOutputStream.set16(edata, 2, 0);
                ze.setExtra(edata);
            }
            this.firstEntry = false;
        }
        super.putNextEntry(ze);
    }

    private static boolean hasMagic(byte[] edata) {
        try {
            for (int i = 0; i < edata.length; i += JarOutputStream.get16(edata, i + 2) + 4) {
                if (JarOutputStream.get16(edata, i) != 51966) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int get16(byte[] b, int off) {
        return Byte.toUnsignedInt(b[off]) | Byte.toUnsignedInt(b[off + 1]) << 8;
    }

    private static void set16(byte[] b, int off, int value) {
        b[off + 0] = (byte)value;
        b[off + 1] = (byte)(value >> 8);
    }
}

