/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;

final class Histogram {
    protected final int[][] matrix;
    protected final int totalWeight;
    protected final int[] values;
    protected final int[] counts;
    private static final long LOW32 = 0xFFFFFFFFL;
    private static double log2 = Math.log(2.0);
    private final BitMetric bitMetric = new BitMetric(){

        @Override
        public double getBitLength(int value) {
            return Histogram.this.getBitLength(value);
        }
    };

    public Histogram(int[] valueSequence) {
        long[] hist2col = Histogram.computeHistogram2Col(Histogram.maybeSort(valueSequence));
        int[][] table = Histogram.makeTable(hist2col);
        this.values = table[0];
        this.counts = table[1];
        this.matrix = Histogram.makeMatrix(hist2col);
        this.totalWeight = valueSequence.length;
        assert (this.assertWellFormed(valueSequence));
    }

    public Histogram(int[] valueSequence, int start, int end) {
        this(Histogram.sortedSlice(valueSequence, start, end));
    }

    public Histogram(int[][] matrix) {
        matrix = this.normalizeMatrix(matrix);
        this.matrix = matrix;
        int length = 0;
        int weight = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int rowLength = matrix[i].length - 1;
            length += rowLength;
            weight += matrix[i][0] * rowLength;
        }
        this.totalWeight = weight;
        long[] hist2col = new long[length];
        int fillp = 0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 1; j < matrix[i].length; ++j) {
                hist2col[fillp++] = (long)matrix[i][j] << 32 | 0xFFFFFFFFL & (long)matrix[i][0];
            }
        }
        assert (fillp == hist2col.length);
        Arrays.sort(hist2col);
        int[][] table = Histogram.makeTable(hist2col);
        this.values = table[1];
        this.counts = table[0];
        assert (this.assertWellFormed(null));
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getRowCount() {
        return this.matrix.length;
    }

    public int getRowFrequency(int rn) {
        return this.matrix[rn][0];
    }

    public int getRowLength(int rn) {
        return this.matrix[rn].length - 1;
    }

    public int getRowValue(int rn, int vn) {
        return this.matrix[rn][vn + 1];
    }

    public int getRowWeight(int rn) {
        return this.getRowFrequency(rn) * this.getRowLength(rn);
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalLength() {
        return this.values.length;
    }

    public int[] getAllValues() {
        return this.values;
    }

    public int[] getAllFrequencies() {
        return this.counts;
    }

    public int getFrequency(int value) {
        int pos = Arrays.binarySearch(this.values, value);
        if (pos < 0) {
            return 0;
        }
        assert (this.values[pos] == value);
        return this.counts[pos];
    }

    public double getBitLength(int value) {
        double prob = (double)this.getFrequency(value) / (double)this.getTotalWeight();
        return -Math.log(prob) / log2;
    }

    public double getRowBitLength(int rn) {
        double prob = (double)this.getRowFrequency(rn) / (double)this.getTotalWeight();
        return -Math.log(prob) / log2;
    }

    public BitMetric getBitMetric() {
        return this.bitMetric;
    }

    public double getBitLength() {
        double sum = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            sum += this.getRowBitLength(i) * (double)this.getRowWeight(i);
        }
        assert (0.1 > Math.abs(sum - this.getBitLength(this.bitMetric)));
        return sum;
    }

    public double getBitLength(BitMetric len) {
        double sum = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 1; j < this.matrix[i].length; ++j) {
                sum += (double)this.matrix[i][0] * len.getBitLength(this.matrix[i][j]);
            }
        }
        return sum;
    }

    private static double round(double x, double scale) {
        return (double)Math.round(x * scale) / scale;
    }

    public int[][] normalizeMatrix(int[][] matrix) {
        long[] rowMap = new long[((int[][])matrix).length];
        for (int i = 0; i < ((int[][])matrix).length; ++i) {
            int count;
            if (matrix[i].length <= 1 || (count = matrix[i][0]) <= 0) continue;
            rowMap[i] = (long)count << 32 | (long)i;
        }
        Arrays.sort(rowMap);
        int[][] newMatrix = new int[((int[][])matrix).length][];
        int prevCount = -1;
        int fillp1 = 0;
        int fillp2 = 0;
        int i = 0;
        while (true) {
            block14: {
                int[] row;
                block15: {
                    block13: {
                        if (i >= ((int[][])matrix).length) break block13;
                        long rowMapEntry = rowMap[rowMap.length - i - 1];
                        if (rowMapEntry == 0L) break block14;
                        row = matrix[(int)rowMapEntry];
                        assert (rowMapEntry >>> 32 == (long)row[0]);
                        break block15;
                    }
                    row = new int[]{-1};
                }
                if (row[0] != prevCount && fillp2 > fillp1) {
                    int length = 0;
                    for (int p = fillp1; p < fillp2; ++p) {
                        int[] row0 = newMatrix[p];
                        assert (row0[0] == prevCount);
                        length += row0.length - 1;
                    }
                    int[] row1 = new int[1 + length];
                    row1[0] = prevCount;
                    int rfillp = 1;
                    for (int p = fillp1; p < fillp2; ++p) {
                        int[] row0 = newMatrix[p];
                        assert (row0[0] == prevCount);
                        System.arraycopy(row0, 1, row1, rfillp, row0.length - 1);
                        rfillp += row0.length - 1;
                    }
                    if (!Histogram.isSorted(row1, 1, true)) {
                        Arrays.sort(row1, 1, row1.length);
                        int jfillp = 2;
                        for (int j = 2; j < row1.length; ++j) {
                            if (row1[j] == row1[j - 1]) continue;
                            row1[jfillp++] = row1[j];
                        }
                        if (jfillp < row1.length) {
                            int[] newRow1 = new int[jfillp];
                            System.arraycopy(row1, 0, newRow1, 0, jfillp);
                            row1 = newRow1;
                        }
                    }
                    newMatrix[fillp1++] = row1;
                    fillp2 = fillp1;
                }
                if (i == ((int[][])matrix).length) break;
                prevCount = row[0];
                newMatrix[fillp2++] = row;
            }
            ++i;
        }
        assert (fillp1 == fillp2);
        matrix = newMatrix;
        if (fillp1 < ((int[][])matrix).length) {
            newMatrix = new int[fillp1][];
            System.arraycopy(matrix, 0, newMatrix, 0, fillp1);
            matrix = newMatrix;
        }
        return matrix;
    }

    public String[] getRowTitles(String name) {
        int totalUnique = this.getTotalLength();
        int ltotalWeight = this.getTotalWeight();
        String[] histTitles = new String[this.matrix.length];
        int cumWeight = 0;
        int cumUnique = 0;
        for (int i = 0; i < this.matrix.length; ++i) {
            int count = this.getRowFrequency(i);
            int unique = this.getRowLength(i);
            int weight = this.getRowWeight(i);
            long wpct = ((long)(cumWeight += weight) * 100L + (long)(ltotalWeight / 2)) / (long)ltotalWeight;
            long upct = ((long)(cumUnique += unique) * 100L + (long)(totalUnique / 2)) / (long)totalUnique;
            double len = this.getRowBitLength(i);
            assert (0.1 > Math.abs(len - this.getBitLength(this.matrix[i][1])));
            histTitles[i] = name + "[" + i + "] len=" + Histogram.round(len, 10.0) + " (" + count + "*[" + unique + "]) (" + cumWeight + ":" + wpct + "%) [" + cumUnique + ":" + upct + "%]";
        }
        return histTitles;
    }

    public void print(PrintStream out) {
        this.print("hist", out);
    }

    public void print(String name, PrintStream out) {
        this.print(name, this.getRowTitles(name), out);
    }

    public void print(String name, String[] histTitles, PrintStream out) {
        int totalUnique = this.getTotalLength();
        int ltotalWeight = this.getTotalWeight();
        double tlen = this.getBitLength();
        double avgLen = tlen / (double)ltotalWeight;
        double avg = (double)ltotalWeight / (double)totalUnique;
        String title = name + " len=" + Histogram.round(tlen, 10.0) + " avgLen=" + Histogram.round(avgLen, 10.0) + " weight(" + ltotalWeight + ") unique[" + totalUnique + "] avgWeight(" + Histogram.round(avg, 100.0) + ")";
        if (histTitles == null) {
            out.println(title);
        } else {
            out.println(title + " {");
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.matrix.length; ++i) {
                buf.setLength(0);
                buf.append("  ").append(histTitles[i]).append(" {");
                for (int j = 1; j < this.matrix[i].length; ++j) {
                    buf.append(" ").append(this.matrix[i][j]);
                }
                buf.append(" }");
                out.println(buf);
            }
            out.println("}");
        }
    }

    private static int[][] makeMatrix(long[] hist2col) {
        Arrays.sort(hist2col);
        int[] counts = new int[hist2col.length];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = (int)(hist2col[i] >>> 32);
        }
        long[] countHist = Histogram.computeHistogram2Col(counts);
        int[][] matrix = new int[countHist.length][];
        int histp = 0;
        int countp = 0;
        int i = matrix.length;
        while (--i >= 0) {
            long countAndRep = countHist[countp++];
            int count = (int)countAndRep;
            int repeat = (int)(countAndRep >>> 32);
            int[] row = new int[1 + repeat];
            row[0] = count;
            for (int j = 0; j < repeat; ++j) {
                long countAndValue = hist2col[histp++];
                assert (countAndValue >>> 32 == (long)count);
                row[1 + j] = (int)countAndValue;
            }
            matrix[i] = row;
        }
        assert (histp == hist2col.length);
        return matrix;
    }

    private static int[][] makeTable(long[] hist2col) {
        int[][] table = new int[2][hist2col.length];
        for (int i = 0; i < hist2col.length; ++i) {
            table[0][i] = (int)hist2col[i];
            table[1][i] = (int)(hist2col[i] >>> 32);
        }
        return table;
    }

    private static long[] computeHistogram2Col(int[] sortedValues) {
        switch (sortedValues.length) {
            case 0: {
                return new long[0];
            }
            case 1: {
                return new long[]{0x100000000L | 0xFFFFFFFFL & (long)sortedValues[0]};
            }
        }
        long[] hist = null;
        boolean sizeOnly = true;
        while (true) {
            int prevIndex = -1;
            int prevValue = ~sortedValues[0];
            int prevCount = 0;
            for (int i = 0; i <= sortedValues.length; ++i) {
                int thisValue = i < sortedValues.length ? sortedValues[i] : ~prevValue;
                if (thisValue == prevValue) {
                    ++prevCount;
                    continue;
                }
                if (!sizeOnly && prevCount != 0) {
                    hist[prevIndex] = (long)prevCount << 32 | 0xFFFFFFFFL & (long)prevValue;
                }
                prevValue = thisValue;
                prevCount = 1;
                ++prevIndex;
            }
            if (!sizeOnly) break;
            hist = new long[prevIndex];
            sizeOnly = false;
        }
        return hist;
    }

    private static int[][] regroupHistogram(int[][] matrix, int[] groups) {
        long oldEntries = 0L;
        for (int i = 0; i < matrix.length; ++i) {
            oldEntries += (long)(matrix[i].length - 1);
        }
        long newEntries = 0L;
        for (int ni = 0; ni < groups.length; ++ni) {
            newEntries += (long)groups[ni];
        }
        if (newEntries > oldEntries) {
            int newlen = groups.length;
            long ok = oldEntries;
            for (int ni = 0; ni < groups.length; ++ni) {
                if (ok < (long)groups[ni]) {
                    int[] newGroups = new int[ni + 1];
                    System.arraycopy(groups, 0, newGroups, 0, ni + 1);
                    groups = newGroups;
                    groups[ni] = (int)ok;
                    ok = 0L;
                    break;
                }
                ok -= (long)groups[ni];
            }
        } else {
            long excess = oldEntries - newEntries;
            int[] newGroups = new int[groups.length + 1];
            System.arraycopy(groups, 0, newGroups, 0, groups.length);
            newGroups[groups.length] = (int)excess;
            groups = newGroups;
        }
        int[][] newMatrix = new int[groups.length][];
        int i = 0;
        int jMin = 1;
        int jMax = matrix[i].length;
        for (int ni = 0; ni < groups.length; ++ni) {
            int len;
            int groupLength = groups[ni];
            int[] group = new int[1 + groupLength];
            long groupWeight = 0L;
            newMatrix[ni] = group;
            for (int njFill = 1; njFill < group.length; njFill += len) {
                len = group.length - njFill;
                while (jMin == jMax) {
                    jMin = 1;
                    jMax = matrix[++i].length;
                }
                if (len > jMax - jMin) {
                    len = jMax - jMin;
                }
                groupWeight += (long)matrix[i][0] * (long)len;
                System.arraycopy(matrix[i], jMax - len, group, njFill, len);
                jMax -= len;
            }
            Arrays.sort(group, 1, group.length);
            group[0] = (int)((groupWeight + (long)(groupLength / 2)) / (long)groupLength);
        }
        assert (jMin == jMax);
        assert (i == matrix.length - 1);
        return newMatrix;
    }

    public static Histogram makeByteHistogram(InputStream bytes) throws IOException {
        int i;
        int nr;
        byte[] buf = new byte[4096];
        int[] tally = new int[256];
        while ((nr = bytes.read(buf)) > 0) {
            for (i = 0; i < nr; ++i) {
                int n = buf[i] & 0xFF;
                tally[n] = tally[n] + 1;
            }
        }
        int[][] matrix = new int[256][2];
        for (i = 0; i < tally.length; ++i) {
            matrix[i][0] = tally[i];
            matrix[i][1] = i;
        }
        return new Histogram(matrix);
    }

    private static int[] sortedSlice(int[] valueSequence, int start, int end) {
        if (start == 0 && end == valueSequence.length && Histogram.isSorted(valueSequence, 0, false)) {
            return valueSequence;
        }
        int[] slice = new int[end - start];
        System.arraycopy(valueSequence, start, slice, 0, slice.length);
        Arrays.sort(slice);
        return slice;
    }

    private static boolean isSorted(int[] values, int from, boolean strict) {
        for (int i = from + 1; i < values.length; ++i) {
            if (!(strict ? values[i - 1] >= values[i] : values[i - 1] > values[i])) continue;
            return false;
        }
        return true;
    }

    private static int[] maybeSort(int[] values) {
        if (!Histogram.isSorted(values, 0, false)) {
            values = (int[])values.clone();
            Arrays.sort(values);
        }
        return values;
    }

    private boolean assertWellFormed(int[] valueSequence) {
        return true;
    }

    public static interface BitMetric {
        public double getBitLength(int var1);
    }
}

