/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class MarkerSegment
implements Cloneable {
    protected static final int LENGTH_SIZE = 2;
    int tag;
    int length;
    byte[] data = null;
    boolean unknown = false;

    MarkerSegment(JPEGBuffer buffer) throws IOException {
        buffer.loadBuf(3);
        this.tag = buffer.buf[buffer.bufPtr++] & 0xFF;
        this.length = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.length |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.length -= 2;
        if (this.length < 0) {
            throw new IIOException("Invalid segment length: " + this.length);
        }
        buffer.bufAvail -= 3;
        buffer.loadBuf(this.length);
    }

    MarkerSegment(int tag) {
        this.tag = tag;
        this.length = 0;
    }

    MarkerSegment(Node node) throws IIOInvalidTreeException {
        this.tag = MarkerSegment.getAttributeValue(node, null, "MarkerTag", 0, 255, true);
        this.length = 0;
        if (node instanceof IIOMetadataNode) {
            IIOMetadataNode iioNode = (IIOMetadataNode)node;
            try {
                this.data = (byte[])iioNode.getUserObject();
            }
            catch (Exception e) {
                IIOInvalidTreeException newGuy = new IIOInvalidTreeException("Can't get User Object", node);
                newGuy.initCause(e);
                throw newGuy;
            }
        } else {
            throw new IIOInvalidTreeException("Node must have User Object", node);
        }
    }

    protected Object clone() {
        MarkerSegment newGuy = null;
        try {
            newGuy = (MarkerSegment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.data != null) {
            newGuy.data = (byte[])this.data.clone();
        }
        return newGuy;
    }

    void loadData(JPEGBuffer buffer) throws IOException {
        this.data = new byte[this.length];
        buffer.readData(this.data);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("unknown");
        node.setAttribute("MarkerTag", Integer.toString(this.tag));
        node.setUserObject(this.data);
        return node;
    }

    static int getAttributeValue(Node node, NamedNodeMap attrs, String name, int min, int max, boolean required) throws IIOInvalidTreeException {
        if (attrs == null) {
            attrs = node.getAttributes();
        }
        String valueString = attrs.getNamedItem(name).getNodeValue();
        int value = -1;
        if (valueString == null) {
            if (required) {
                throw new IIOInvalidTreeException(name + " attribute not found", node);
            }
        } else {
            value = Integer.parseInt(valueString);
            if (value < min || value > max) {
                throw new IIOInvalidTreeException(name + " attribute out of range", node);
            }
        }
        return value;
    }

    void writeTag(ImageOutputStream ios) throws IOException {
        ios.write(255);
        ios.write(this.tag);
        MarkerSegment.write2bytes(ios, this.length);
    }

    void write(ImageOutputStream ios) throws IOException {
        this.length = 2 + (this.data != null ? this.data.length : 0);
        this.writeTag(ios);
        if (this.data != null) {
            ios.write(this.data);
        }
    }

    static void write2bytes(ImageOutputStream ios, int value) throws IOException {
        ios.write(value >> 8 & 0xFF);
        ios.write(value & 0xFF);
    }

    void printTag(String prefix) {
        System.out.println(prefix + " marker segment - marker = 0x" + Integer.toHexString(this.tag));
        System.out.println("length: " + this.length);
    }

    void print() {
        this.printTag("Unknown");
        if (this.length > 10) {
            int i;
            System.out.print("First 5 bytes:");
            for (i = 0; i < 5; ++i) {
                System.out.print(" Ox" + Integer.toHexString(this.data[i]));
            }
            System.out.print("\nLast 5 bytes:");
            for (i = this.data.length - 5; i < this.data.length; ++i) {
                System.out.print(" Ox" + Integer.toHexString(this.data[i]));
            }
        } else {
            System.out.print("Data:");
            for (int i = 0; i < this.data.length; ++i) {
                System.out.print(" Ox" + Integer.toHexString(this.data[i]));
            }
        }
        System.out.println();
    }
}

