/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.util;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.util.SicmConstUtil;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SicmDeviceDataUtil {
    private StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean((String)"stringRedisTemplate");
    private SisDeviceService sisDeviceService = (SisDeviceService)SpringUtil.getBean(SisDeviceService.class);

    public static boolean updateDevice(JSONObject dataJson, SisDeviceItem oldDevice) {
        boolean flag = false;
        if (dataJson.containsKey((Object)"model") && StringUtils.isNotBlank((CharSequence)dataJson.getString("model"))) {
            oldDevice.setModel(dataJson.getString("model"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"device_state") && StringUtils.isNotBlank((CharSequence)dataJson.getString("device_state"))) {
            oldDevice.setDeviceState(dataJson.getInteger("device_state"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"nvr_sn") && StringUtils.isNotBlank((CharSequence)dataJson.getString("nvr_sn"))) {
            oldDevice.setNvrSn(dataJson.getString("nvr_sn"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"mask") && StringUtils.isNotBlank((CharSequence)dataJson.getString("mask"))) {
            oldDevice.setModel(dataJson.getString("mask"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"gate") && StringUtils.isNotBlank((CharSequence)dataJson.getString("gate"))) {
            oldDevice.setGate(dataJson.getString("gate"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"ip_address") && StringUtils.isNotBlank((CharSequence)dataJson.getString("ip_address"))) {
            oldDevice.setIp(dataJson.getString("ip_address"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"version_soft") && StringUtils.isNotBlank((CharSequence)dataJson.getString("version_soft"))) {
            oldDevice.setVersionSoft(dataJson.getString("version_soft"));
            flag = true;
        }
        if (dataJson.containsKey((Object)"version_interface") && StringUtils.isNotBlank((CharSequence)dataJson.getString("version_interface"))) {
            oldDevice.setVersionPush(dataJson.getString("version_interface"));
            flag = true;
        }
        return flag;
    }

    public void updateDevState(String sn, short connState, String actionName, String actionNo) throws Exception {
        JSONObject devStateJson1 = new JSONObject();
        devStateJson1.put("connect", (Object)connState);
        this.stringRedisTemplate.opsForValue().set((Object)(SicmConstUtil.SIS_DEVICE_MONITOR + sn), (Object)devStateJson1.toJSONString());
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)String.valueOf(connState))) {
            this.delDevRedisState(sn);
        }
        this.sisDeviceService.setBoradDevStatusData(String.valueOf(connState));
        JSONObject devStateJson = new JSONObject();
        String devStateKey = "SIS_DEV_OPERATE_STATE_" + sn;
        devStateJson.put("actionName", (Object)actionName);
        devStateJson.put("actionNo", (Object)actionNo);
        devStateJson.put("cmdCount", (Object)0);
        this.stringRedisTemplate.opsForValue().set((Object)devStateKey, (Object)devStateJson.toJSONString());
    }

    public void delDevRedisState(String sn) {
        this.stringRedisTemplate.delete((Object)(SicmConstUtil.SIS_MACHINE_STATE_WORK_MODE + sn));
        this.stringRedisTemplate.delete((Object)(SicmConstUtil.SIS_DEV_REMOTE_CONTROL_STATE + sn));
        this.stringRedisTemplate.delete((Object)(SicmConstUtil.SIS_DEV_CONTROL_STATE + sn));
        this.stringRedisTemplate.delete((Object)(SicmConstUtil.SIS_DEV_MAINTAIN_STATE + sn));
        this.stringRedisTemplate.delete((Object)("SIS_DEV_OPERATE_STATE_" + sn));
        this.stringRedisTemplate.delete((Object)(SicmConstUtil.SIS_DEV_RAY_STATE + sn));
        this.stringRedisTemplate.delete((Object)(SicmConstUtil.SIS_MACHINE_STATE_WORK_MODE + sn));
    }
}

