/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.sis.distributor.SisGateDevCommServer;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.util.SicmIEDUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=112001)
public class SisIEDDevCommServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisGateDevCommServer.class);
    private final int maxLength = 256;
    private final int port = 4001;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SisDeviceService sisDeviceService;

    public void run(String ... strings) throws Exception {
        new SisIEDDeviceListenThread("IEDDeviceListenThread").start();
    }

    class SisIEDDeviceListenThread
    extends Thread {
        SisIEDDeviceListenThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30000L);
                SisIEDDevCommServer.this.logger.info((Object)">>>>>>>>SisIEDDeviceListenThread loading<<<<<<<<<");
                DatagramSocket ds = new DatagramSocket(4001);
                while (true) {
                    byte[] buf = new byte[256];
                    DatagramPacket dp_receive = new DatagramPacket(buf, buf.length);
                    ds.receive(dp_receive);
                    byte[] bArray = dp_receive.getData();
                    String ip = dp_receive.getAddress().getHostAddress();
                    if (bArray[1] == Byte.parseByte("-92")) {
                        String initData = SicmIEDUtil.init(bArray);
                        SisIEDDevCommServer.this.logger.info((Object)(DateUtil.getTime((Date)new Date()) + ":::::::" + initData));
                        if (StringUtils.isNotBlank((CharSequence)initData) && initData.startsWith("01a4")) {
                            String deviceId = SicmIEDUtil.reverseHex(initData.substring(24, 28));
                            JSONObject object = new JSONObject();
                            object.put("ip_address", (Object)ip);
                            object.put("sn", (Object)deviceId);
                            SisIEDDevCommServer.this.sisDeviceService.registryDevice(object);
                            SisIEDDevCommServer.this.stringRedisTemplate.opsForValue().set((Object)("SIS_IED_HEARBEAT_" + ip), (Object)"0", 80L, TimeUnit.SECONDS);
                            dp_receive.setData(SicmIEDUtil.initRet);
                        }
                    } else {
                        String data = new String(dp_receive.getData(), "UTF-8");
                        String receive = new String(data.getBytes(), 0, dp_receive.getLength()) + " from " + dp_receive.getAddress().getHostAddress() + ":" + dp_receive.getPort();
                        SisIEDDevCommServer.this.stringRedisTemplate.opsForList().rightPush((Object)"SIS_IED_RTLOG", (Object)(ip + ";" + receive));
                        SisIEDDevCommServer.this.stringRedisTemplate.opsForValue().set((Object)("SIS_IED_HEARBEAT_" + ip), (Object)"0", 80L, TimeUnit.SECONDS);
                        dp_receive.setData(SicmIEDUtil.uploadRet);
                    }
                    ds.send(dp_receive);
                }
            }
            catch (Exception e) {
                SisIEDDevCommServer.this.logger.error((Object)("SisIEDDeviceListenThread exception: " + e));
                return;
            }
        }
    }
}

