/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.google.common.primitives.Bytes;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisFluidTransactionService;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=111002)
public class SisFluidDevCommServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisFluidDevCommServer.class);
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisFluidTransactionService sisFluidTransactionService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    ServerSocket serverSocket = null;

    public void run(String ... args) throws Exception {
        new SicmFluidDeviceListenThread("FluidDeviceListenThread").start();
    }

    private void deviceZklLogin(String clientIp, List<Byte> mList) {
        String sum;
        String verify = Integer.toHexString(0xFF & mList.get(2) + mList.get(3) + mList.get(4) + mList.get(5) + mList.get(6) + mList.get(7) + mList.get(8));
        if (StringUtils.equals((CharSequence)verify, (CharSequence)(sum = Integer.toHexString(0xFF & mList.get(9))))) {
            if (mList.get(2) == 101) {
                this.stringRedisTemplate.opsForValue().set((Object)("SIS_ZK-LD5000_DEVICE_STATUS_TIME_" + clientIp), (Object)"0", 10L, TimeUnit.SECONDS);
                if (!this.stringRedisTemplate.hasKey((Object)("SIS_ZK-LD5000_DEVICE_STATUS_" + clientIp)).booleanValue()) {
                    this.stringRedisTemplate.opsForValue().set((Object)("SIS_ZK-LD5000_DEVICE_STATUS_" + clientIp), (Object)"0");
                    String sn = Integer.toHexString(0xFF & mList.get(3)) + Integer.toHexString(0xFF & mList.get(4)) + Integer.toHexString(0xFF & mList.get(5)) + Integer.toHexString(0xFF & mList.get(6)) + Integer.toHexString(0xFF & mList.get(7));
                    this.sisDeviceService.saveLd5000Device(clientIp, sn);
                }
            } else if (mList.get(2) == 102) {
                this.stringRedisTemplate.opsForValue().set((Object)("SIS_ZK-LD5000_DEVICE_STATUS_TIME_" + clientIp), (Object)"0", 5L, TimeUnit.SECONDS);
                this.sisFluidTransactionService.saveItem(clientIp, "error");
            } else if (mList.get(2) == 103) {
                this.stringRedisTemplate.opsForValue().set((Object)("SIS_ZK-LD5000_DEVICE_STATUS_TIME_" + clientIp), (Object)"0", 5L, TimeUnit.SECONDS);
                this.sisFluidTransactionService.saveItem(clientIp, "success");
            }
        }
    }

    class SicmFluidDeviceListenThread
    extends Thread {
        SicmFluidDeviceListenThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                SisFluidDevCommServer.this.logger.info((Object)"--------------------------SicmFluidDeviceListenThread loading---------------------------------");
                Thread.sleep(30000L);
                SisFluidDevCommServer.this.serverSocket = new ServerSocket(5000);
                Socket client = null;
                while (true) {
                    client = SisFluidDevCommServer.this.serverSocket.accept();
                    InetAddress address = client.getInetAddress();
                    String clientIp = address.getHostAddress();
                    InputStream is = client.getInputStream();
                    byte[] b = new byte[10];
                    is.read(b);
                    ArrayList mList = new ArrayList(Bytes.asList((byte[])b));
                    if ((Byte)mList.get(0) == 2 && (Byte)mList.get(1) == 8) {
                        SisFluidDevCommServer.this.deviceZklLogin(clientIp, mList);
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                SisFluidDevCommServer.this.logger.error((Object)("SisFluidDevCommServer exception: " + e));
                return;
            }
        }
    }
}

