/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient.protocol;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.enums.ParkViewEnum;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.Park485Protocol;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkCRC16Util;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.websocketService.Service.impl.ParkWebsocketServiceImpl;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkSendCmd {
    private static final Logger log = LoggerFactory.getLogger(ParkSendCmd.class);
    @Autowired
    private ParkWebsocketServiceImpl controllerHolderInit;
    @Autowired
    private Park485Protocol park485Protocol;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkParamsService parkParamsService;
    private final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private final String CN_NEGATIVE = "\u8d1f";
    private final int MONEY_PRECISION = 2;
    private final String CN_ZEOR_FULL = "\u96f6\u5143";
    public Map<String, Short> viewContentMap = new ConcurrentHashMap<String, Short>();
    public String[] voiceStr = new String[1];
    public String[] viewStr = new String[2];

    public byte[] protocolAssembly(int devAddr, int devType, int cnt, byte[] info) {
        byte[] msgBag = new byte[info.length + 9];
        msgBag[0] = -86;
        msgBag[1] = (byte)devAddr;
        msgBag[2] = 5;
        byte[] len = new byte[2];
        String lenStr = Integer.toHexString(info.length + 2);
        this.hexStringToByte(lenStr, len);
        msgBag[3] = len[1];
        msgBag[4] = len[0];
        msgBag[5] = (byte)cnt;
        msgBag[6] = (byte)devType;
        for (int i = 0; i < info.length; ++i) {
            msgBag[7 + i] = info[i];
        }
        byte[] temdata = new byte[info.length + 6];
        System.arraycopy(msgBag, 1, temdata, 0, info.length + 6);
        byte[] crc16R = new byte[2];
        String crcStr = ParkCRC16Util.crcTable(temdata, 0, temdata.length);
        this.hexStringToByte(crcStr, crc16R);
        msgBag[7 + info.length] = crc16R[1];
        msgBag[8 + info.length] = crc16R[0];
        return msgBag;
    }

    public String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private void hexStringToByte(String strHex, byte[] buf) {
        while (strHex.length() < 4) {
            strHex = "0" + strHex;
        }
        int nLen = strHex.length() / 2;
        for (int i = 0; i < nLen; ++i) {
            buf[i] = Integer.valueOf(strHex.substring(i * 2, i * 2 + 2), 16).byteValue();
        }
    }

    public String getAscllMoney(double money) {
        BigDecimal numberOfMoney = new BigDecimal(money);
        numberOfMoney = numberOfMoney.setScale(1, 4);
        String ascMoney = this.number2CNMontrayUnit(numberOfMoney);
        ascMoney = ascMoney.replace("\u4edf", "e");
        ascMoney = ascMoney.replace("\u4f70", "B");
        if ((ascMoney = ascMoney.replace("\u62fe", "A")).indexOf("\u89d2") > -1) {
            ascMoney = ascMoney.replace("\u5143", "C");
            ascMoney = ascMoney.replace("\u89d2", "E");
        } else {
            ascMoney = ascMoney.replace("\u5143", "E");
        }
        ascMoney = ascMoney.replace("\u7396", "9");
        ascMoney = ascMoney.replace("\u634c", "8");
        ascMoney = ascMoney.replace("\u67d2", "7");
        ascMoney = ascMoney.replace("\u9646", "6");
        ascMoney = ascMoney.replace("\u4f0d", "5");
        ascMoney = ascMoney.replace("\u8086", "4");
        ascMoney = ascMoney.replace("\u53c1", "3");
        ascMoney = ascMoney.replace("\u8d30", "2");
        ascMoney = ascMoney.replace("\u58f9", "1");
        ascMoney = ascMoney.replace("\u96f6", "0");
        return ascMoney;
    }

    public String number2CNMontrayUnit(BigDecimal numberOfMoney) {
        StringBuffer sb = new StringBuffer();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return "\u96f6\u5143";
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, this.CN_UPPER_NUMBER[numUnit]);
                zeroSize = 0;
            } else {
                if (numIndex > 2 && number > 0L && ++zeroSize == 1) {
                    sb.insert(0, this.CN_UPPER_NUMBER[0]);
                }
                if (numIndex == 2 && number > 0L) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[numIndex]);
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, "\u8d1f");
        }
        return sb.toString();
    }

    public void test(int d) {
        String[] str = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] ss = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf"};
        String s = String.valueOf(d);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            String index = String.valueOf(s.charAt(i));
            sb = sb.append(str[Integer.parseInt(index)]);
        }
        String sss = String.valueOf(sb);
        int i = 0;
        for (int j = sss.length(); j > 0; --j) {
            sb = sb.insert(j, ss[i++]);
        }
    }

    public void voiceInfo(String cont, String devIp) {
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            this.voiceStr[0] = cont;
            this.assembleMsg(this.voiceStr, devIp, 2);
        }
    }

    public void viewInfo(String content1, String content2, String devIp) {
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            this.viewStr[0] = content1;
            this.viewStr[1] = content2;
            long handle = this.getHandle(devIp);
            if (ParkWebCommonUtil.isNotNull(handle) && handle != 0L) {
                Timestamp nowTime = new Timestamp(System.currentTimeMillis());
                Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -30);
                String handleStr = "park:view_defa_content_" + handle;
                if (this.parkCacheService.exists(handleStr)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                    this.assembleMsg(this.viewStr, devIp, 1);
                }
            }
        }
    }

    private void assembleMsg(String[] ascIIStr, String devIp, int devType) {
        try {
            byte[] msgAry = ascIIStr[0].getBytes("GBK");
            if (ascIIStr.length > 1) {
                byte[] msg_F = ascIIStr[0].getBytes("GBK");
                byte[] msg_S = ascIIStr[1].getBytes("GBK");
                msgAry = new byte[msg_F.length + msg_S.length + 1];
                System.arraycopy(msg_F, 0, msgAry, 0, msg_F.length);
                msgAry[msg_F.length] = 10;
                System.arraycopy(msg_S, 0, msgAry, msg_F.length + 1, msg_S.length);
            }
            byte[] msg = this.protocolAssembly(0, devType, 1, msgAry);
            this.controllerHolderInit.sendMsg(devIp, msg, devType);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void viewDefaContent() {
        String devIpStr = this.parkCacheService.getStr("park:alldev_ip");
        if (ParkWebCommonUtil.isNotNull(devIpStr)) {
            String[] devIpAry;
            for (String devIp : devIpAry = devIpStr.split(",")) {
                String viewTimeRedis;
                JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
                if (ParkWebCommonUtil.isNull(devObj) || ParkWebCommonUtil.isNull(devObj.getString("channelId"))) continue;
                String state = devObj.getString("state");
                long handle = devObj.getLong("handle");
                if ("offLine".equals(state) || !ParkWebCommonUtil.isNotNull(viewTimeRedis = this.parkCacheService.getStr("park:view_defa_content_" + handle))) continue;
                String viewCode = this.parkParamsService.getViewCode();
                Long currentTimeMillis = System.currentTimeMillis();
                Long viewTime = Long.valueOf(viewTimeRedis);
                Long idleTimeInterval = Long.valueOf(this.parkParamsService.getIdleTimeInterval());
                if (currentTimeMillis < viewTime && (viewTime - currentTimeMillis) / 1000L > idleTimeInterval / 3L) continue;
                Short displayType = Short.valueOf(devObj.getString("displayType"));
                if (ParkConstants.LED_FOURCOLOR.equals(displayType)) {
                    String first = this.parkParamsService.getCompanyName();
                    String second = ParkViewEnum.getFormatTime((String)viewCode);
                    String third = "";
                    String fourth = "";
                    if ("true".equals(this.parkParamsService.isShowParkingLot())) {
                        third = ParkViewEnum.getViewContent((String)viewCode, (String)"remainPark");
                        fourth = this.getFreeParking(devObj.getString("parkingAreaId"));
                    } else {
                        third = I18nUtil.i18nCode((String)"park_device_autoRecognition", (Object[])new Object[0]);
                        fourth = I18nUtil.i18nCode((String)"park_device_slowDown", (Object[])new Object[0]);
                    }
                    Short channelStatus = Short.valueOf(devObj.getString("channelStatus"));
                    if (ParkConstants.CHANNEL_STATE_CART_OUT.equals(channelStatus) || ParkConstants.CHANNEL_STATE_CAR_OUT.equals(channelStatus) || ParkConstants.CHANNEL_STATE_CENT_EXPORT.equals(channelStatus)) {
                        third = I18nUtil.i18nCode((String)"park_device_autoRecognition", (Object[])new Object[0]);
                        fourth = I18nUtil.i18nCode((String)"park_device_slowDown", (Object[])new Object[0]);
                    }
                    this.park485Protocol.setRealTimeDisplay174For4Lines(first, second, third, fourth, devObj.getString("ipAddr"));
                    continue;
                }
                this.viewStr[0] = this.parkParamsService.getCompanyName();
                this.viewStr[1] = ParkViewEnum.getFormatTime((String)viewCode);
                Short channelStatus = Short.valueOf(devObj.getString("channelStatus"));
                String channelId = devObj.getString("channelId");
                if ("true".equals(this.parkParamsService.isShowParkingLot()) && (ParkConstants.CHANNEL_STATE_CART_IN.equals(channelStatus) || ParkConstants.CHANNEL_STATE_CAR_IN.equals(channelStatus))) {
                    Short viewContent = 0;
                    if (this.viewContentMap.containsKey(channelId)) {
                        viewContent = this.viewContentMap.get(channelId);
                    }
                    String freeParking = this.getFreeParking(devObj.getString("parkingAreaId"));
                    if (viewContent == 0 && !"0000".equals(freeParking)) {
                        viewContent = 1;
                    } else {
                        this.viewStr[0] = ParkViewEnum.getViewContent((String)viewCode, (String)"remainPark");
                        this.viewStr[1] = freeParking;
                        viewContent = 0;
                    }
                    this.viewContentMap.put(channelId, viewContent);
                }
                if (ParkConstants.LED_TWOCOLOR.equals(Short.valueOf(devObj.getString("displayType")))) {
                    this.park485Protocol.setRealTimeDisplay174(this.viewStr[0], this.viewStr[1], devObj.getString("ipAddr"));
                    continue;
                }
                this.assembleMsg(this.viewStr, devObj.getString("ipAddr"), 1);
            }
        }
    }

    private String getFreeParking(String parkingAreaId) {
        String parkLot;
        int freeParking = 0;
        if (this.parkCacheService.exists("park:areaid_" + parkingAreaId) && ParkWebCommonUtil.isNotNull(parkLot = this.parkCacheService.getStr("park:areaid_" + parkingAreaId)) && Integer.valueOf(parkLot) > 0) {
            freeParking = Integer.parseInt(parkLot);
        }
        return String.format("%04d", freeParking);
    }

    public long getHandle(String devIp) {
        long handle = 0L;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        handle = devObj.getLong("handle");
        return handle;
    }

    public static void main(String[] args) {
    }
}

