/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ELE_FIRSTIN_LASTOUT t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class EleFirstInLastOutItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", show=false)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="t.READER_NAME_IN")
    @GridColumn(label="ele_inOut_inReaderName", width="135")
    private String readerNameIn;
    @Column(name="t.FIRST_IN_TIME")
    @GridColumn(label="ele_inOut_firstInTime", width="135")
    private Date firstInTime;
    @Column(name="t.READER_NAME_OUT")
    @GridColumn(label="ele_inOut_outReaderName", width="135")
    private String readerNameOut;
    @Column(name="t.LAST_OUT_TIME")
    @GridColumn(label="ele_inOut_lastOutTime", width="135")
    private Date lastOutTime;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="pers_dept_deptNo", width="100")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="100")
    private String deptName;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.FIRST_IN_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.FIRST_IN_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="(t.DEPT_CODE in (%s) or t.DEPT_CODE is null or t.DEPT_CODE = '')", formatType="quote")
    private String deptCodeIn;

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getReaderNameIn() {
        return this.readerNameIn;
    }

    public Date getFirstInTime() {
        return this.firstInTime;
    }

    public String getReaderNameOut() {
        return this.readerNameOut;
    }

    public Date getLastOutTime() {
        return this.lastOutTime;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getDeptCodeIn() {
        return this.deptCodeIn;
    }

    public EleFirstInLastOutItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleFirstInLastOutItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public EleFirstInLastOutItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleFirstInLastOutItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public EleFirstInLastOutItem setReaderNameIn(String readerNameIn) {
        this.readerNameIn = readerNameIn;
        return this;
    }

    public EleFirstInLastOutItem setFirstInTime(Date firstInTime) {
        this.firstInTime = firstInTime;
        return this;
    }

    public EleFirstInLastOutItem setReaderNameOut(String readerNameOut) {
        this.readerNameOut = readerNameOut;
        return this;
    }

    public EleFirstInLastOutItem setLastOutTime(Date lastOutTime) {
        this.lastOutTime = lastOutTime;
        return this;
    }

    public EleFirstInLastOutItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public EleFirstInLastOutItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public EleFirstInLastOutItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public EleFirstInLastOutItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public EleFirstInLastOutItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public EleFirstInLastOutItem setDeptCodeIn(String deptCodeIn) {
        this.deptCodeIn = deptCodeIn;
        return this;
    }

    public String toString() {
        return "EleFirstInLastOutItem(id=" + this.getId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", readerNameIn=" + this.getReaderNameIn() + ", firstInTime=" + this.getFirstInTime() + ", readerNameOut=" + this.getReaderNameOut() + ", lastOutTime=" + this.getLastOutTime() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", likeName=" + this.getLikeName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", deptCodeIn=" + this.getDeptCodeIn() + ")";
    }
}

