/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.GridColumnItem;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.format.TreeFormat;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.DynamicColumn;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.ShowGridColumn;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.security.SecurityService;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class GridUtil {
    private static final Logger logger = LoggerFactory.getLogger(GridUtil.class);
    private static final String ZK_GRID_OP = "zkGridOp";

    public static JSONObject getGridHeader(String vo, String gridName) {
        Class<?> itemCls = null;
        try {
            itemCls = Class.forName(vo);
        }
        catch (ClassNotFoundException e) {
            logger.error("not find vo name=" + vo);
            return new JSONObject();
        }
        GridConfig gridConfig = itemCls.getAnnotation(GridConfig.class);
        String idField = gridConfig.idField();
        StringBuffer minWidthBuffer = new StringBuffer();
        StringBuffer columnTypes = new StringBuffer();
        JSONArray jsonArray = new JSONArray();
        JSONObject columnJsonObject = null;
        Field[] fieldArray = itemCls.getDeclaredFields();
        List<Field> fields = GridUtil.getSortFields(fieldArray, idField);
        GridColumn gridColumn = null;
        int size = fields.size();
        GridColumnItem gridColumnItem = null;
        GridColumnItem idGridColumnItem = null;
        ArrayList<GridColumnItem> columnItemList = new ArrayList<GridColumnItem>();
        for (int i = 0; i < size; ++i) {
            gridColumn = fields.get(i).getAnnotation(GridColumn.class);
            if (StringUtils.isNotBlank((CharSequence)gridColumn.dynamicColumn())) {
                DynamicColumn dc = (DynamicColumn)SpringContextUtil.getBean((String)gridColumn.dynamicColumn(), DynamicColumn.class);
                columnItemList.addAll(dc.getColumn(fields.get(i).getName()));
                continue;
            }
            gridColumnItem = new GridColumnItem(gridColumn);
            gridColumnItem.setFieldName(fields.get(i).getName());
            if ("id".equals(fields.get(i).getName())) {
                idGridColumnItem = gridColumnItem;
                continue;
            }
            columnItemList.add(gridColumnItem);
        }
        List column = columnItemList.stream().sorted((param1, param2) -> param1.getSortNo() < param2.getSortNo() ? -1 : 1).collect(Collectors.toList());
        column.add(0, idGridColumnItem);
        for (int j = 0; j < column.size(); ++j) {
            if (!GridUtil.showGridColumn((GridColumnItem)column.get(j))) continue;
            columnJsonObject = new JSONObject();
            if (((GridColumnItem)column.get(j)).isCheckbox()) {
                columnJsonObject.put("id", (Object)"checkbox");
                columnJsonObject.put("type", (Object)"ch");
                columnJsonObject.put("align", (Object)"center");
                columnJsonObject.put("sort", (Object)"na");
                columnTypes.append("ch,");
            } else {
                columnJsonObject.put("id", (Object)((GridColumnItem)column.get(j)).getFieldName());
                columnJsonObject.put("type", (Object)((GridColumnItem)column.get(j)).getColumnType());
                columnJsonObject.put("align", (Object)((GridColumnItem)column.get(j)).getAlign());
                columnTypes.append(((GridColumnItem)column.get(j)).getColumnType() + ",");
                if ("edit".equals(((GridColumnItem)column.get(j)).getColumnType()) || "treexe".equals(((GridColumnItem)column.get(j)).getColumnType())) {
                    columnJsonObject.put("editUrl", (Object)((GridColumnItem)column.get(j)).getEditUrl());
                    columnJsonObject.put("openWidth", (Object)gridConfig.winWidth());
                    columnJsonObject.put("openHeight", (Object)gridConfig.winHeight());
                    if (!GridUtil.isPermitted(((GridColumnItem)column.get(j)).getEditPermission())) {
                        columnJsonObject.put("isNoEdit", (Object)true);
                    }
                } else if ("sub_row_grid".equals(((GridColumnItem)column.get(j)).getColumnType())) {
                    columnJsonObject.put("subVo", (Object)((GridColumnItem)column.get(j)).getSubVo());
                    columnJsonObject.put("subQuery", (Object)((GridColumnItem)column.get(j)).getSubQuery());
                    columnJsonObject.put("subOptions", (Object)GridUtil.getGridHeader(((GridColumnItem)column.get(j)).getSubVo(), "sub"));
                }
                columnJsonObject.put("sort", (Object)((GridColumnItem)column.get(j)).getSort());
            }
            columnJsonObject.put("width", (Object)((GridColumnItem)column.get(j)).getWidth());
            columnJsonObject.put("label", (Object)I18nUtil.i18nCode((String)((GridColumnItem)column.get(j)).getLabel(), (Object[])new Object[0]));
            columnJsonObject.put("valign", (Object)((GridColumnItem)column.get(j)).getValign());
            if (!"".equals(((GridColumnItem)column.get(j)).getConvert())) {
                columnJsonObject.put("convert", (Object)((GridColumnItem)column.get(j)).getConvert());
            }
            if (!"".equals(((GridColumnItem)column.get(j)).getKey())) {
                columnJsonObject.put("key", (Object)((GridColumnItem)column.get(j)).getKey());
            }
            if (!"".equals(((GridColumnItem)column.get(j)).getSecHeader())) {
                columnJsonObject.put("secHeader", (Object)I18nUtil.i18nCode((String)((GridColumnItem)column.get(j)).getSecHeader(), (Object[])new Object[0]));
            }
            jsonArray.add((Object)columnJsonObject);
            if (((GridColumnItem)column.get(j)).getColumnType().equals("ch") || ((GridColumnItem)column.get(j)).isCheckbox() || ((GridColumnItem)column.get(j)).getColumnType().equals("ra")) {
                minWidthBuffer.append("40,");
                continue;
            }
            minWidthBuffer.append(((GridColumnItem)column.get(j)).getMinWidth() + ",");
        }
        if (gridConfig != null && gridConfig.operate() && GridUtil.showOperateColumn(gridConfig)) {
            minWidthBuffer.append(gridConfig.minWidth() + ",");
            columnTypes.append("operate,");
            columnJsonObject = new JSONObject();
            columnJsonObject.put("width", (Object)"*");
            columnJsonObject.put("valign", (Object)"middle");
            columnJsonObject.put("id", (Object)ZK_GRID_OP);
            columnJsonObject.put("label", (Object)I18nUtil.i18nCode((String)"common_relatedOp", (Object[])new Object[0]));
            columnJsonObject.put("sort", (Object)"na");
            columnJsonObject.put("type", (Object)"ro");
            columnJsonObject.put("align", (Object)"left");
            JSONArray operates = new JSONArray();
            GridOperate[] gridOperates = gridConfig.operates();
            JSONObject opJson = null;
            for (int i = 0; i < gridOperates.length; ++i) {
                opJson = new JSONObject();
                opJson.put("type", (Object)gridOperates[i].type());
                opJson.put("permission", (Object)gridOperates[i].permission());
                if ("edit".equals(gridOperates[i].type())) {
                    opJson.put("openHeight", (Object)gridConfig.winHeight());
                    opJson.put("openWidth", (Object)gridConfig.winWidth());
                }
                opJson.put("url", (Object)gridOperates[i].url());
                opJson.put("click", (Object)gridOperates[i].click());
                opJson.put("label", (Object)I18nUtil.i18nCode((String)gridOperates[i].label(), (Object[])new Object[0]));
                opJson.put("index", (Object)i);
                operates.add((Object)opJson);
            }
            columnJsonObject.put("operates", (Object)operates);
            jsonArray.add((Object)columnJsonObject);
        }
        columnJsonObject = (JSONObject)jsonArray.get(jsonArray.size() - 1);
        columnJsonObject.put("width", (Object)"*");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("columnTypes", (Object)columnTypes.substring(0, columnTypes.length() - 1).toString());
        jsonObject.put("minWidthBuffer", (Object)minWidthBuffer.substring(0, minWidthBuffer.length() - 1).toString());
        jsonObject.put("gridName", (Object)gridName);
        jsonObject.put("columns", (Object)jsonArray);
        return jsonObject;
    }

    private static boolean showGridColumn(GridColumn gridColumn) {
        if (gridColumn == null) {
            return false;
        }
        return GridUtil.showGridColumn(new GridColumnItem(gridColumn));
    }

    private static boolean showGridColumn(GridColumnItem gridColumn) {
        String showExpression;
        if (gridColumn == null) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)gridColumn.getShowHeader())) {
            try {
                ShowGridColumn show = (ShowGridColumn)SpringContextUtil.getBean((String)gridColumn.getShowHeader(), ShowGridColumn.class);
                return show.isShow(null);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        if (StringUtils.isBlank((CharSequence)(showExpression = gridColumn.getShowExpression()))) {
            return gridColumn.isShow();
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("language", (Object)LocaleMessageSourceUtil.language);
        boolean show = (Boolean)parser.parseExpression(showExpression).getValue((EvaluationContext)context, Boolean.class);
        return show;
    }

    private static boolean showOperateColumn(GridConfig gridConfig) {
        if (gridConfig != null) {
            GridOperate[] operates;
            SecurityService securityService = (SecurityService)SpringContextUtil.getBean(SecurityService.class);
            if (securityService == null) {
                return true;
            }
            for (GridOperate operate : operates = gridConfig.operates()) {
                if (StringUtils.isNotBlank((CharSequence)operate.permission())) {
                    if (!securityService.checkPermission(WebContextUtil.getCurrentSessionId(), operate.permission())) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static List<GridOperate> getHavePermission(GridConfig gridConfig) {
        ArrayList<GridOperate> operateList = new ArrayList<GridOperate>();
        if (gridConfig != null) {
            SecurityService securityService = (SecurityService)SpringContextUtil.getBean(SecurityService.class);
            GridOperate[] operates = gridConfig.operates();
            if (securityService == null) {
                return Arrays.asList(operates);
            }
            for (GridOperate operate : operates) {
                if (StringUtils.isNotBlank((CharSequence)operate.permission())) {
                    if (!securityService.checkPermission(WebContextUtil.getCurrentSessionId(), operate.permission())) continue;
                    operateList.add(operate);
                    continue;
                }
                operateList.add(operate);
            }
            return operateList;
        }
        return operateList;
    }

    public static boolean isPermitted(String permission) {
        SecurityService securityService = (SecurityService)SpringContextUtil.getBean(SecurityService.class);
        if (securityService == null) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)permission)) {
            return securityService.checkPermission(WebContextUtil.getCurrentSessionId(), permission);
        }
        return true;
    }

    private static boolean checkEdit(GridColumn gridColumn) {
        if (gridColumn != null) {
            // empty if block
        }
        return false;
    }

    private static List<Field> getSortFields(Field[] fieldArray, String idField) {
        Field idF = null;
        ArrayList<Field> fileds = new ArrayList<Field>();
        GridColumn gridColumn = null;
        for (Field field : fieldArray) {
            field.setAccessible(true);
            gridColumn = field.getAnnotation(GridColumn.class);
            if (field.getName().equals(idField)) {
                idF = field;
                continue;
            }
            if (!GridUtil.showGridColumn(gridColumn)) continue;
            fileds.add(field);
        }
        Field[] array = new Field[fileds.size()];
        Field[] a = fileds.toArray(array);
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len - i - 1; ++j) {
                if (a[j].getAnnotation(GridColumn.class).sortNo() <= a[j + 1].getAnnotation(GridColumn.class).sortNo()) continue;
                Field temp = a[j];
                a[j] = a[j + 1];
                a[j + 1] = temp;
            }
        }
        ArrayList<Field> filedsList = new ArrayList<Field>();
        if (idField != null) {
            filedsList.add(idF);
        }
        filedsList.addAll(Arrays.asList(a));
        return filedsList;
    }

    public static DxGrid convert(Pager pager, Class itemCls) {
        DxGrid dxGrid = new DxGrid();
        dxGrid.setPos(Integer.valueOf(pager.getPage() * pager.getSize()));
        dxGrid.setTotal_count(Integer.valueOf(pager.getTotal()));
        if (TreeFormat.class.isAssignableFrom(itemCls)) {
            pager.setData(TreeBuilder.newTreeBuilder((Class)itemCls, String.class).buildToTreeList((Collection)pager.getData()));
        }
        dxGrid.setRows(GridUtil.itemFormat(pager.getData(), itemCls));
        return dxGrid;
    }

    private static Object convertTxt(String[] formatterArray, Object value) {
        for (String fm : formatterArray) {
            String[] keyArray = fm.split("=", 2);
            if (keyArray.length != 2 || !keyArray[0].equals(value + "")) continue;
            return GridUtil.i18Txt(keyArray[1]);
        }
        return value;
    }

    private static String i18Txt(String key) {
        return key;
    }

    private static Object getColumnEmptyLabel(Object val, String def, boolean i18n) {
        if (def != null && (val == null || StringUtils.isBlank((CharSequence)val.toString()))) {
            return i18n ? I18nUtil.i18nCode((String)def, (Object[])new Object[0]) : def;
        }
        if (i18n && val != null && val instanceof String) {
            return I18nUtil.i18nCode((String)val.toString(), (Object[])new Object[0]);
        }
        return val;
    }

    private static Object convertInitFlag(Object val, Object src, String type, boolean isNot) {
        if (val != null && type.equals("edit") && isNot) {
            try {
                Object flag = FieldUtils.readDeclaredField((Object)src, (String)"initFlag", (boolean)true);
                if (flag != null && flag.toString().equals("true")) {
                    return "INIT_ITEM" + val.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return val;
    }

    private static List<?> itemFormat(List<?> data, Class itemCls) {
        GridConfig gridConfig = itemCls.getAnnotation(GridConfig.class);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Field[] fields = itemCls.getDeclaredFields();
        List<Field> fieldList = GridUtil.getSortFields(fields, gridConfig.idField());
        try {
            JSONObject jsonObject = null;
            JSONArray jsonArray = null;
            Object id = null;
            HashMap<String, List<GridColumnItem>> dynamicColumnMap = new HashMap<String, List<GridColumnItem>>();
            List<GridColumnItem> column = null;
            List<GridOperate> havePermissionOperate = GridUtil.getHavePermission(gridConfig);
            for (Object obj : data) {
                jsonObject = new JSONObject();
                jsonArray = new JSONArray();
                for (Field f : fieldList) {
                    Object value;
                    GridColumn gridColumn;
                    if (gridConfig.idField().equals(f.getName())) {
                        jsonObject.put(gridConfig.idField(), GridUtil.getFieldValue(obj, f, itemCls));
                        id = GridUtil.getFieldValue(obj, f, itemCls);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(gridColumn = f.getAnnotation(GridColumn.class)).dynamicColumn())) {
                        column = (List<GridColumnItem>)dynamicColumnMap.get(f.getName());
                        if (Objects.isNull(column)) {
                            DynamicColumn dc = (DynamicColumn)SpringContextUtil.getBean((String)gridColumn.dynamicColumn(), DynamicColumn.class);
                            column = dc.getColumn(f.getName());
                            dynamicColumnMap.put(f.getName(), column);
                        }
                        Map map = (Map)GridUtil.getFieldValue(obj, f, itemCls);
                        for (int i = 0; i < column.size(); ++i) {
                            if (!GridUtil.showGridColumn(column.get(i))) continue;
                            if (column.get(i).isCheckbox()) {
                                jsonArray.add((Object)0);
                                continue;
                            }
                            value = map.get(column.get(i).getName());
                            if (value == null) {
                                jsonArray.add((Object)I18nUtil.i18nCode((String)column.get(i).getDefaultValue(), (Object[])new Object[0]));
                                continue;
                            }
                            if ((value = GridUtil.convertInitFlag(value, obj, column.get(i).getColumnType(), gridConfig.isInitNotEdit())) != null && column.get(i).getColumnType().equals("edit") && !GridUtil.isShowExtend(column.get(i).getFilter(), column.get(i).getShowConvertor(), obj) && !value.toString().startsWith("INIT_ITEM")) {
                                jsonArray.add((Object)("INIT_ITEM" + value.toString()));
                                continue;
                            }
                            jsonArray.add(value);
                        }
                        continue;
                    }
                    if (!GridUtil.showGridColumn(gridColumn)) continue;
                    if (gridColumn.checkbox()) {
                        jsonArray.add((Object)0);
                        continue;
                    }
                    if (f.getType() == Date.class || f.getType() == Timestamp.class) {
                        DateType dateType = f.getAnnotation(DateType.class);
                        String format = "yyyy-MM-dd HH:mm:ss";
                        if (dateType != null) {
                            switch (dateType.type()) {
                                case "date": {
                                    format = "yyyy-MM-dd";
                                    break;
                                }
                                case "time": {
                                    format = "HH:mm:ss";
                                    break;
                                }
                                case "timestamp": {
                                    format = "yyyy-MM-dd HH:mm:ss";
                                }
                            }
                        }
                        if ((value = GridUtil.getFieldValue(obj, f, itemCls)) == null) {
                            jsonArray.add((Object)I18nUtil.i18nCode((String)gridColumn.defaultValue(), (Object[])new Object[0]));
                            continue;
                        }
                        jsonArray.add((Object)DateUtil.dateToString((Date)((Date)value), (String)format));
                        continue;
                    }
                    String format = gridColumn.format();
                    Object value2 = GridUtil.getFieldValue(obj, f, itemCls);
                    if (StringUtils.isNotBlank((CharSequence)format)) {
                        jsonArray.add(GridUtil.getColumnEmptyLabel(GridUtil.getDictionaryVal(format, value2), gridColumn.defaultValue(), gridColumn.i18n()));
                        continue;
                    }
                    if ((value2 = GridUtil.convertInitFlag(GridUtil.getColumnEmptyLabel(value2, gridColumn.defaultValue(), gridColumn.i18n()), obj, gridColumn.columnType(), gridConfig.isInitNotEdit())) != null && gridColumn.columnType().equals("edit") && !GridUtil.isShowExtend(gridColumn.filter(), gridColumn.showConvertor(), obj) && !value2.toString().startsWith("INIT_ITEM")) {
                        jsonArray.add((Object)("INIT_ITEM" + value2.toString()));
                        continue;
                    }
                    jsonArray.add(value2);
                }
                if (gridConfig != null && gridConfig.operate() && havePermissionOperate.size() > 0) {
                    GridOperate[] gridOperates = gridConfig.operates();
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < gridOperates.length; ++i) {
                        if (!havePermissionOperate.contains(gridOperates[i]) || !GridUtil.isShowExtend(gridOperates[i].filter(), gridOperates[i].showConvertor(), obj)) continue;
                        if (gridConfig.isInitNotEdit() && gridOperates[i].type().equals("edit")) {
                            try {
                                Object flag = FieldUtils.readDeclaredField(obj, (String)"initFlag", (boolean)true);
                                if (flag != null && flag.toString().equals("true")) continue;
                                sb.append(i + ",");
                            }
                            catch (Exception e) {
                                sb.append(i + ",");
                            }
                            continue;
                        }
                        sb.append(i + ",");
                    }
                    jsonArray.add((Object)sb.toString());
                }
                jsonObject.put("data", (Object)jsonArray);
                if (TreeFormat.class.isAssignableFrom(itemCls) && ((TreeFormat)obj).hasChildren()) {
                    jsonObject.put("rows", GridUtil.itemFormat((List)((TreeFormat)obj).getChildren(), itemCls));
                }
                list.add(jsonObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static boolean isShowExtend(String className, String showConvertor, Object item) {
        try {
            if (StringUtils.isNotBlank((CharSequence)className)) {
                ShowGridColumn show = (ShowGridColumn)SpringContextUtil.getBean((String)className, ShowGridColumn.class);
                return show.isShow(item);
            }
            if (StringUtils.isNotBlank((CharSequence)showConvertor)) {
                return (Boolean)MethodUtils.invokeMethod((Object)item, (String)showConvertor, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static Object getFieldValue(Object obj, Field f, Class clazz) throws Exception {
        return f.get(obj);
    }

    public static String getDictionaryVal(String format, Object value) {
        if (value == null) {
            return "";
        }
        String[] formatArray = format.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String fa : formatArray) {
            String[] array = fa.split("=", 2);
            if (array.length != 2) continue;
            map.put(array[0], I18nUtil.i18nCode((String)array[1], (Object[])new Object[0]));
        }
        return map.containsKey(value.toString()) ? (String)map.get(value.toString()) : value + "";
    }
}

