/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class PropertiesListenerConfig {
    public static Map<String, String> systemPropertiesMap = new HashMap<String, String>();

    private static void processProperties(Properties props) throws BeansException {
        systemPropertiesMap = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            try {
                if (!keyStr.startsWith("system")) continue;
                systemPropertiesMap.put(keyStr, new String(props.getProperty(keyStr).getBytes("ISO-8859-1"), "utf-8"));
                if (!"system.skin".equals(keyStr)) continue;
                PropertiesListenerConfig.loadSkinProperties(systemPropertiesMap.get(keyStr));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadSkinProperties(String skin) {
        InputStream is;
        if (StringUtils.isNotBlank((CharSequence)skin) && (is = PropertiesListenerConfig.class.getResourceAsStream("/static/public/skins/" + skin + "/skin.properties")) != null) {
            try {
                Properties properties = new Properties();
                properties.load(is);
                for (Object key : properties.keySet()) {
                    String keyStr = key.toString();
                    try {
                        if (!keyStr.startsWith("system") || systemPropertiesMap.containsKey(keyStr)) continue;
                        systemPropertiesMap.put(keyStr, new String(properties.getProperty(keyStr).getBytes("ISO-8859-1"), "utf-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadAllProperties(String propertyFileName) {
        try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties((String)propertyFileName);
            PropertiesListenerConfig.processProperties(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getProperty(String name) {
        return systemPropertiesMap.get(name).toString();
    }

    public static Map<String, String> getSystemProperty() {
        return systemPropertiesMap;
    }
}

