/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseOpLogRemote;
import com.zkteco.zkbiosecurity.system.service.BaseOpLogService;
import com.zkteco.zkbiosecurity.system.vo.BaseOpLogItem;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseOpLogController
extends ExportController
implements BaseOpLogRemote {
    @Autowired
    private BaseOpLogService baseOpLogService;

    @RequiresPermissions(value={"system:opLog"})
    public ModelAndView index() {
        return new ModelAndView("system/opLog/baseOpLog");
    }

    @RequiresPermissions(value={"system:opLog:refresh"})
    public DxGrid list(BaseOpLogItem condition) {
        Pager pager = this.baseOpLogService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:opLog:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        BaseOpLogItem baseOpLogItem = new BaseOpLogItem();
        this.setConditionValue((BaseItem)baseOpLogItem);
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        List itemList = this.baseOpLogService.getItemData(request.getSession().getId(), BaseOpLogItem.class, baseOpLogItem, beginIndex, endIndex);
        this.excelExport(itemList, BaseOpLogItem.class);
    }
}

