/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.aop;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.NetworkUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.system.service.BaseOpLogService;
import com.zkteco.zkbiosecurity.system.vo.BaseOpLogItem;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OpLogAspect {
    @Autowired
    BaseOpLogService baseOpLogService;
    private static final Logger log = LoggerFactory.getLogger(OpLogAspect.class);

    @Around(value="@annotation(logRequest)")
    public Object doInterceptor(ProceedingJoinPoint pjp, LogRequest logRequest) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = null;
        BaseOpLogItem log = new BaseOpLogItem();
        short opResult = 0;
        try {
            if (WebContextUtil.getCurrentRequest() != null) {
                HttpServletRequest httpServletRequest = WebContextUtil.getCurrentRequest();
                String ip = NetworkUtil.getIpAddr((HttpServletRequest)httpServletRequest);
                log.setOpIp(ip);
                SecuritySubject securitySubject = this.baseOpLogService.getCurrentUser(httpServletRequest.getSession().getId());
                if (securitySubject != null) {
                    log.setOpUserId(securitySubject.getUserId());
                    log.setOpUsername(securitySubject.getUserCode());
                } else if (httpServletRequest.getRequestURI().contains("login.do")) {
                    log.setOpUsername(httpServletRequest.getParameter("username"));
                }
                log.setOpSys(I18nUtil.i18nCode((String)logRequest.module(), (Object[])new Object[0]));
                log.setOpObject(I18nUtil.i18nCode((String)logRequest.object(), (Object[])new Object[0]));
                if (logRequest.opType().equals("common_op_edit") && StringUtils.isBlank((CharSequence)httpServletRequest.getParameter("id"))) {
                    log.setOpType(I18nUtil.i18nCode((String)"common_op_new", (Object[])new Object[0]));
                } else {
                    log.setOpType(I18nUtil.i18nCode((String)logRequest.opType(), (Object[])new Object[0]));
                }
                log.setOpTime(new Date());
                if (StringUtils.isNotBlank((CharSequence)logRequest.opContent())) {
                    log.setContent(I18nUtil.i18nCode((String)logRequest.opContent(), (Object[])new Object[0]));
                } else {
                    log.setContent("");
                }
                String[] params = logRequest.requestParams();
                if (params != null && params.length > 0) {
                    StringBuffer psb = new StringBuffer();
                    for (String p : params) {
                        String s = httpServletRequest.getParameter(p);
                        if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                        psb.append(s + ";");
                    }
                    log.setContent(log.getContent() + ":" + psb.toString());
                }
                if (StringUtils.isBlank((CharSequence)log.getContent())) {
                    log.setContent(pjp.getTarget().toString());
                }
            }
            result = pjp.proceed();
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                String msg = I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]);
                ZKBusinessException ee = (ZKBusinessException)e;
                if (Objects.nonNull(ee.getObjects())) {
                    msg = I18nUtil.i18nCode((String)e.getMessage(), (Object[])ee.getObjects());
                }
                log.setContent(msg);
            } else {
                log.setContent(e.getMessage());
            }
            opResult = 1;
            log.setOpResult(Short.valueOf(opResult));
            throw e;
        }
        finally {
            log.setOpResult(Short.valueOf(opResult));
            log.setCostTime(Integer.valueOf((int)(System.currentTimeMillis() - startTime)));
            this.baseOpLogService.saveItem(log);
        }
        return result;
    }
}

