/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleTransactionPersonFloorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.vo.EleTransactionPersonFloorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EleTransactionPersonFloorController
extends ExportController
implements EleTransactionPersonFloorRemote {
    @Autowired
    private EleFloorService eleFloorService;

    @RequiresPermissions(value={"ele:transactionByPerson:refresh"})
    public DxGrid list(EleTransactionPersonFloorItem condition) {
        Pager pager = this.eleFloorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:transactionByPerson:export"})
    @LogRequest(module="ele_module", object="common_leftMenu_searchByPerson", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleTransactionPersonFloorItem eleTransactionPersonFloorItem = new EleTransactionPersonFloorItem();
        this.setConditionValue((BaseItem)eleTransactionPersonFloorItem);
        List itemList = this.eleFloorService.getPersonFloorItemData(EleTransactionPersonFloorItem.class, (BaseItem)eleTransactionPersonFloorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleTransactionPersonFloorItem.class);
    }
}

