/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleGlobalLinkageVidRemote;
import com.zkteco.zkbiosecurity.ele.service.EleGlobalLinkageVidService;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageVidItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleGlobalLinkageVidController
extends BaseController
implements EleGlobalLinkageVidRemote {
    @Autowired
    private EleGlobalLinkageVidService eleGlobalLinkageVidService;

    @RequiresPermissions(value={"ele:globalLinkageVid"})
    public ModelAndView index() {
        return new ModelAndView("ele/globalLinkageVid/eleGlobalLinkageVid");
    }

    @RequiresPermissions(value={"ele:globalLinkageVid:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleGlobalLinkageVidService.getItemById(id));
        }
        return new ModelAndView("ele/globalLinkageVid/editEleGlobalLinkageVid");
    }

    @RequiresPermissions(value={"ele:globalLinkageVid:edit"})
    public ZKResultMsg save(EleGlobalLinkageVidItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleGlobalLinkageVidService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:globalLinkageVid:refresh"})
    public DxGrid list(EleGlobalLinkageVidItem condition) {
        Pager pager = this.eleGlobalLinkageVidService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:globalLinkageVid:del"})
    public ZKResultMsg del(String ids) {
        this.eleGlobalLinkageVidService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

