/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleGlobalLinkageOutRemote;
import com.zkteco.zkbiosecurity.ele.service.EleGlobalLinkageOutService;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageOutItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleGlobalLinkageOutController
extends BaseController
implements EleGlobalLinkageOutRemote {
    @Autowired
    private EleGlobalLinkageOutService eleGlobalLinkageOutService;

    @RequiresPermissions(value={"ele:globalLinkageOut"})
    public ModelAndView index() {
        return new ModelAndView("ele/globalLinkageOut/eleGlobalLinkageOut");
    }

    @RequiresPermissions(value={"ele:globalLinkageOut:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleGlobalLinkageOutService.getItemById(id));
        }
        return new ModelAndView("ele/globalLinkageOut/editEleGlobalLinkageOut");
    }

    @RequiresPermissions(value={"ele:globalLinkageOut:edit"})
    public ZKResultMsg save(EleGlobalLinkageOutItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleGlobalLinkageOutService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:globalLinkageOut:refresh"})
    public DxGrid list(EleGlobalLinkageOutItem condition) {
        Pager pager = this.eleGlobalLinkageOutService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:globalLinkageOut:del"})
    public ZKResultMsg del(String ids) {
        this.eleGlobalLinkageOutService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

