/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleAuxOutRemote;
import com.zkteco.zkbiosecurity.ele.service.EleAuxOutService;
import com.zkteco.zkbiosecurity.ele.vo.EleAuxOutItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleAuxOutController
extends BaseController
implements EleAuxOutRemote {
    @Autowired
    private EleAuxOutService eleAuxOutService;

    @RequiresPermissions(value={"ele:auxOut"})
    public ModelAndView index() {
        return new ModelAndView("ele/auxOut/eleAuxOut");
    }

    @RequiresPermissions(value={"ele:auxOut:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleAuxOutService.getItemById(id));
        }
        return new ModelAndView("ele/auxOut/editEleAuxOut");
    }

    @RequiresPermissions(value={"ele:auxOut:edit"})
    public ZKResultMsg save(EleAuxOutItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleAuxOutService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:auxOut:refresh"})
    public DxGrid list(EleAuxOutItem condition) {
        Pager pager = this.eleAuxOutService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:auxOut:del"})
    public ZKResultMsg del(String ids) {
        this.eleAuxOutService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

