/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.dashboard.init;

import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=530)
public class DashboardInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private AuthInitDataProvider authInitDataProvider;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.language}")
    private String language;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("DashboardInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.baseSysParamService.setAlreadyInitModule("DashboardInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = null;
        AuthPermissionItem topMenuItem = null;
        Object subMenuItem = null;
        Object subButtonItem = null;
        systemItem = this.authPermissionService.getItemByCode("System");
        topMenuItem = new AuthPermissionItem("Dashboard", "base_param_dashboardChart", "dashboard", "dashboard_menu", "true", Integer.valueOf(999));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem = this.authInitDataProvider.initPermissionData(topMenuItem);
    }
}

