/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionKeyRef;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class NativeKeyHolder {
    private static long nativeKeyWrapperKeyID = 0L;
    private static CK_MECHANISM nativeKeyWrapperMechanism = null;
    private static long nativeKeyWrapperRefCount = 0L;
    private static Session nativeKeyWrapperSession = null;
    private final P11Key p11Key;
    private final byte[] nativeKeyInfo;
    private boolean wrapperKeyUsed;
    private long keyID;
    private SessionKeyRef ref;
    private int refCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNativeKeyWrapper(Token token) throws PKCS11Exception {
        assert (nativeKeyWrapperKeyID == 0L);
        assert (nativeKeyWrapperRefCount == 0L);
        assert (nativeKeyWrapperSession == null);
        CK_ATTRIBUTE[] wrappingAttributes = token.getAttributes("generate", 4L, 31L, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, 32L)});
        Session s = null;
        try {
            s = token.getObjSession();
            nativeKeyWrapperKeyID = token.p11.C_GenerateKey(s.id(), new CK_MECHANISM(4224L), wrappingAttributes);
            nativeKeyWrapperSession = s;
            nativeKeyWrapperSession.addObject();
            byte[] iv = new byte[16];
            JCAUtil.getSecureRandom().nextBytes(iv);
            nativeKeyWrapperMechanism = new CK_MECHANISM(4229L, iv);
        }
        catch (PKCS11Exception pKCS11Exception) {
        }
        finally {
            token.releaseSession(s);
        }
    }

    private static void deleteNativeKeyWrapper() {
        Token token = NativeKeyHolder.nativeKeyWrapperSession.token;
        if (token.isValid()) {
            Session s = null;
            try {
                s = token.getOpSession();
                token.p11.C_DestroyObject(s.id(), nativeKeyWrapperKeyID);
                nativeKeyWrapperSession.removeObject();
            }
            catch (PKCS11Exception pKCS11Exception) {
            }
            finally {
                token.releaseSession(s);
            }
        }
        nativeKeyWrapperKeyID = 0L;
        nativeKeyWrapperMechanism = null;
        nativeKeyWrapperSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void decWrapperKeyRef() {
        Class<NativeKeyHolder> clazz = NativeKeyHolder.class;
        synchronized (NativeKeyHolder.class) {
            assert (nativeKeyWrapperKeyID != 0L);
            assert (nativeKeyWrapperRefCount > 0L);
            if (--nativeKeyWrapperRefCount == 0L) {
                NativeKeyHolder.deleteNativeKeyWrapper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    NativeKeyHolder(P11Key p11Key, long keyID, Session keySession, boolean extractKeyInfo, boolean isTokenObject) {
        this.p11Key = p11Key;
        this.keyID = keyID;
        this.refCount = -1;
        byte[] ki = null;
        if (isTokenObject) {
            this.ref = null;
        } else {
            Token token = p11Key.token;
            if (extractKeyInfo) {
                try {
                    if (p11Key.sensitive) {
                        Class<NativeKeyHolder> clazz = NativeKeyHolder.class;
                        // MONITORENTER : sun.security.pkcs11.NativeKeyHolder.class
                        if (nativeKeyWrapperKeyID == 0L) {
                            NativeKeyHolder.createNativeKeyWrapper(token);
                        }
                        if (nativeKeyWrapperKeyID != 0L) {
                            ++nativeKeyWrapperRefCount;
                            this.wrapperKeyUsed = true;
                        }
                        // MONITOREXIT : clazz
                    }
                    Session opSession = null;
                    try {
                        opSession = token.getOpSession();
                        ki = p11Key.token.p11.getNativeKeyInfo(opSession.id(), keyID, nativeKeyWrapperKeyID, nativeKeyWrapperMechanism);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                    }
                    finally {
                        token.releaseSession(opSession);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    // empty catch block
                }
            }
            this.ref = new SessionKeyRef(p11Key, keyID, this.wrapperKeyUsed, keySession);
        }
        this.nativeKeyInfo = ki == null || ki.length == 0 ? null : ki;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getKeyID() throws ProviderException {
        if (this.nativeKeyInfo == null) return this.keyID;
        byte[] byArray = this.nativeKeyInfo;
        synchronized (this.nativeKeyInfo) {
            if (this.refCount == -1) {
                this.refCount = 0;
            }
            int cnt = this.refCount++;
            if (this.keyID == 0L) {
                if (cnt != 0) {
                    throw new RuntimeException("Error: null keyID with non-zero refCount " + cnt);
                }
                Token token = this.p11Key.token;
                Session session = null;
                try {
                    session = token.getObjSession();
                    this.keyID = token.p11.createNativeKey(session.id(), this.nativeKeyInfo, nativeKeyWrapperKeyID, nativeKeyWrapperMechanism);
                    this.ref.registerNativeKey(this.keyID, session);
                }
                catch (PKCS11Exception e) {
                    --this.refCount;
                    throw new ProviderException("Error recreating native key", e);
                }
                finally {
                    token.releaseSession(session);
                }
            } else {
                if (cnt >= 0) return this.keyID;
                throw new RuntimeException("ERROR: negative refCount");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.keyID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void releaseKeyID() {
        if (this.nativeKeyInfo == null) return;
        byte[] byArray = this.nativeKeyInfo;
        synchronized (this.nativeKeyInfo) {
            int cnt;
            if (this.refCount == -1) {
                throw new RuntimeException("Error: miss match getKeyID call");
            }
            if ((cnt = --this.refCount) == 0) {
                if (this.keyID == 0L) {
                    throw new RuntimeException("ERROR: null keyID can't be destroyed");
                }
                this.keyID = 0L;
                this.ref.removeNativeKey();
            } else {
                if (cnt >= 0) return;
                throw new RuntimeException("wrong refCount value: " + cnt);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

