/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.biz;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.HttpUtil;
import com.zkteco.zkbiosecurity.guard.LicenseContextUtil;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.Continent;
import com.zkteco.zkbiosecurity.guard.license.bean.LicCompany;
import com.zkteco.zkbiosecurity.guard.license.bean.LicError;
import com.zkteco.zkbiosecurity.guard.license.bean.LicInfo;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.util.LicCheckUtilFacade;
import com.zkteco.zkbiosecurity.guard.license.util.LicFileHelper;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class LicenseFileBiz {
    private static final Logger logger = LoggerFactory.getLogger(LicenseFileBiz.class);
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    @Autowired(required=false)
    private LicenseCheckInnerInvoke[] licenseCheckInnerInvoke;
    @Autowired
    private Environment environment;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${system.version:1.0.0_R}")
    private String systemVersion;

    public void cancelLicense() {
        LicFileHelper.deleteLicFile();
        LicenseUtil.reloadLicense(this.moduleAuths);
        LicenseContextUtil.setValue("companyName", "");
        LicenseContextUtil.setValue("companyEmailToken", "");
        try {
            if (this.licenseCheckInnerInvoke != null) {
                for (LicenseCheckInnerInvoke checkInnerInvoke : this.licenseCheckInnerInvoke) {
                    checkInnerInvoke.cancelLicence();
                }
            }
        }
        catch (ZKBusinessException e) {
            logger.info(e.getMessage());
        }
    }

    public boolean hasLicenseId() {
        String id = LicFileHelper.readLicId(LicFileHelper.getLicPath());
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id});
    }

    public String combineModuleVersion() {
        return "base:" + this.systemVersion;
    }

    public void validateLicense(boolean isValidate, String companyName, String license) {
        this.validateLicenseInfo(isValidate, companyName, license, false);
    }

    public void validateSn(boolean isValidate, String companyName, String sn) {
        this.validateLicenseInfo(isValidate, companyName, sn, true);
    }

    public void validateLicenseInfo(boolean isValidate, String companyName, String licInfo, boolean isSn) {
        String platFormVersion = this.environment.getProperty("base.version");
        ModuleBean moduleBean = null;
        moduleBean = isSn ? LicCheckUtilFacade.getSnModuleBean(licInfo) : LicCheckUtilFacade.getLicenseModuleBean(licInfo);
        if (moduleBean != null) {
            int crcSn;
            int crcM;
            Boolean flag = false;
            try {
                if (this.applicationContext.containsBean("industryCodeUtil")) {
                    Object object = this.applicationContext.getBean("industryCodeUtil");
                    Method method = object.getClass().getDeclaredMethod("getIndustryCode", new Class[0]);
                    method.setAccessible(true);
                    if (moduleBean.getExtCode() != 1 && moduleBean.getExtCode() != ((Integer)method.invoke(object, new Object[0])).intValue()) {
                        flag = true;
                    }
                }
            }
            catch (Exception object) {
                // empty catch block
            }
            if (flag.booleanValue()) {
                throw new ZKBusinessException("LicenseError:E0011");
            }
            if (!isValidate && LicenseUtil.isLocal() && (crcM = LicCheckUtilFacade.genCRC16(companyName)) != (crcSn = moduleBean.getCompanyNameCrc16())) {
                throw new ZKBusinessException("auth_license_companyNameCheckError");
            }
            if (!LicenseUtil.langMatch(moduleBean.getLanguagePack())) {
                throw new ZKBusinessException("LicenseError:E0011");
            }
            return;
        }
        throw new ZKBusinessException("LicenseError:E0008");
    }

    public void postLicinfoRecept(LicInfo licInfoRece, boolean validate) {
        String licID = LicFileHelper.readLicId(LicFileHelper.getLicPath());
        if (licID != null && !"".equals(licID) && !licInfoRece.getId().replaceAll("\r|\n", "").equals(licID)) {
            throw ZKBusinessException.warnException((String)"auth_license_erretxt_repeatid", (Object[])new Object[]{licID, licInfoRece.getId().replaceAll("\r|\n", "")});
        }
        String errorMsg = this.processLicenseError(licInfoRece);
        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
            throw new ZKBusinessException(errorMsg);
        }
        if (licInfoRece == null || licInfoRece.getModules() == null || licInfoRece.getModules().isEmpty()) {
            throw new ZKBusinessException("auth_license_moduleEmpty");
        }
        LicCompany company = licInfoRece.getCompany();
        if (StringUtils.isBlank((CharSequence)company.getEmail()) || StringUtils.isBlank((CharSequence)company.getName())) {
            throw new ZKBusinessException("auth_license_incompleteCompanyInfo");
        }
        List<LicModule> modules = licInfoRece.getModules();
        for (LicModule module : modules) {
            this.validateLicense(validate, company.getName(), module.getLicenseNumber());
        }
        LicFileHelper.updateModules(LicFileHelper.getLicPath(), modules);
        company.setValidate(true);
        LicFileHelper.writeLicCompany(LicFileHelper.getLicPath(), company);
        LicFileHelper.writeLicUidCard(LicFileHelper.getLicPath(), licInfoRece.getUidcard());
        LicFileHelper.writeLicId(LicFileHelper.getLicPath(), licInfoRece.getId());
        logger.info("update license info to lic file ....");
        try {
            LicenseUtil.reloadLicense(this.moduleAuths);
            LicenseContextUtil.setValue("companyName", company.getName());
            LicenseContextUtil.setValue("client_licenseId", LicFileHelper.readLicId(LicFileHelper.getLicPath()));
            LicenseContextUtil.setValue("client_company", company);
            LicenseContextUtil.setValue("companyEmailToken", company.getEmail());
            try {
                if (this.licenseCheckInnerInvoke != null) {
                    for (LicenseCheckInnerInvoke checkInnerInvoke : this.licenseCheckInnerInvoke) {
                        checkInnerInvoke.activateSuccess();
                    }
                }
            }
            catch (ZKBusinessException e) {
                logger.info(e.getMessage());
            }
            logger.info("reload license to system ....");
        }
        catch (Exception ex) {
            throw new ZKBusinessException("auth_license_reloadFailed", (Throwable)ex);
        }
    }

    private String processLicenseError(LicInfo licInfoRece) {
        if (licInfoRece != null && licInfoRece.getErrors() != null) {
            List<LicError> errors = licInfoRece.getErrors();
            String errMsg = null;
            if (!errors.isEmpty()) {
                errMsg = "LicenseError:";
                HashSet es = Sets.newHashSet();
                if (!errors.isEmpty()) {
                    for (LicError error : errors) {
                        if (error.getCode().equals("2")) {
                            es.add(error.getCode() + "[" + error.getMessage() + "]");
                            continue;
                        }
                        es.add(error.getCode());
                    }
                }
                for (String e : es) {
                    errMsg = errMsg + e + ",";
                }
                errMsg = errMsg.substring(0, errMsg.length() - 1);
            }
            return errMsg;
        }
        return null;
    }

    public List<SelectItem> getLicenseContinents(String ... continentCode) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        Object item = null;
        Object pItem = null;
        String code = null;
        if (continentCode != null && continentCode.length > 0) {
            code = continentCode[0];
        }
        for (Continent continent : Continent.values()) {
            SelectItem selectBean = new SelectItem();
            selectBean.setValue(continent.getCode());
            selectBean.setText((Object)continent.getI18n());
            items.add(selectBean);
        }
        return items;
    }

    public boolean noNeedToPrompt() {
        String promptDaysStr = this.environment.getProperty("license.prompt.days");
        int promptDays = Integer.parseInt(StringUtils.isBlank((CharSequence)promptDaysStr) ? "3" : promptDaysStr);
        int maxLicenseLeft = LicenseUtil.getLicenseContext().getMaxLicenseLeft();
        if (maxLicenseLeft > promptDays) {
            return true;
        }
        int trialLeft = LicenseUtil.getLicenseContext().getTrialLeft();
        return trialLeft > promptDays;
    }

    public String getEmailValidateCode(String email) {
        String emailSendUrl = this.environment.getProperty("licenseEmailUrl");
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("email", email);
        String rsp = HttpUtil.post((String)emailSendUrl, (Map)params);
        return rsp;
    }

    public String postUpk(LicInfo licInfo) {
        ConcurrentMap params = Maps.newConcurrentMap();
        String req = JSONObject.toJSONString((Object)licInfo);
        logger.info("req of post upk to license server: " + req);
        params.put("xmlInfo", req);
        String url = this.environment.getProperty("licenseAuthUrl");
        System.out.println(url);
        HttpUtil.Response rsp = HttpUtil.postAsResponse((String)url, (Map)params);
        System.out.println(rsp);
        logger.info("rsp of post upk from license server:\r\n " + rsp.getStringContent());
        if (rsp.getStatusLine().getStatusCode() != 200) {
            logger.error("get upk exception in license server!");
            throw new ZKBusinessException("400", "auth_license_serverError");
        }
        return rsp.getStringContent();
    }

    public String getLicenseUpdate() {
        String id = LicFileHelper.readLicId(LicFileHelper.getLicPath());
        HashMap params = Maps.newHashMap();
        params.put("licenseID", id);
        logger.info("licenseID of getLicenseUpdate: " + id);
        String url = this.environment.getProperty("licenseUpdateUrl");
        HttpUtil.Response rsp = HttpUtil.postAsResponse((String)url, (Map)params);
        logger.info("rsp of getLicenseUpdate: \r\n" + rsp.getStringContent());
        if (rsp.getStatusLine().getStatusCode() != 200) {
            logger.error("getLicenseUpdate exception in license server!");
            throw new ZKBusinessException("400", "auth_license_serverError");
        }
        return rsp.getStringContent();
    }
}

