/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.led.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.led.remote.LedLayoutModelRemote;
import com.zkteco.zkbiosecurity.led.service.LedLayoutModelService;
import com.zkteco.zkbiosecurity.led.service.LedTemplateLayoutService;
import com.zkteco.zkbiosecurity.led.vo.LedLayoutModelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LedLayoutModelController
extends BaseController
implements LedLayoutModelRemote {
    @Autowired
    private LedLayoutModelService ledLayoutModelService;
    @Autowired
    private LedTemplateLayoutService ledTemplateLayoutService;

    @RequiresPermissions(value={"led:layoutModel"})
    public ModelAndView index() {
        return new ModelAndView("led/layoutModel/ledLayoutModel");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ledLayoutModelService.getItemById(id));
            List templateLayoutItemList = this.ledTemplateLayoutService.findItemByLayoutModelId(id);
            JSONArray blockLayoutJsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)templateLayoutItemList));
            this.request.setAttribute("blockLayoutJsonArray", (Object)blockLayoutJsonArray.toString());
        }
        return new ModelAndView("led/layoutModel/editLedLayoutModel");
    }

    @LogRequest(module="base_module", object="docking_model_management", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(LedLayoutModelItem item) {
        String blockLayout = this.request.getParameter("blockLayoutJson");
        if (StringUtils.isNotBlank((CharSequence)blockLayout)) {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                this.ledLayoutModelService.synBlockLayoutToLed(item, blockLayout);
            }
            this.ledLayoutModelService.saveItem(item, blockLayout);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid list(LedLayoutModelItem condition) {
        Pager pager = this.ledLayoutModelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="base_module", object="docking_model_management", opType="common_op_del", requestParams={"codes", "names"}, opContent="docking_model_code")
    public ZKResultMsg del(String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String useModelName = this.ledLayoutModelService.delByLayoutModelIds(ids);
        if (StringUtils.isNotBlank((CharSequence)useModelName)) {
            useModelName = useModelName.substring(0, useModelName.length() - 1);
            zkResultMsg.setRet("fail");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"docking_model_delWarnMsg", (Object[])new Object[]{useModelName}));
        }
        return zkResultMsg;
    }

    public String validName(@RequestParam(value="name") String name) {
        LedLayoutModelItem item = this.ledLayoutModelService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getLayoutModelData(@RequestParam(value="id") String id) {
        ZKResultMsg msg = new ZKResultMsg();
        List templateLayoutItemList = this.ledTemplateLayoutService.findItemByLayoutModelId(id);
        JSONArray blockLayoutJsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)templateLayoutItemList));
        msg.setMsg(blockLayoutJsonArray.toString().replaceAll("\"", "'"));
        return msg;
    }

    public ZKResultMsg saveBlockModel() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String name = this.request.getParameter("name");
        String blockCount = this.request.getParameter("blockCount");
        String screenHeight = this.request.getParameter("screenHeight");
        String screenWidth = this.request.getParameter("screenWidth");
        String isShowTime = this.request.getParameter("isShowTime");
        String isShowTitle = this.request.getParameter("isShowTitle");
        String blockLayout = this.request.getParameter("blockLayoutJson");
        String isShowMultiLine = this.request.getParameter("isShowMultiLine");
        LedLayoutModelItem ledLayoutModelItem = new LedLayoutModelItem();
        ledLayoutModelItem.setName(name);
        ledLayoutModelItem.setBlockCount(Short.valueOf(Short.parseShort(blockCount)));
        ledLayoutModelItem.setScreenHeight(Short.valueOf(Short.parseShort(screenHeight)));
        ledLayoutModelItem.setScreenWidth(Short.valueOf(Short.parseShort(screenWidth)));
        ledLayoutModelItem.setIsShowMultiLine(Short.valueOf(Short.parseShort(isShowMultiLine)));
        if (StringUtils.isNotBlank((CharSequence)isShowTime) && "1".equals(isShowTime)) {
            ledLayoutModelItem.setShowTime(Boolean.valueOf(true));
        } else {
            ledLayoutModelItem.setShowTime(Boolean.valueOf(false));
        }
        if (StringUtils.isNotBlank((CharSequence)isShowTitle)) {
            ledLayoutModelItem.setShowTitle(Boolean.valueOf(true));
        } else {
            ledLayoutModelItem.setShowTitle(Boolean.valueOf(false));
        }
        if (StringUtils.isNotBlank((CharSequence)blockLayout)) {
            ledLayoutModelItem = this.ledLayoutModelService.saveItem(ledLayoutModelItem, blockLayout);
            zkResultMsg.setData((Object)ledLayoutModelItem);
        }
        return zkResultMsg;
    }
}

