/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.client.service.impl;

import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.vis.service.VisCloudService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedPersonItem;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisCloudServiceImpl
implements VisCloudService {
    private static final Logger logger = LoggerFactory.getLogger(VisCloudServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;

    public void syncPushVisitedPersonToCloud(List<VisVisitedPersonItem> visVisitedPersonItemList) {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visVisitedPersonItemList)) {
                List visVisitedPersonItemsList = CollectionUtil.split(visVisitedPersonItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudReservationHandleMessage#visitedPersonMessageHandle");
                visVisitedPersonItemsList.forEach(visVisitedPersonItems -> {
                    zkMessage.setListContent(visVisitedPersonItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            }
        }
        catch (Exception e) {
            logger.error("----VisCloudServiceImpl syncPushVisitedPersonToCloud error---:", (Throwable)e);
        }
    }

    public void asyncDelVisVisitedPersonToCloud(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List visVisitedPersonItems = this.visVisitedPersonService.getItemByIds(ids);
            this.delVisVisitedPersonToCloud(visVisitedPersonItems);
        }
    }

    public void asyncDelVisitedPersonToCloudByPersonId(String personIds) {
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            List visVisitedPersonItems = this.visVisitedPersonService.getItemByPersonIds(personIds);
            this.delVisVisitedPersonToCloud(visVisitedPersonItems);
        }
    }

    private void delVisVisitedPersonToCloud(List<VisVisitedPersonItem> visVisitedPersonItems) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visVisitedPersonItems)) {
            CompletableFuture.runAsync(() -> {
                Collection allPins = CollectionUtil.getPropertyList((Collection)visVisitedPersonItems, VisVisitedPersonItem::getPersonPin, (Object)"-1");
                List pinsList = CollectionUtil.split((Collection)allPins, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudReservationHandleMessage#delVisitedPersonByPin");
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                pinsList.forEach(pins -> {
                    zkMessage.setListContent(pins);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public void asyncPushTransactionToCloud(List<VisTransactionItem> visTransactionItemList) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visTransactionItemList)) {
            CompletableFuture.runAsync(() -> {
                List visTransactionItemsList = CollectionUtil.split((Collection)visTransactionItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudTransactionHandleMessage#handleTransactionMessage");
                visTransactionItemsList.forEach(visTransactionItems -> {
                    zkMessage.setListContent(visTransactionItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public void asyncPushVisReservationVisitedToCloud(List<VisReservationItem> visReservationItemList) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(visReservationItemList)) {
            CompletableFuture.runAsync(() -> {
                List visReservationItemsList = CollectionUtil.split((Collection)visReservationItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("vis");
                zkMessage.setMessageId("visCloudReservationHandleMessage#updateVisReservationVisited");
                visReservationItemsList.forEach(visReservationItems -> {
                    zkMessage.setListContent(visReservationItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public boolean isActiveLicense() {
        List activeModuleCodeList = this.baseLicenseProvider.getActiveModuleLIist();
        return activeModuleCodeList.contains("vis");
    }
}

